/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.datadump;

import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.datadump.PotionDump;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class PotionTypeDump
extends DataDump {
    private static final Field field_isSplashPotion = ObfuscationReflectionHelper.findField(PotionEffect.class, (String)"field_82723_d");

    protected PotionTypeDump(DataDump.Format format) {
        super(3, format);
    }

    public static List<String> getFormattedPotionTypeDump(DataDump.Format format) {
        PotionTypeDump potionTypeDump = new PotionTypeDump(format);
        for (Map.Entry entry : ForgeRegistries.POTION_TYPES.getEntries()) {
            PotionType potionType = (PotionType)entry.getValue();
            String regName = ((ResourceLocation)entry.getKey()).toString();
            String id = String.valueOf(PotionType.field_185176_a.func_148757_b((Object)potionType));
            List effects = potionType.func_185170_a();
            potionTypeDump.addData(regName, id, String.join((CharSequence)", ", PotionTypeDump.getEffectInfoLines(effects)));
        }
        potionTypeDump.addTitle("Registry name", "ID", "Effects");
        potionTypeDump.setColumnProperties(1, DataDump.Alignment.RIGHT, true);
        potionTypeDump.setUseColumnSeparator(true);
        return potionTypeDump.getLines();
    }

    public static String getPotionInfo(Potion potion) {
        String isBad = String.valueOf(potion.func_76398_f());
        String isBeneficial = PotionDump.getIsBeneficial(potion);
        return "Potion:[reg:" + potion.getRegistryName().toString() + ",name:" + potion.func_76393_a() + ",isBad:" + isBad + ",isBeneficial:" + isBeneficial + "]";
    }

    public static String getPotionEffectInfo(PotionEffect effect) {
        return String.format("PotionEffect:{%s,amplifier:%d,duration:%d,isSplashPotion:%s,isAmbient:%s}", PotionTypeDump.getPotionInfo(effect.func_188419_a()), effect.func_76458_c(), effect.func_76459_b(), PotionTypeDump.getIsSplashPotion(effect), effect.func_82720_e());
    }

    public static List<String> getEffectInfoLines(List<PotionEffect> effects) {
        ArrayList<String> effectStrs = new ArrayList<String>();
        for (PotionEffect effect : effects) {
            effectStrs.add(PotionTypeDump.getPotionEffectInfo(effect));
        }
        return effectStrs;
    }

    public static String getIsSplashPotion(PotionEffect effect) {
        try {
            return String.valueOf(field_isSplashPotion.get(effect));
        }
        catch (Exception e) {
            TellMe.logger.warn("Failed to reflect PotionEffect#isSplashPotion", (Throwable)e);
            return "";
        }
    }
}

