/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.datadump;

import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.datadump.ItemDump;
import fi.dy.masa.tellme.util.ItemType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryDump
extends DataDump {
    private OreDictionaryDump(int columns, DataDump.Format format) {
        super(columns, format);
    }

    public static List<String> getFormattedOreDictionaryDump(DataDump.Format format, OreDumpType type) {
        List<String> oreNames = Arrays.asList(OreDictionary.getOreNames());
        if (type == OreDumpType.BY_STACK) {
            OreDictionaryDump oreDictDump = new OreDictionaryDump(5, format);
            HashSet<ItemType> allStacks = new HashSet<ItemType>();
            for (String name : oreNames) {
                NonNullList stacks = OreDictionary.getOres((String)name);
                for (ItemStack stack : stacks) {
                    allStacks.add(new ItemType(stack));
                }
            }
            Iterator iter = allStacks.iterator();
            while (iter.hasNext()) {
                String strNBT;
                ItemStack stack = ((ItemType)iter.next()).getStack();
                int meta = stack.func_77960_j();
                String regName = stack.func_77973_b().getRegistryName().toString();
                String oreDictKeys = ItemDump.getOredictKeysJoined(stack);
                String string = strNBT = stack.func_77942_o() ? stack.func_77978_p().toString() : "";
                if (meta == Short.MAX_VALUE) {
                    oreDictDump.addData(regName, String.valueOf(meta), "(WILDCARD)", oreDictKeys, strNBT);
                    continue;
                }
                oreDictDump.addData(regName, String.valueOf(meta), stack.func_82833_r(), oreDictKeys, strNBT);
            }
            oreDictDump.addTitle("Registry name", "Meta/dmg", "Display name", "Ore Dict Keys", "NBT");
            oreDictDump.setColumnProperties(1, DataDump.Alignment.RIGHT, true);
            oreDictDump.setUseColumnSeparator(true);
            return oreDictDump.getLines();
        }
        if (type == OreDumpType.BY_ORE_GROUPED) {
            OreDictionaryDump oreDictDump = new OreDictionaryDump(2, format);
            for (String name : oreNames) {
                NonNullList stacks = OreDictionary.getOres((String)name);
                ArrayList<String> stackStrs = new ArrayList<String>();
                for (ItemStack stack : stacks) {
                    stackStrs.add(ItemDump.getStackInfo(stack));
                }
                oreDictDump.addData(name, String.join((CharSequence)"; ", stackStrs));
            }
            oreDictDump.addTitle("OreDict Key", "ItemStacks");
            oreDictDump.setUseColumnSeparator(true);
            return oreDictDump.getLines();
        }
        if (type == OreDumpType.BY_ORE_INDIVIDUAL) {
            OreDictionaryDump oreDictDump = new OreDictionaryDump(5, format);
            for (String oreName : oreNames) {
                NonNullList stacks = OreDictionary.getOres((String)oreName);
                for (ItemStack stack : stacks) {
                    String strNBT;
                    int meta = stack.func_77960_j();
                    String regName = stack.func_77973_b().getRegistryName().toString();
                    String string = strNBT = stack.func_77942_o() ? stack.func_77978_p().toString() : "";
                    if (meta == Short.MAX_VALUE) {
                        oreDictDump.addData(oreName, regName, String.valueOf(meta), "(WILDCARD)", strNBT);
                        continue;
                    }
                    oreDictDump.addData(oreName, regName, String.valueOf(meta), stack.func_82833_r(), strNBT);
                }
            }
            oreDictDump.addTitle("OreDict Key", "Registry name", "Meta/dmg", "Display name", "NBT");
            oreDictDump.setColumnProperties(2, DataDump.Alignment.RIGHT, true);
            oreDictDump.setUseColumnSeparator(true);
            return oreDictDump.getLines();
        }
        return Collections.emptyList();
    }

    public static enum OreDumpType {
        BY_STACK,
        BY_ORE_GROUPED,
        BY_ORE_INDIVIDUAL;

    }
}

