/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.datadump;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import fi.dy.masa.tellme.datadump.DataDump;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BlockStatesDump
extends DataDump {
    protected BlockStatesDump(int columns, DataDump.Format format) {
        super(columns, format);
    }

    public static List<String> getFormattedBlockStatesDumpByBlock() {
        ArrayList<String> outputLines = new ArrayList<String>();
        for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
            Block block = (Block)entry.getValue();
            ArrayList<String> lines = new ArrayList<String>();
            UnmodifiableIterator propIter = block.func_176223_P().func_177228_b().entrySet().iterator();
            while (propIter.hasNext()) {
                lines.add(((IProperty)((Map.Entry)propIter.next()).getKey()).toString());
            }
            outputLines.add(((ResourceLocation)entry.getKey()).toString() + ": " + String.join((CharSequence)", ", lines));
        }
        Collections.sort(outputLines);
        outputLines.add(0, "Block registry name | BlockState properties");
        outputLines.add(1, "-------------------------------------------------------------------------------------");
        return outputLines;
    }

    public static List<String> getFormattedBlockStatesDumpByState(DataDump.Format format) {
        BlockStatesDump blockStatesDump = new BlockStatesDump(2, format);
        for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
            Block block = (Block)entry.getValue();
            String regName = ((ResourceLocation)entry.getKey()).toString();
            ImmutableList validStates = block.func_176194_O().func_177619_a();
            for (IBlockState state : validStates) {
                ArrayList<String> lines = new ArrayList<String>();
                for (Map.Entry propEntry : state.func_177228_b().entrySet()) {
                    lines.add(((IProperty)propEntry.getKey()).func_177701_a() + "=" + ((Comparable)propEntry.getValue()).toString());
                }
                blockStatesDump.addData(regName, String.join((CharSequence)",", lines));
            }
        }
        blockStatesDump.addTitle("Block registry name", "BlockState properties");
        blockStatesDump.setUseColumnSeparator(true);
        return blockStatesDump.getLines();
    }
}

