/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.datadump;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.datadump.BiomeDump;
import fi.dy.masa.tellme.datadump.DataDump;
import fi.dy.masa.tellme.datadump.ItemDump;
import fi.dy.masa.tellme.util.ModNameUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BlockDump
extends DataDump {
    public static final Field field_blockHardness = ObfuscationReflectionHelper.findField(Block.class, (String)"field_149782_v");
    public static final Field field_blockResistance = ObfuscationReflectionHelper.findField(Block.class, (String)"field_149781_w");
    private boolean dumpNBT;

    private BlockDump(DataDump.Format format, boolean dumpNBT) {
        super(dumpNBT ? 10 : 9, format);
        this.dumpNBT = dumpNBT;
    }

    @Override
    public List<String> getLines() {
        if (this.getFormat() != DataDump.Format.ASCII) {
            return super.getLines();
        }
        ArrayList<String> lines = new ArrayList<String>();
        this.generateFormatStrings();
        lines.add(this.lineSeparator);
        lines.add("*** WARNING ***");
        lines.add("The block and item IDs are dynamic and will be different on each world!");
        lines.add("DO NOT use them for anything \"proper\"!! (other than manual editing/fixing of raw world data or something)");
        lines.add("*** ALSO ***");
        lines.add("The server doesn't have a list of sub block and sub items");
        lines.add("(= items with different damage value or blocks with different metadata).");
        lines.add("That is why the block and item list dumps only contain one entry per block/item class (separate ID) when run on a server.");
        lines.add("NOTE: The metadata value displayed is from the ItemStacks from getSubBlocks(), it's NOT necessarily the metadata value in world!!");
        lines.add("NOTE: For blocks, Subtypes = true is only based on the number of returned ItemStacks from getSubBlocks() being > 1");
        lines.add("NOTE: For blocks, Subtypes = ? means that Item.getItemFromBlock(block) returned null or the command was run on the server side");
        lines.add("The Exists column indicates whether the block currently exists in the game,");
        lines.add("or is just a placeholder dummy air block for a remove block read from the block ID map in the level.dat file");
        this.getFormattedData(lines);
        return lines;
    }

    public void addData(Block block, ResourceLocation rl, boolean subTypesKnown, boolean hasSubTypes, @Nonnull ItemStack stack) {
        String exists;
        String blockId = String.valueOf(Block.func_149682_b((Block)block));
        String modName = ModNameUtils.getModName(rl);
        String registryName = rl.toString();
        String displayName = !stack.func_190926_b() ? stack.func_82833_r() : block.func_149732_F();
        displayName = TextFormatting.func_110646_a((String)displayName);
        Item item = Item.func_150898_a((Block)block);
        String itemId = item != Items.field_190931_a ? String.valueOf(Item.func_150891_b((Item)item)) : "";
        String itemMeta = !stack.func_190926_b() ? String.valueOf(stack.func_77960_j()) : "";
        String subTypes = subTypesKnown ? String.valueOf(hasSubTypes) : "?";
        String string = exists = BlockDump.isDummied(ForgeRegistries.BLOCKS, rl) ? "false" : "true";
        if (this.dumpNBT) {
            String nbt = !stack.func_190926_b() && stack.func_77978_p() != null ? stack.func_77978_p().toString() : "";
            this.addData(modName, registryName, blockId, subTypes, itemId, itemMeta, displayName, exists, ItemDump.getOredictKeysJoined(stack), nbt);
        } else {
            this.addData(modName, registryName, blockId, subTypes, itemId, itemMeta, displayName, exists, ItemDump.getOredictKeysJoined(stack));
        }
    }

    public static List<String> getFormattedBlockDump(DataDump.Format format, boolean dumpNBT) {
        BlockDump blockDump = new BlockDump(format, dumpNBT);
        for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
            BlockDump.getDataForBlockSubtypes((Block)entry.getValue(), (ResourceLocation)entry.getKey(), blockDump);
        }
        if (dumpNBT) {
            blockDump.addTitle("Mod name", "Registry name", "BlockID", "Subtypes", "Item ID", "Item meta", "Display name", "Exists", "Ore Dict keys", "NBT");
        } else {
            blockDump.addTitle("Mod name", "Registry name", "BlockID", "Subtypes", "Item ID", "Item meta", "Display name", "Exists", "Ore Dict keys");
        }
        blockDump.setColumnProperties(2, DataDump.Alignment.RIGHT, true);
        blockDump.setColumnAlignment(3, DataDump.Alignment.RIGHT);
        blockDump.setColumnProperties(4, DataDump.Alignment.RIGHT, true);
        blockDump.setColumnProperties(5, DataDump.Alignment.RIGHT, true);
        blockDump.setUseColumnSeparator(true);
        return blockDump.getLines();
    }

    public static List<String> getFormattedBlockPropertiesDump(DataDump.Format format) {
        DataDump blockDump = new DataDump(4, format);
        try {
            for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
                ResourceLocation rl = (ResourceLocation)entry.getKey();
                String modName = ModNameUtils.getModName(rl);
                String registryName = rl.toString();
                Block block = (Block)entry.getValue();
                String hardness = String.format("%.2f", field_blockHardness.get(block));
                String resistance = String.format("%.2f", field_blockResistance.get(block));
                blockDump.addData(modName, registryName, hardness, resistance);
            }
            blockDump.addTitle("Mod name", "Registry name", "Hardness", "Resistance");
            blockDump.setColumnProperties(2, DataDump.Alignment.RIGHT, true);
            blockDump.setColumnProperties(3, DataDump.Alignment.RIGHT, true);
            blockDump.addHeader("NOTE: The Hardness and Resistance values are the raw base values in the fields");
            blockDump.addHeader("of the Block class in question. The actual final values may be different");
            blockDump.addHeader("for different states of the block, or they may depend on a TileEntity etc.");
            blockDump.addFooter("NOTE: The Hardness and Resistance values are the raw base values in the fields");
            blockDump.addFooter("of the Block class in question. The actual final values may be different");
            blockDump.addFooter("for different states of the block, or they may depend on a TileEntity etc.");
            blockDump.setUseColumnSeparator(true);
        }
        catch (Exception e) {
            TellMe.logger.warn("Exception while trying to get block-props dump", (Throwable)e);
        }
        return blockDump.getLines();
    }

    public static List<String> getBlockDumpIdToRegistryName(DataDump.Format format) {
        ArrayList<String> lines;
        block4: {
            ArrayList<BiomeDump.IdToStringHolder> data;
            block3: {
                data = new ArrayList<BiomeDump.IdToStringHolder>();
                lines = new ArrayList<String>();
                for (Block block : Block.field_149771_c) {
                    if (block == null || block.getRegistryName() == null) continue;
                    data.add(new BiomeDump.IdToStringHolder(Block.func_149682_b((Block)block), block.getRegistryName().toString()));
                }
                Collections.sort(data);
                if (format != DataDump.Format.ASCII) break block3;
                for (BiomeDump.IdToStringHolder holder : data) {
                    lines.add(String.valueOf(holder.getId()) + " = " + holder.getString());
                }
                break block4;
            }
            if (format != DataDump.Format.CSV) break block4;
            for (BiomeDump.IdToStringHolder holder : data) {
                lines.add(String.valueOf(holder.getId()) + ",\"" + holder.getString() + "\"");
            }
        }
        return lines;
    }

    public static void getDataForBlockSubtypes(Block block, ResourceLocation rl, BlockDump blockDump) {
        NonNullList stacks = NonNullList.func_191196_a();
        CreativeTabs tab = block.func_149708_J();
        block.func_149666_a(tab, stacks);
        if (stacks.size() > 0) {
            boolean hasSubTypes = stacks.size() > 1;
            for (ItemStack stack : stacks) {
                blockDump.addData(block, rl, true, hasSubTypes, stack);
            }
        } else {
            blockDump.addData(block, rl, false, false, ItemStack.field_190927_a);
        }
    }

    public static String getJsonBlockDump() {
        HashMultimap map = HashMultimap.create((int)400, (int)512);
        for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
            ResourceLocation key = (ResourceLocation)entry.getKey();
            map.put((Object)key.func_110624_b(), (Object)key);
        }
        ArrayList mods = Lists.newArrayList((Iterable)map.keySet());
        Collections.sort(mods);
        JsonObject root = new JsonObject();
        BlockDumpJsonDummy dump = new BlockDumpJsonDummy();
        for (String mod : mods) {
            ArrayList blocks = Lists.newArrayList((Iterable)map.get((Object)mod));
            Collections.sort(blocks);
            JsonObject objectMod = new JsonObject();
            for (ResourceLocation key : blocks) {
                JsonObject objBlock = new JsonObject();
                dump.setCurrentBlockObject(objBlock);
                BlockDump.getDataForBlockSubtypes((Block)ForgeRegistries.BLOCKS.getValue(key), key, dump);
                objectMod.add(key.toString(), (JsonElement)objBlock);
            }
            root.add(ModNameUtils.getModName((ResourceLocation)blocks.get(0)), (JsonElement)objectMod);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)root);
    }

    private static class BlockDumpJsonDummy
    extends BlockDump {
        private JsonObject obj;
        private boolean firstEntry;

        public BlockDumpJsonDummy() {
            super(DataDump.Format.CSV, false);
        }

        public void setCurrentBlockObject(JsonObject obj) {
            this.obj = obj;
            this.firstEntry = true;
        }

        @Override
        public void addData(Block block, ResourceLocation rl, boolean subTypesKnown, boolean hasSubTypes, @Nonnull ItemStack stack) {
            Item item;
            if (this.firstEntry) {
                int blockId = Block.func_149682_b((Block)block);
                String subTypes = subTypesKnown ? String.valueOf(hasSubTypes) : "?";
                String exists = BlockDumpJsonDummy.isDummied(ForgeRegistries.BLOCKS, rl) ? "false" : "true";
                String oreDictKeys = ItemDump.getOredictKeysJoined(stack);
                this.obj.add("BlockID", (JsonElement)new JsonPrimitive((Number)blockId));
                this.obj.add("SubTypes", (JsonElement)new JsonPrimitive(subTypes));
                this.obj.add("Exists", (JsonElement)new JsonPrimitive(exists));
                this.obj.add("OreDict", (JsonElement)new JsonPrimitive(oreDictKeys));
            }
            if ((item = stack.func_77973_b()) != Items.field_190931_a) {
                String itemName = item.getRegistryName().toString();
                int itemId = Item.func_150891_b((Item)item);
                int itemMeta = stack.func_77960_j();
                String displayName = !stack.func_190926_b() ? stack.func_82833_r() : block.func_149732_F();
                displayName = TextFormatting.func_110646_a((String)displayName);
                JsonObject objItem = new JsonObject();
                objItem.add("RegistryName", (JsonElement)new JsonPrimitive(itemName));
                objItem.add("ItemID", (JsonElement)new JsonPrimitive((Number)itemId));
                objItem.add("ItemMeta", (JsonElement)new JsonPrimitive((Number)itemMeta));
                objItem.add("DisplayName", (JsonElement)new JsonPrimitive(displayName));
                if (hasSubTypes) {
                    JsonArray arr;
                    if (this.firstEntry) {
                        arr = new JsonArray();
                        this.obj.add("Item", (JsonElement)arr);
                    } else {
                        arr = this.obj.get("Item").getAsJsonArray();
                    }
                    arr.add((JsonElement)objItem);
                } else {
                    this.obj.add("Item", (JsonElement)objItem);
                }
            }
            this.firstEntry = false;
        }
    }
}

