/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tellme.command;

import fi.dy.masa.tellme.TellMe;
import fi.dy.masa.tellme.command.CommandTellme;
import fi.dy.masa.tellme.command.ISubCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.ClickEvent;
import org.apache.commons.lang3.StringUtils;

public abstract class SubCommand
implements ISubCommand {
    protected final CommandTellme baseCommand;
    protected final ArrayList<String> subSubCommands = new ArrayList();
    private final Map<String, String> help = new HashMap<String, String>();
    private final Map<String, String> usage = new HashMap<String, String>();

    public SubCommand(CommandTellme baseCommand) {
        this.baseCommand = baseCommand;
        this.subSubCommands.add("help");
    }

    public CommandTellme getBaseCommand() {
        return this.baseCommand;
    }

    @Override
    public List<String> getSubCommands() {
        return this.subSubCommands;
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1 || args.length == 2 && args[0].equals("help")) {
            return CommandBase.func_175762_a((String[])args, this.getSubCommands());
        }
        return Collections.emptyList();
    }

    @Override
    public ITextComponent getHelp() {
        return new TextComponentString("Available sub-commands are: " + String.join((CharSequence)", ", this.subSubCommands));
    }

    protected String getSubCommandUsagePre() {
        return "/" + this.getBaseCommand().func_71517_b() + " " + this.getName();
    }

    protected void addSubCommandUsage(String subCommand, String usage) {
        this.usage.put(subCommand, usage);
    }

    protected String getSubCommandUsage(String subCommand) {
        return this.usage.get(subCommand);
    }

    protected void addSubCommandHelp(String subCommand, String help) {
        this.help.put(subCommand, help);
    }

    protected String getSubCommandHelp(String subCommand) {
        return this.help.get(subCommand);
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            sender.func_145747_a(this.getHelp());
        } else if (args.length == 1) {
            if (args[0].equals("help")) {
                sender.func_145747_a(this.getHelp());
            } else if (!this.subSubCommands.contains(args[0])) {
                throw new WrongUsageException("Unknown sub command '" + args[0] + "'", new Object[0]);
            }
        } else if (args.length == 2 && args[0].equals("help")) {
            if (args[1].equals("help")) {
                this.sendMessage(sender, "Gives information about the sub-commands", new Object[0]);
            } else if (this.subSubCommands.contains(args[1])) {
                String str = this.getSubCommandHelp(args[1]);
                if (!StringUtils.isBlank((CharSequence)str)) {
                    this.sendMessage(sender, str, new Object[0]);
                }
            } else {
                throw new WrongUsageException("Unknown sub command '" + args[1] + "'", new Object[0]);
            }
        }
    }

    protected void sendMessage(ICommandSender sender, String message, Object ... args) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(message, args));
    }

    public static String[] dropFirstStrings(String[] input, int toDrop) {
        if (toDrop >= input.length) {
            return new String[0];
        }
        String[] arr = new String[input.length - toDrop];
        System.arraycopy(input, toDrop, arr, 0, input.length - toDrop);
        return arr;
    }

    public static void sendClickableLinkMessage(ICommandSender sender, String messageKey, File file) {
        TextComponentString name = new TextComponentString(file.getName());
        if (TellMe.proxy.isSinglePlayer()) {
            name.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath()));
            name.func_150256_b().func_150228_d(Boolean.valueOf(true));
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(messageKey, new Object[]{name}));
    }

    public static BlockPos parseBlockPos(BlockPos base, String[] args, int startIndex, boolean centerBlock) throws NumberInvalidException {
        double x = CommandBase.func_175769_b((double)base.func_177958_n(), (String)args[startIndex], (int)-30000000, (int)30000000, (boolean)centerBlock);
        double y = CommandBase.func_175769_b((double)base.func_177956_o(), (String)args[startIndex + 1], (int)0, (int)256, (boolean)false);
        double z = CommandBase.func_175769_b((double)base.func_177952_p(), (String)args[startIndex + 2], (int)-30000000, (int)30000000, (boolean)centerBlock);
        return new BlockPos(x, y, z);
    }

    public static BlockPos parseBlockPosXZ(BlockPos base, String[] args, int startIndex, boolean centerBlock) throws NumberInvalidException {
        double x = CommandBase.func_175769_b((double)base.func_177958_n(), (String)args[startIndex], (int)-30000000, (int)30000000, (boolean)centerBlock);
        double z = CommandBase.func_175769_b((double)base.func_177952_p(), (String)args[startIndex + 1], (int)-30000000, (int)30000000, (boolean)centerBlock);
        return new BlockPos(x, 0.0, z);
    }

    public static int parseInt(String arg, int base) throws NumberInvalidException {
        return SubCommand.parseInt(arg, base, -30000000, 30000000);
    }

    public static int parseInt(String arg, int base, int min, int max) throws NumberInvalidException {
        return (int)CommandBase.func_175769_b((double)base, (String)arg, (int)min, (int)max, (boolean)false);
    }

    public static boolean isInteger(String arg) {
        try {
            Integer.parseInt(arg);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static int getNumberOfTrailingIntegers(String[] args) {
        return SubCommand.getNumberOfTrailingIntegers(args, args.length - 1);
    }

    public static int getNumberOfTrailingIntegers(String[] args, int lastIndex) {
        int count = 0;
        try {
            for (int i = lastIndex; i >= 0; --i) {
                Integer.parseInt(args[i]);
                ++count;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return count;
    }
}

