/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.util;

import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Timer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import team.chisel.Chisel;

@ParametersAreNonnullByDefault
public class ClientUtil {
    @Nullable
    private static final Field timerField = ClientUtil.initTimer();

    public static void addHitEffects(World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        if ((state = state.func_185899_b((IBlockAccess)world, pos)).func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            Particle fx;
            int i = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            float f = 0.1f;
            AxisAlignedBB bb = state.func_185900_c((IBlockAccess)world, pos);
            double d0 = (double)i + world.field_73012_v.nextDouble() * (bb.field_72336_d - bb.field_72340_a - (double)(f * 2.0f)) + (double)f + bb.field_72340_a;
            double d1 = (double)j + world.field_73012_v.nextDouble() * (bb.field_72337_e - bb.field_72338_b - (double)(f * 2.0f)) + (double)f + bb.field_72338_b;
            double d2 = (double)k + world.field_73012_v.nextDouble() * (bb.field_72334_f - bb.field_72339_c - (double)(f * 2.0f)) + (double)f + bb.field_72339_c;
            if (side == EnumFacing.DOWN) {
                d1 = (double)j + bb.field_72338_b - (double)f;
            }
            if (side == EnumFacing.UP) {
                d1 = (double)j + bb.field_72337_e + (double)f;
            }
            if (side == EnumFacing.NORTH) {
                d2 = (double)k + bb.field_72339_c - (double)f;
            }
            if (side == EnumFacing.SOUTH) {
                d2 = (double)k + bb.field_72334_f + (double)f;
            }
            if (side == EnumFacing.WEST) {
                d0 = (double)i + bb.field_72340_a - (double)f;
            }
            if (side == EnumFacing.EAST) {
                d0 = (double)i + bb.field_72336_d + (double)f;
            }
            if ((fx = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_149682_b((Block)state.func_177230_c())})) != null) {
                ((ParticleDigging)fx).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f).func_187117_a(Minecraft.func_71410_x().func_175602_ab().func_184389_a(state).func_177554_e());
            }
        }
    }

    public static void addDestroyEffects(World world, BlockPos pos, IBlockState state) {
        state = state.func_185899_b((IBlockAccess)world, pos);
        int i = 4;
        TextureAtlasSprite texture = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state).func_177554_e();
        for (int j = 0; j < i; ++j) {
            for (int k = 0; k < i; ++k) {
                for (int l = 0; l < i; ++l) {
                    double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / (double)i;
                    double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / (double)i;
                    double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / (double)i;
                    Particle fx = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, new int[]{Block.func_149682_b((Block)state.func_177230_c())});
                    if (fx == null) continue;
                    ((ParticleDigging)fx).func_174846_a(pos).func_187117_a(texture);
                }
            }
        }
    }

    @Nullable
    private static Field initTimer() {
        Field f = null;
        try {
            f = ReflectionHelper.findField(Minecraft.class, (String[])new String[]{"field_71428_T", "timer", "Q"});
            f.setAccessible(true);
        }
        catch (Exception e) {
            Chisel.logger.error("Failed to initialize timer reflection.");
            e.printStackTrace();
        }
        return f;
    }

    @Nullable
    public static Timer getTimer() {
        if (timerField == null) {
            return null;
        }
        try {
            return (Timer)timerField.get(Minecraft.func_71410_x());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

