/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.slots;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IMaterials;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.slot.SlotRestrictedInput;
import appeng.items.misc.ItemEncodedPattern;
import appeng.util.Platform;
import co.neeve.nae2.common.interfaces.IContainerPatternMultiTool;
import co.neeve.nae2.common.interfaces.IPatternMultiToolHost;
import co.neeve.nae2.common.slots.IPMTSlot;
import java.util.Arrays;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class SlotPatternMultiTool
extends SlotRestrictedInput
implements IPMTSlot {
    private final IPatternMultiToolHost host;
    private final int groupNum;
    private boolean allowEdit = true;

    public SlotPatternMultiTool(IItemHandler i, IPatternMultiToolHost host, int slotIndex, int x, int y, int grp, InventoryPlayer p) {
        super(host instanceof IContainerPatternMultiTool && (cmp = (IContainerPatternMultiTool)host).isViewingInterface() ? SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN : SlotRestrictedInput.PlacableItemType.PATTERN, i, slotIndex, x, y, p);
        IContainerPatternMultiTool cmp;
        this.host = host;
        this.groupNum = grp;
        this.setReturnAsSingleStack(false);
    }

    private boolean isAllowEdit() {
        return this.allowEdit;
    }

    public void setAllowEdit(boolean allowEdit) {
        this.allowEdit = allowEdit;
    }

    public boolean func_75214_a(ItemStack i) {
        IContainerPatternMultiTool cmp;
        IPatternMultiToolHost iPatternMultiToolHost = this.host;
        if (iPatternMultiToolHost instanceof IContainerPatternMultiTool && (cmp = (IContainerPatternMultiTool)iPatternMultiToolHost).isViewingInterface()) {
            return super.func_75214_a(i);
        }
        if (!this.isSlotEnabled()) {
            return false;
        }
        if (!this.getContainer().isValidForSlot((Slot)this, i)) {
            return false;
        }
        if (i.func_190926_b()) {
            return false;
        }
        if (i.func_77973_b() == Items.field_190931_a) {
            return false;
        }
        if (!this.isAllowEdit()) {
            return false;
        }
        IDefinitions definitions = AEApi.instance().definitions();
        IMaterials materials = definitions.materials();
        if (i.func_77973_b() instanceof ICraftingPatternItem) {
            return true;
        }
        return materials.blankPattern().isSameAs(i);
    }

    public ItemStack getDisplayStack() {
        Item item;
        if (!Platform.isClient()) {
            return super.func_75211_c();
        }
        ItemStack is = super.func_75211_c();
        if (!is.func_190926_b() && (item = is.func_77973_b()) instanceof ICraftingPatternItem) {
            ICraftingPatternItem cpi = (ICraftingPatternItem)item;
            Item item2 = is.func_77973_b();
            if (item2 instanceof ItemEncodedPattern) {
                ItemEncodedPattern iep = (ItemEncodedPattern)item2;
                return iep.getOutput(is);
            }
            ICraftingPatternDetails details = cpi.getPatternForItem(is, null);
            IAEItemStack stack = Arrays.stream(details.getOutputs()).findFirst().orElse(null);
            if (stack != null) {
                return stack.createItemStack();
            }
        }
        return super.func_75211_c();
    }

    public boolean isSlotEnabled() {
        return this.host != null && this.host.isPatternRowEnabled(this.groupNum);
    }

    @Override
    public void setY(int y) {
        this.field_75221_f = y;
    }

    @Override
    public int getInitialY() {
        return this.getY();
    }
}

