/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.registration.definitions;

import appeng.api.AEApi;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartModels;
import appeng.core.features.DamagedItemDefinition;
import appeng.core.features.IStackSrc;
import appeng.core.localization.GuiText;
import appeng.util.Platform;
import co.neeve.nae2.common.features.Features;
import co.neeve.nae2.common.features.IFeature;
import co.neeve.nae2.common.items.NAEBaseItemPart;
import co.neeve.nae2.common.parts.implementations.PartBeamFormer;
import co.neeve.nae2.common.parts.implementations.PartExposer;
import co.neeve.nae2.common.parts.p2p.PartP2PInterface;
import co.neeve.nae2.common.registration.registry.Registry;
import co.neeve.nae2.common.registration.registry.helpers.PartModelsHelper;
import co.neeve.nae2.common.registration.registry.interfaces.Definitions;
import co.neeve.nae2.common.registration.registry.interfaces.IDefinition;
import co.neeve.nae2.common.registration.registry.rendering.ItemPartRendering;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class Parts
implements Definitions<DamagedItemDefinition> {
    private final Object2ObjectOpenHashMap<String, DamagedItemDefinition> byId = new Object2ObjectOpenHashMap();
    private final NAEBaseItemPart itemPart = new NAEBaseItemPart();
    private final DamagedItemDefinition beamFormer;
    private final DamagedItemDefinition p2pTunnelInterface;
    private final DamagedItemDefinition exposer;

    public Parts(Registry registry) {
        registry.item("part", () -> this.itemPart).rendering(new ItemPartRendering(this.itemPart)).build();
        IPartModels partModels = AEApi.instance().registries().partModels();
        for (PartType partType : PartType.values()) {
            partModels.registerModels(partType.getModels());
        }
        this.beamFormer = this.createPart(this.itemPart, PartType.BEAM_FORMER);
        this.p2pTunnelInterface = this.createPart(this.itemPart, PartType.P2P_TUNNEL_INTERFACE);
        this.exposer = this.createPart(this.itemPart, PartType.EXPOSER);
    }

    public static Optional<PartType> getById(int itemDamage) {
        return Optional.ofNullable((PartType)PartType.getCachedValues().getOrDefault((Object)itemDamage, null));
    }

    @NotNull
    private DamagedItemDefinition createPart(NAEBaseItemPart baseItemPart, PartType partType) {
        DamagedItemDefinition def = new DamagedItemDefinition(partType.getId(), (IStackSrc)baseItemPart.createPart(partType));
        this.byId.put((Object)partType.id, (Object)def);
        return def;
    }

    public DamagedItemDefinition getBeamFormer() {
        return this.beamFormer;
    }

    public DamagedItemDefinition p2pTunnelInterface() {
        return this.p2pTunnelInterface;
    }

    public DamagedItemDefinition exposer() {
        return this.exposer;
    }

    @Override
    public Optional<DamagedItemDefinition> getById(String id) {
        return Optional.ofNullable((DamagedItemDefinition)this.byId.getOrDefault((Object)id, null));
    }

    public static enum PartType implements IDefinition
    {
        BEAM_FORMER("beam_former", PartBeamFormer.class, Features.BEAM_FORMERS),
        P2P_TUNNEL_INTERFACE("p2p_tunnel_interface", (Class)PartP2PInterface.class, Features.INTERFACE_P2P, GuiText.Interface){

            @Override
            public String getUnlocalizedName() {
                return "item.appliedenergistics2.multi_part.p2p_tunnel";
            }
        }
        ,
        EXPOSER("exposer", PartExposer.class, (IFeature)Features.EXPOSER){

            @Override
            public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
                lines.add(I18n.func_135052_a((String)"nae2.exposer.tooltip", (Object[])new Object[0]));
            }
        };

        private static Int2ObjectLinkedOpenHashMap<PartType> cachedValues;
        private final String id;
        private final Class<? extends IPart> clazz;
        private final int baseDamage;
        private final boolean enabled;
        private final Set<ResourceLocation> models;
        private Constructor<? extends IPart> constructor;
        private GuiText extraName;
        private List<ModelResourceLocation> itemModels;

        private PartType(String id, Class<? extends IPart> clazz, IFeature features) {
            this.id = id;
            this.clazz = clazz;
            this.baseDamage = this.ordinal();
            this.enabled = features.isEnabled();
            if (this.enabled) {
                if (Platform.isClientInstall()) {
                    this.itemModels = this.createItemModels(id);
                }
                this.models = clazz != null ? new HashSet<ResourceLocation>(PartModelsHelper.createModels(clazz)) : Collections.emptySet();
            } else {
                if (Platform.isClientInstall()) {
                    this.itemModels = Collections.emptyList();
                }
                this.models = Collections.emptySet();
            }
        }

        private PartType(String id, Class<? extends IPart> clazz, Features features, GuiText extraName) {
            this(id, clazz, features);
            this.extraName = extraName;
        }

        public static Int2ObjectLinkedOpenHashMap<PartType> getCachedValues() {
            if (cachedValues == null) {
                cachedValues = new Int2ObjectLinkedOpenHashMap();
                Arrays.stream(PartType.values()).forEach(partType -> cachedValues.put(partType.ordinal(), partType));
            }
            return cachedValues;
        }

        @SideOnly(value=Side.CLIENT)
        private static ModelResourceLocation modelFromBaseName(String baseName) {
            return new ModelResourceLocation(new ResourceLocation("nae2", "part/" + baseName), "inventory");
        }

        @SideOnly(value=Side.CLIENT)
        private List<ModelResourceLocation> createItemModels(String baseName) {
            return ImmutableList.of((Object)PartType.modelFromBaseName(baseName));
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        public int getBaseDamage() {
            return this.baseDamage;
        }

        public Class<? extends IPart> getPart() {
            return this.clazz;
        }

        public String getUnlocalizedName() {
            return "item.nae2.part." + this.name().toLowerCase();
        }

        public GuiText getExtraName() {
            return this.extraName;
        }

        public Constructor<? extends IPart> getConstructor() {
            return this.constructor;
        }

        public void setConstructor(Constructor<? extends IPart> constructor) {
            this.constructor = constructor;
        }

        @SideOnly(value=Side.CLIENT)
        public List<ModelResourceLocation> getItemModels() {
            return this.itemModels;
        }

        public Set<ResourceLocation> getModels() {
            return this.models;
        }

        public String getId() {
            return this.id;
        }

        public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        }
    }
}

