/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.parts.implementations;

import appeng.api.AEApi;
import appeng.api.exceptions.FailedConnectionException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.core.AELog;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.PartModel;
import appeng.util.Platform;
import co.neeve.nae2.client.rendering.helpers.BeamFormerRenderHelper;
import co.neeve.nae2.common.interfaces.IBeamFormer;
import co.neeve.nae2.common.parts.NAEBasePartState;
import co.neeve.nae2.server.IBlockStateListener;
import co.neeve.nae2.server.WorldListener;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Optional.Interface(iface="gregtech.client.utils.IBloomEffect", modid="gregtech")
public class PartBeamFormer
extends NAEBasePartState
implements IBlockStateListener,
IGridTickable,
IBeamFormer {
    public static final ResourceLocation PRISM_LOC = new ResourceLocation("nae2", "part/beam_former_prism");
    private static final ResourceLocation STATUS_OFF_LOC = new ResourceLocation("nae2", "part/beam_former_status_off");
    private static final ResourceLocation STATUS_ON_LOC = new ResourceLocation("nae2", "part/beam_former_status_on");
    private static final ResourceLocation STATUS_BEAMING_LOC = new ResourceLocation("nae2", "part/beam_former_status_beaming");
    private static final ResourceLocation MODEL_BASE_LOC = new ResourceLocation("nae2", "part/beam_former_base");
    public static final PartModel MODEL_BEAMING = new PartModel(new ResourceLocation[]{STATUS_BEAMING_LOC, MODEL_BASE_LOC});
    public static final PartModel MODEL_ON = new PartModel(new ResourceLocation[]{STATUS_ON_LOC, MODEL_BASE_LOC, PRISM_LOC});
    public static final PartModel MODEL_OFF = new PartModel(new ResourceLocation[]{STATUS_OFF_LOC, MODEL_BASE_LOC, PRISM_LOC});
    private int beamLength = 0;
    private PartBeamFormer otherBeamFormer = null;
    private IGridConnection connection = null;
    private Long2ObjectLinkedOpenHashMap<BlockPos> listenerLinkedList = null;
    private boolean hideBeam;
    @SideOnly(value=Side.CLIENT)
    private boolean paired;
    private boolean rendererRegistered;

    public PartBeamFormer(ItemStack is) {
        super(is);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.PREFERRED});
        this.updateEnergyConsumption();
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return ImmutableList.of((Object)MODEL_ON, (Object)MODEL_OFF, (Object)MODEL_BEAMING);
    }

    private static boolean isTranslucent(IBlockState newState) {
        return !newState.func_185904_a().func_76218_k() || newState.func_177230_c().func_149717_k(newState) != 255;
    }

    @Override
    public AEColor getColor() {
        return this.getHost().getColor();
    }

    @Override
    public int getBeamLength() {
        return this.beamLength;
    }

    @Override
    public EnumFacing getDirection() {
        return this.getSide().getFacing();
    }

    @Override
    public World getWorld() {
        return this.getHost().getTile().func_145831_w();
    }

    @Override
    public boolean isValid() {
        TileEntity tile = this.getTile();
        return tile.func_145831_w() == Minecraft.func_71410_x().field_71441_e && !tile.func_145837_r() && this.getHost().getPart(this.getSide()) == this;
    }

    @Override
    public boolean shouldRenderBeam() {
        return !this.hideBeam && this.beamLength != 0 && this.isActive() && this.isPowered();
    }

    @Override
    public BlockPos getPos() {
        return this.getHost().getTile().func_174877_v();
    }

    @NotNull
    public IPartModel getStaticModels() {
        return !this.isActive() || !this.isPowered() ? MODEL_OFF : (this.paired ? MODEL_BEAMING : MODEL_ON);
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(10.0, 10.0, 12.0, 6.0, 6.0, 11.0);
        bch.addBox(10.0, 10.0, 13.0, 6.0, 6.0, 12.0);
        bch.addBox(10.0, 6.0, 14.0, 6.0, 5.0, 13.0);
        bch.addBox(11.0, 9.0, 17.0, 10.0, 7.0, 14.0);
        bch.addBox(9.0, 11.0, 17.0, 7.0, 10.0, 14.0);
        bch.addBox(6.0, 9.0, 17.0, 5.0, 7.0, 14.0);
        bch.addBox(9.0, 6.0, 17.0, 7.0, 5.0, 14.0);
        bch.addBox(10.0, 11.0, 14.0, 6.0, 10.0, 13.0);
        bch.addBox(6.0, 10.0, 14.0, 5.0, 6.0, 13.0);
        bch.addBox(11.0, 9.0, 13.0, 10.0, 7.0, 12.0);
        bch.addBox(6.0, 9.0, 13.0, 5.0, 7.0, 12.0);
        bch.addBox(9.0, 6.0, 13.0, 7.0, 5.0, 12.0);
        bch.addBox(9.0, 11.0, 13.0, 7.0, 10.0, 12.0);
        bch.addBox(11.0, 10.0, 14.0, 10.0, 6.0, 13.0);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 5.0f;
    }

    public void removeFromWorld() {
        this.unregisterListener();
        this.disconnect(null);
        this.getProxy().invalidate();
    }

    public void addToWorld() {
        super.addToWorld();
        try {
            this.getProxy().getTick().alertDevice(this.getGridNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public int getLightLevel() {
        return !this.hideBeam && (Platform.isClient() && this.paired || this.beamLength != 0 || this.otherBeamFormer != null) && this.isActive() && this.isPowered() ? 15 : 0;
    }

    public void setPartHostInfo(AEPartLocation side, IPartHost host, TileEntity tile) {
        super.setPartHostInfo(side, host, tile);
    }

    private void updateEnergyConsumption() {
        this.getProxy().setIdlePowerUsage(Math.pow(Math.max(2.0, (double)this.beamLength), 1.05));
    }

    private void unregisterListener() {
        WorldListener.instance.unregisterBlockStateListener(this);
    }

    private void connect(PartBeamFormer potentialFormer, Iterable<BlockPos> locs) throws FailedConnectionException {
        IGridNode myNode = this.getGridNode();
        potentialFormer.connection = this.connection = AEApi.instance().grid().createGridConnection(myNode, potentialFormer.getGridNode());
        this.otherBeamFormer = potentialFormer;
        potentialFormer.otherBeamFormer = this;
        if (potentialFormer.hideBeam || this.hideBeam) {
            potentialFormer.hideBeam = true;
            this.hideBeam = true;
        }
        this.unregisterListener();
        this.otherBeamFormer.unregisterListener();
        this.listenerLinkedList = new Long2ObjectLinkedOpenHashMap();
        for (BlockPos loc : locs) {
            this.listenerLinkedList.put(loc.func_177986_g(), (Object)loc);
        }
        WorldListener.instance.registerBlockStateListener(this, locs);
        this.beamLength = this.listenerLinkedList.size();
        this.otherBeamFormer.beamLength = 0;
        this.updateEnergyConsumption();
        this.otherBeamFormer.updateEnergyConsumption();
        try {
            this.otherBeamFormer.getProxy().getTick().sleepDevice(this.otherBeamFormer.getGridNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.getHost().markForUpdate();
        this.getHost().markForSave();
        this.otherBeamFormer.getHost().markForUpdate();
        this.otherBeamFormer.getHost().markForSave();
    }

    public boolean disconnect(@Nullable BlockPos breakPos) {
        if (this.connection == null) {
            this.updateEnergyConsumption();
            return false;
        }
        int newBeamA = 0;
        int newBeamB = 0;
        if (breakPos != null) {
            ObjectIterator iterator = this.listenerLinkedList.long2ObjectEntrySet().fastIterator();
            long hash = breakPos.func_177986_g();
            while (iterator.hasNext() && ((Long2ObjectMap.Entry)iterator.next()).getLongKey() != hash) {
                ++newBeamA;
            }
            while (iterator.hasNext()) {
                iterator.next();
                ++newBeamB;
            }
        }
        this.beamLength = newBeamA;
        if (this.connection != null) {
            this.connection.destroy();
            this.connection = null;
        }
        this.updateEnergyConsumption();
        this.getHost().markForUpdate();
        this.getHost().markForSave();
        if (this.otherBeamFormer != null && this.otherBeamFormer.otherBeamFormer == this) {
            this.otherBeamFormer.beamLength = newBeamB;
            this.otherBeamFormer.connection = null;
            this.otherBeamFormer.otherBeamFormer = null;
            this.otherBeamFormer.updateEnergyConsumption();
            this.otherBeamFormer.getHost().markForUpdate();
            this.otherBeamFormer.getHost().markForSave();
            this.otherBeamFormer = null;
        }
        return true;
    }

    @Override
    public void notifyBlockUpdate(World worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        try {
            IPartHost partHost;
            TileEntity te;
            boolean isValid = PartBeamFormer.isTranslucent(newState);
            if (isValid && (te = this.getTile().func_145831_w().func_175625_s(pos)) instanceof IPartHost && ((partHost = (IPartHost)te).getPart(this.getSide()) instanceof PartBeamFormer || partHost.getPart(this.getSide().getOpposite()) instanceof PartBeamFormer)) {
                isValid = false;
            }
            if (this.connection != null && !isValid) {
                this.disconnect(pos);
                this.getProxy().getTick().alertDevice(this.getGridNode());
            } else if (isValid && this.connection == null) {
                this.getProxy().getTick().alertDevice(this.getGridNode());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (hand == EnumHand.MAIN_HAND && Platform.isWrench((EntityPlayer)player, (ItemStack)player.func_184614_ca(), (BlockPos)new BlockPos(pos))) {
            if (Platform.isServer()) {
                this.hideBeam = !this.hideBeam;
                player.func_145747_a((ITextComponent)new TextComponentTranslation(this.hideBeam ? "nae2.part.beam_former.hide" : "nae2.part.beam_former.show", new Object[0]));
                this.getHost().markForUpdate();
                this.getHost().markForSave();
                if (this.otherBeamFormer != null) {
                    this.otherBeamFormer.hideBeam = this.hideBeam;
                    this.otherBeamFormer.getHost().markForUpdate();
                    this.otherBeamFormer.getHost().markForSave();
                }
            }
            player.func_184609_a(hand);
            return !player.field_70170_p.field_72995_K;
        }
        return super.onPartActivate(player, hand, pos);
    }

    @NotNull
    public TickingRequest getTickingRequest(@NotNull IGridNode node) {
        return new TickingRequest(20, 300, false, true);
    }

    @MENetworkEventSubscribe
    public void onPower(MENetworkPowerStatusChange event) throws GridAccessException {
        if (!this.getProxy().isReady()) {
            return;
        }
        this.getProxy().getTick().alertDevice(this.getGridNode());
    }

    @MENetworkEventSubscribe
    public void onUpdate(MENetworkBootingStatusChange event) throws GridAccessException {
        if (!this.getProxy().isReady()) {
            return;
        }
        this.getProxy().getTick().alertDevice(this.getGridNode());
    }

    @NotNull
    public TickRateModulation tickingRequest(@NotNull IGridNode node, int ticksSinceLastCall) {
        if (!this.getProxy().isReady()) {
            return TickRateModulation.SAME;
        }
        boolean isConnectionValid = this.connection != null;
        IGridNode myNode = this.getGridNode();
        if (myNode == null) {
            AELog.error((String)"what the hell, where's my node", (Object[])new Object[0]);
            return TickRateModulation.SLOWER;
        }
        IPartHost host = this.getHost();
        AEPartLocation side = this.getSide();
        BlockPos loc = host.getTile().func_174877_v();
        EnumFacing dir = side.getFacing();
        World world = host.getLocation().getWorld();
        AEPartLocation opposite = side.getOpposite();
        LinkedHashSet<BlockPos> blockSet = new LinkedHashSet<BlockPos>();
        for (int i = 0; i < 32; ++i) {
            IBlockState block;
            TileEntity te = world.func_175625_s(loc = loc.func_177972_a(dir));
            if (te instanceof IPartHost) {
                IPartHost ph = (IPartHost)te;
                IPart part = ph.getPart(opposite);
                if (part instanceof PartBeamFormer) {
                    PartBeamFormer potentialFormer = (PartBeamFormer)part;
                    if (isConnectionValid && potentialFormer == this.otherBeamFormer && this.otherBeamFormer.otherBeamFormer == this) {
                        return TickRateModulation.SLEEP;
                    }
                    boolean disconnected = this.disconnect(loc);
                    if (potentialFormer.getProxy().isReady() && potentialFormer.otherBeamFormer == null) {
                        try {
                            this.connect(potentialFormer, blockSet);
                            return TickRateModulation.SLEEP;
                        }
                        catch (FailedConnectionException | NullPointerException e) {
                            AELog.error((Throwable)e);
                        }
                    }
                    return disconnected ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
                }
                if (ph.getPart(side) instanceof PartBeamFormer) {
                    return this.disconnect(loc) ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
                }
            }
            if (!PartBeamFormer.isTranslucent(block = world.func_180495_p(loc))) {
                return this.disconnect(loc) ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
            }
            blockSet.add(loc);
        }
        return TickRateModulation.SLOWER;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(double x, double y, double z, float partialTicks, int destroyStage) {
        BeamFormerRenderHelper.renderDynamic(this, x, y, z, partialTicks);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requireDynamicRender() {
        if (Platform.isClient() && !this.rendererRegistered) {
            this.rendererRegistered = true;
            BeamFormerRenderHelper.init(this);
        }
        return BeamFormerRenderHelper.shouldRenderDynamic(this);
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        boolean shouldRedraw = super.readFromStream(data);
        this.beamLength = data.readInt();
        boolean wasPaired = this.paired;
        this.paired = data.readBoolean();
        if (this.paired != wasPaired) {
            BlockPos pos = this.getTile().func_174877_v();
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            Minecraft.func_71410_x().field_71438_f.func_147585_a(x, y, z, x, y, z);
        }
        this.hideBeam = data.readBoolean();
        return shouldRedraw;
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeInt(this.beamLength);
        data.writeBoolean(this.otherBeamFormer != null);
        data.writeBoolean(this.hideBeam);
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        NBTTagCompound part = data.func_74775_l("part");
        if (this.beamLength > 0) {
            part.func_74768_a("beamLength", this.beamLength);
        }
        if (this.hideBeam) {
            part.func_74757_a("hideBeam", true);
        }
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        NBTTagCompound part = data.func_74775_l("part");
        NBTBase nBTBase = part.func_74781_a("beamLength");
        if (nBTBase instanceof NBTTagDouble) {
            NBTTagDouble dbl = (NBTTagDouble)nBTBase;
            this.beamLength = (int)dbl.func_150286_g();
        } else {
            this.beamLength = part.func_74762_e("beamLength");
        }
        this.hideBeam = part.func_74767_n("hideBeam");
    }
}

