/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.net.messages;

import appeng.api.AEApi;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerNull;
import appeng.helpers.ItemStackHelper;
import appeng.items.misc.ItemEncodedPattern;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import co.neeve.nae2.common.containers.ContainerPatternMultiTool;
import co.neeve.nae2.common.enums.PatternMultiToolActionTypes;
import co.neeve.nae2.common.enums.PatternMultiToolActions;
import co.neeve.nae2.common.enums.PatternMultiToolTabs;
import co.neeve.nae2.common.interfaces.IContainerPatternMultiTool;
import co.neeve.nae2.common.interfaces.IPatternMultiToolHost;
import co.neeve.nae2.common.net.INAEMessage;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidEncodedPattern;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.IItemHandler;

public class PatternMultiToolPacket
implements INAEMessage {
    private int value;
    private int actionType;

    public PatternMultiToolPacket() {
    }

    public PatternMultiToolPacket(PatternMultiToolActionTypes actionType, int value) {
        this.actionType = actionType.ordinal();
        this.value = value;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.actionType);
        buf.writeInt(this.value);
    }

    public void fromBytes(ByteBuf buf) {
        this.actionType = buf.readInt();
        this.value = buf.readInt();
    }

    public int getValue() {
        return this.value;
    }

    public PatternMultiToolActionTypes getActionType() {
        return PatternMultiToolActionTypes.values()[this.actionType];
    }

    @Override
    public void process(MessageContext ctx) {
        AEBaseContainer bc;
        if (Platform.isClient()) {
            return;
        }
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        Container container = player.field_71070_bA;
        if (container instanceof AEBaseContainer && (bc = (AEBaseContainer)container) instanceof IPatternMultiToolHost) {
            IPatternMultiToolHost container2 = (IPatternMultiToolHost)bc;
            if (this.getActionType() == PatternMultiToolActionTypes.TAB_SWITCH && container2 instanceof ContainerPatternMultiTool) {
                ContainerPatternMultiTool containerPatternMultiTool = (ContainerPatternMultiTool)container2;
                containerPatternMultiTool.switchTab(PatternMultiToolTabs.values()[this.getValue()]);
            } else if (this.getActionType() == PatternMultiToolActionTypes.BUTTON_PRESS) {
                AppEngInternalInventory inv = (AppEngInternalInventory)container2.getPatternInventory();
                if (inv == null) {
                    return;
                }
                PatternMultiToolActions value = PatternMultiToolActions.values()[this.getValue()];
                if (value == PatternMultiToolActions.INV_SWITCH && container2 instanceof IContainerPatternMultiTool) {
                    IContainerPatternMultiTool cmp = (IContainerPatternMultiTool)container2;
                    cmp.toggleInventory();
                    bc.func_75142_b();
                    return;
                }
                if (value == PatternMultiToolActions.REPLACE && container2 instanceof IContainerPatternMultiTool) {
                    IContainerPatternMultiTool cmp = (IContainerPatternMultiTool)container2;
                    this.searchAndReplace(cmp, player);
                    bc.func_75142_b();
                    return;
                }
                for (ItemStack is : inv) {
                    if (!(is.func_77973_b() instanceof ItemEncodedPattern)) continue;
                    try {
                        this.handleButtonPress(is, bc, value);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                }
                bc.func_75142_b();
            }
        }
    }

    private void handleButtonPress(ItemStack is, AEBaseContainer container, PatternMultiToolActions buttonId) {
        switch (buttonId) {
            case MUL2: {
                this.updatePatternCount(is, 2, Operation.MULTIPLY);
                break;
            }
            case MUL3: {
                this.updatePatternCount(is, 3, Operation.MULTIPLY);
                break;
            }
            case ADD: {
                this.updatePatternCount(is, 1, Operation.ADD);
                break;
            }
            case DIV2: {
                this.updatePatternCount(is, 2, Operation.DIVIDE);
                break;
            }
            case DIV3: {
                this.updatePatternCount(is, 3, Operation.DIVIDE);
                break;
            }
            case SUB: {
                this.updatePatternCount(is, 1, Operation.SUBTRACT);
                break;
            }
            case CLEAR: {
                this.emptyPattern(is, container);
            }
        }
    }

    private void emptyPattern(ItemStack is, AEBaseContainer container) {
        ItemStack newStack = AEApi.instance().definitions().materials().blankPattern().maybeStack(is.func_190916_E()).orElse(ItemStack.field_190927_a);
        container.func_75141_a(container.func_75138_a().indexOf((Object)is), newStack);
    }

    private boolean canDivideTagList(NBTTagList tagList, int factor, String countTag) {
        for (NBTBase tag : tagList) {
            NBTTagCompound ntc = (NBTTagCompound)tag;
            if (ntc.func_74762_e(countTag) % factor == 0) continue;
            return true;
        }
        return false;
    }

    private void searchAndReplace(IContainerPatternMultiTool host, EntityPlayerMP player) {
        IItemHandler srInv = host.getSearchReplaceInventory();
        IItemHandler inv = host.getPatternInventory();
        if (srInv == null || inv == null) {
            return;
        }
        ItemStack itemA = srInv.getStackInSlot(0);
        ItemStack itemB = srInv.getStackInSlot(1);
        if (itemA.func_190926_b() || itemB.func_190926_b()) {
            return;
        }
        NBTTagCompound itemBData = ItemStackHelper.stackToNBT((ItemStack)itemB);
        InventoryCrafting crafting = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
        for (int i = 0; i < inv.getSlots(); ++i) {
            NBTTagList[] lists;
            NBTTagCompound nbt;
            ItemStack is = inv.getStackInSlot(i);
            if (!(is.func_77973_b() instanceof ItemEncodedPattern) || (nbt = is.func_77978_p()) == null) continue;
            boolean ae2fc = Platform.isModLoaded((String)"ae2fc") && is.func_77973_b() instanceof ItemFluidEncodedPattern;
            String countTag = ae2fc ? "Cnt" : "Count";
            NBTTagList tagIn = (NBTTagList)nbt.func_74781_a("in").func_74737_b();
            NBTTagList tagOut = (NBTTagList)nbt.func_74781_a("out").func_74737_b();
            FluidStack fluidStackIn = FluidUtil.getFluidContained((ItemStack)itemA);
            FluidStack fluidStackOut = FluidUtil.getFluidContained((ItemStack)itemB);
            boolean fluidReplacement = ae2fc && fluidStackIn != null && fluidStackOut != null;
            for (NBTTagList list : lists = new NBTTagList[]{tagIn, tagOut}) {
                int idx = 0;
                for (NBTBase tag : list.func_74737_b()) {
                    FluidStack fluidStack;
                    NBTTagCompound compound = (NBTTagCompound)tag;
                    ItemStack stack = ItemStackHelper.stackFromNBT((NBTTagCompound)compound);
                    if (itemA.func_77969_a(stack)) {
                        NBTBase count = compound.func_74781_a(countTag).func_74737_b();
                        NBTTagCompound data = itemBData.func_74737_b();
                        data.func_74782_a(countTag, count);
                        list.func_150304_a(idx, (NBTBase)data);
                    } else if (fluidReplacement && stack.func_77973_b() instanceof ItemFluidDrop && fluidStackIn.isFluidEqual(fluidStack = ItemFluidDrop.getFluidStack((ItemStack)stack))) {
                        NBTTagCompound ifdCompound;
                        ItemStack ifd = ItemFluidDrop.newStack((FluidStack)fluidStackOut);
                        if (ifd == null || (ifdCompound = ifd.func_77978_p()) == null) continue;
                        NBTTagCompound data = compound.func_74737_b();
                        data.func_74782_a("tag", (NBTBase)ifdCompound);
                        list.func_150304_a(idx, (NBTBase)data);
                    }
                    ++idx;
                }
            }
            if (nbt.func_74767_n("crafting")) {
                try {
                    if (tagIn.func_74745_c() != 9) continue;
                    World w = player.field_70170_p;
                    crafting.func_174888_l();
                    for (int j = 0; j < tagIn.func_74745_c(); ++j) {
                        ItemStack is1 = ItemStackHelper.stackFromNBT((NBTTagCompound)((NBTTagCompound)tagIn.func_179238_g(j)));
                        crafting.func_70299_a(j, is1);
                    }
                    if (null == CraftingManager.func_192413_b((InventoryCrafting)crafting, (World)w)) {
                    }
                }
                catch (Exception e) {}
                continue;
            }
            nbt.func_74782_a("in", (NBTBase)tagIn);
            nbt.func_74782_a("out", (NBTBase)tagOut);
            if (!ae2fc) continue;
            nbt.func_74782_a("Inputs", (NBTBase)tagIn);
            nbt.func_74782_a("Outputs", (NBTBase)tagOut);
        }
    }

    private void updatePatternCount(ItemStack is, int factor, Operation operation) {
        String countTag;
        boolean ae2fc = Platform.isModLoaded((String)"ae2fc") && is.func_77973_b() instanceof ItemFluidEncodedPattern;
        NBTTagCompound nbt = is.func_77978_p();
        if (nbt == null) {
            return;
        }
        NBTTagList tagIn = (NBTTagList)nbt.func_74781_a("in");
        NBTTagList tagOut = (NBTTagList)nbt.func_74781_a("out");
        String string = countTag = ae2fc ? "Cnt" : "Count";
        if (operation == Operation.DIVIDE && (this.canDivideTagList(tagIn, factor, countTag) || this.canDivideTagList(tagOut, factor, countTag))) {
            return;
        }
        ArrayList<Object> toModify = new ArrayList<Object>(4);
        if (ae2fc) {
            NBTTagList ae2fcTagIn = (NBTTagList)nbt.func_74781_a("Inputs");
            NBTTagList nBTTagList = (NBTTagList)nbt.func_74781_a("Outputs");
            if (operation == Operation.DIVIDE && (this.canDivideTagList(ae2fcTagIn, factor, countTag) || this.canDivideTagList(nBTTagList, factor, countTag))) {
                return;
            }
            toModify.add(ae2fcTagIn);
            toModify.add(nBTTagList);
        }
        toModify.add(tagIn);
        toModify.add(tagOut);
        for (NBTTagList nBTTagList : toModify) {
            this.modifyTagList(nBTTagList, factor, operation, countTag);
        }
        NBTTagCompound newNbt = is.func_77978_p();
        newNbt.func_74774_a("crafting", (byte)0);
        newNbt.func_74774_a("substitute", (byte)0);
    }

    private void modifyTagList(NBTTagList tagList, int factor, Operation operation, String countTag) {
        for (NBTBase tag : tagList) {
            NBTTagCompound ntc = (NBTTagCompound)tag;
            int count = ntc.func_74762_e(countTag);
            if (count == 0) continue;
            switch (operation) {
                case ADD: {
                    if (count >= Integer.MAX_VALUE) break;
                    ntc.func_74768_a(countTag, count + factor);
                    break;
                }
                case SUBTRACT: {
                    if (count <= 1) break;
                    ntc.func_74768_a(countTag, count - factor);
                    break;
                }
                case MULTIPLY: {
                    if (count <= 0 || count > Integer.MAX_VALUE / factor) break;
                    ntc.func_74768_a(countTag, count * factor);
                    break;
                }
                case DIVIDE: {
                    if (count < factor) break;
                    ntc.func_74768_a(countTag, Math.max(1, count / factor));
                }
            }
            if (count > 64) {
                ntc.func_74768_a("stackSize", ntc.func_74762_e(countTag));
                continue;
            }
            ntc.func_82580_o("stackSize");
        }
    }

    public static enum Operation {
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE;

    }
}

