/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.items.patternmultitool;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AEPartLocation;
import appeng.core.AppEng;
import appeng.helpers.IInterfaceHost;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import baubles.api.BaubleType;
import baubles.api.IBauble;
import co.neeve.nae2.NAE2;
import co.neeve.nae2.common.interfaces.INAEGuiItem;
import co.neeve.nae2.common.items.patternmultitool.ObjPatternMultiTool;
import co.neeve.nae2.common.sync.GuiBridge;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class ToolPatternMultiTool
extends AEBaseItem
implements INAEGuiItem<ObjPatternMultiTool>,
IBauble {
    public ToolPatternMultiTool() {
        this.func_77625_d(1);
    }

    public static ObjPatternMultiTool getGuiObject(ItemStack patternMultiTool) {
        return ((ToolPatternMultiTool)patternMultiTool.func_77973_b()).getGuiObject(patternMultiTool, null);
    }

    @Nullable
    public static IInterfaceHost tryGetInterfacePart(TileEntity te, EnumFacing facing) {
        IPartHost ph;
        IPart part;
        if (te instanceof IInterfaceHost) {
            IInterfaceHost ifh = (IInterfaceHost)te;
            return ifh;
        }
        if (te instanceof IPartHost && (part = (ph = (IPartHost)te).getPart(facing)) instanceof IInterfaceHost) {
            IInterfaceHost ifaceHost = (IInterfaceHost)part;
            return ifaceHost;
        }
        return null;
    }

    @Nullable
    public static InterfacePartResult tryGetInterfacePart(TileEntity te, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (te instanceof IPartHost) {
            RayTraceResult mop = new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos);
            SelectedPart selectedPart = ((IPartHost)te).selectPart(mop.field_72307_f);
            IPart iPart = selectedPart.part;
            if (iPart instanceof IInterfaceHost) {
                IInterfaceHost interfaceHost = (IInterfaceHost)iPart;
                return new InterfacePartResult(interfaceHost, selectedPart.side);
            }
        }
        return null;
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World w, @NotNull EntityPlayer p, @NotNull EnumHand hand) {
        RayTraceResult mop;
        if (Platform.isServer() && ((mop = AppEng.proxy.getRTR()) == null || mop.field_72313_a == RayTraceResult.Type.MISS)) {
            NAE2.gui().openGUI(p, null, AEPartLocation.INTERNAL, GuiBridge.PATTERN_MULTI_TOOL);
            p.func_184609_a(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)p.func_184586_b(hand));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)p.func_184586_b(hand));
    }

    @NotNull
    public EnumActionResult onItemUseFirst(EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumFacing side, float hitX, float hitY, float hitZ, @NotNull EnumHand hand) {
        if (player.func_70093_af() || !Platform.isServer()) {
            return EnumActionResult.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            NAE2.gui().openGUI(player, null, AEPartLocation.INTERNAL, GuiBridge.PATTERN_MULTI_TOOL);
            return EnumActionResult.SUCCESS;
        }
        if (te instanceof IInterfaceHost) {
            NAE2.gui().openGUI(player, te, AEPartLocation.INTERNAL, GuiBridge.PATTERN_MULTI_TOOL);
            return EnumActionResult.SUCCESS;
        }
        InterfacePartResult partResult = ToolPatternMultiTool.tryGetInterfacePart(te, pos, side, hitX, hitY, hitZ);
        if (partResult != null) {
            NAE2.gui().openGUI(player, te, partResult.side, GuiBridge.PATTERN_MULTI_TOOL);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public ObjPatternMultiTool getGuiObject(ItemStack is, World w, BlockPos bp, AEPartLocation side) {
        IInterfaceHost interfaceHost = null;
        TileEntity te = w.func_175625_s(bp);
        if (te instanceof IInterfaceHost) {
            IInterfaceHost ih;
            interfaceHost = ih = (IInterfaceHost)te;
        } else {
            IInterfaceHost result = ToolPatternMultiTool.tryGetInterfacePart(te, side.getFacing());
            if (result != null) {
                interfaceHost = result;
            }
        }
        if (interfaceHost != null) {
            ObjPatternMultiTool obj = new ObjPatternMultiTool(is);
            obj.setInterface(interfaceHost);
            return obj;
        }
        return (ObjPatternMultiTool)INAEGuiItem.super.getGuiObject(is, w, bp, side);
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.TRINKET;
    }

    @Override
    public ObjPatternMultiTool getGuiObject(ItemStack is, World w) {
        return new ObjPatternMultiTool(is);
    }

    private static final class InterfacePartResult {
        private final IInterfaceHost part;
        private final AEPartLocation side;

        private InterfacePartResult(IInterfaceHost part, AEPartLocation side) {
            this.part = part;
            this.side = side;
        }

        public String toString() {
            return "InterfacePartResult[" + "part=" + this.part + "," + "side=" + this.side + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.part != null ? this.part.hashCode() : 0);
            result = 31 * result + (this.side != null ? this.side.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((InterfacePartResult)arg0).part, this.part)) {
                return false;
            }
            return Objects.equals(((InterfacePartResult)arg0).side, this.side);
            {
            }
        }

        public IInterfaceHost part() {
            return this.part;
        }

        public AEPartLocation side() {
            return this.side;
        }
    }
}

