/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.items;

import appeng.api.implementations.items.IItemGroup;
import appeng.api.implementations.tiles.ISegmentedInventory;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.core.features.IStackSrc;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import appeng.util.inv.AdaptorItemHandler;
import co.neeve.nae2.NAE2;
import co.neeve.nae2.common.interfaces.INAEUpgradeHost;
import co.neeve.nae2.common.interfaces.INAEUpgradeModule;
import co.neeve.nae2.common.registration.definitions.Upgrades;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NAEBaseItemUpgrade
extends AEBaseItem
implements INAEUpgradeModule {
    public static NAEBaseItemUpgrade instance;
    private final Int2ObjectOpenHashMap<Upgrades.UpgradeType> dmgToUpgrade = new Int2ObjectOpenHashMap();

    public NAEBaseItemUpgrade() {
        this.func_77627_a(true);
        instance = this;
    }

    @NotNull
    public String func_77667_c(ItemStack itemStack) {
        Optional<Upgrades.UpgradeType> upgrade = NAE2.definitions().upgrades().getById(itemStack.func_77952_i());
        if (upgrade.isPresent()) {
            return upgrade.get().getTranslationKey();
        }
        return "item.nae2.invalid";
    }

    protected void getCheckedSubItems(CreativeTabs creativeTab, NonNullList<ItemStack> itemStacks) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (Upgrades.UpgradeType upgrade : Upgrades.UpgradeType.getCachedValues().values()) {
            if (!upgrade.isRegistered()) continue;
            itemStacks.add((Object)new ItemStack((Item)this, 1, upgrade.ordinal()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        Upgrades.UpgradeType u = this.getType(stack);
        if (u != null) {
            ArrayList<String> textList = new ArrayList<String>();
            u.addCheckedInformation(stack, world, lines, advancedTooltips);
            if (!lines.isEmpty()) {
                lines.add("");
            }
            for (Map.Entry<ItemStack, Integer> j : u.getSupported().entrySet()) {
                IItemGroup ig;
                String str;
                String name = null;
                int limit = j.getValue();
                Item item = j.getKey().func_77973_b();
                if (item instanceof IItemGroup && (str = (ig = (IItemGroup)item).getUnlocalizedGroupName(u.getSupported().keySet(), j.getKey())) != null) {
                    name = Platform.gui_localize((String)str) + (limit > 1 ? " (" + limit + ')' : "");
                }
                if (name == null) {
                    name = j.getKey().func_82833_r() + (limit > 1 ? " (" + limit + ')' : "");
                }
                if (textList.contains(name)) continue;
                textList.add(name);
            }
            lines.addAll(textList);
        }
    }

    @Override
    @Nullable
    public Upgrades.UpgradeType getType(ItemStack stack) {
        return NAE2.definitions().upgrades().getById(stack.func_77952_i()).orElse(null);
    }

    @NotNull
    public EnumActionResult onItemUseFirst(EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull EnumFacing side, float hitX, float hitY, float hitZ, @NotNull EnumHand hand) {
        if (player.func_70093_af()) {
            INAEUpgradeModule um;
            Upgrades.UpgradeType u;
            Item item;
            TileEntity te = world.func_175625_s(pos);
            IItemHandler upgrades = null;
            if (te instanceof IPartHost) {
                SelectedPart sp = ((IPartHost)te).selectPart(new Vec3d((double)hitX, (double)hitY, (double)hitZ));
                if (sp.part instanceof INAEUpgradeHost) {
                    upgrades = ((ISegmentedInventory)sp.part).getInventoryByName("upgrades");
                }
            } else if (te instanceof INAEUpgradeHost) {
                upgrades = ((ISegmentedInventory)te).getInventoryByName("upgrades");
            }
            if (upgrades != null && !player.func_184586_b(hand).func_190926_b() && (item = player.func_184586_b(hand).func_77973_b()) instanceof INAEUpgradeModule && (u = (um = (INAEUpgradeModule)item).getType(player.func_184586_b(hand))) != null) {
                if (player.field_70170_p.field_72995_K) {
                    return EnumActionResult.PASS;
                }
                AdaptorItemHandler ad = new AdaptorItemHandler(upgrades);
                player.func_184611_a(hand, ad.addItems(player.func_184586_b(hand)));
                return EnumActionResult.SUCCESS;
            }
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public IStackSrc createUpgrade(Upgrades.UpgradeType upgradeType) {
        Preconditions.checkState((!upgradeType.isRegistered() ? 1 : 0) != 0, (Object)"Cannot create the same material twice.");
        boolean enabled = upgradeType.isEnabled();
        upgradeType.setStackSrc(new Upgrades.UpgradeStackSrc(upgradeType, enabled));
        if (enabled) {
            upgradeType.setItemInstance((Item)this);
            upgradeType.markReady();
            int newUpgradeNum = upgradeType.getDamageValue();
            if (this.dmgToUpgrade.get(newUpgradeNum) == null) {
                this.dmgToUpgrade.put(newUpgradeNum, (Object)upgradeType);
            } else {
                throw new IllegalStateException("Meta Overlap detected.");
            }
        }
        return upgradeType.getStackSrc();
    }
}

