/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.integration.jei;

import appeng.api.definitions.IItemDefinition;
import appeng.api.implementations.items.IStorageCell;
import co.neeve.nae2.common.features.subfeatures.JEIFeatures;
import co.neeve.nae2.common.integration.jei.JEICellCategory;
import co.neeve.nae2.common.integration.jei.SingleStackRecipe;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@JEIPlugin
public class NAEJEIPlugin
implements IModPlugin,
IRecipeRegistryPlugin {
    private static final Object2ObjectOpenHashMap<IItemDefinition, String[]> ingredientDescriptions = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<IItemDefinition, String[]> ingredientCatalysts = new Object2ObjectOpenHashMap();
    private static final ObjectOpenHashSet<IItemDefinition> ingredientBlacklist = new ObjectOpenHashSet();

    public static void registerDescription(IItemDefinition ingredient, String ... descriptions) {
        ingredientDescriptions.put((Object)ingredient, (Object)descriptions);
    }

    public static void registerCatalyst(IItemDefinition ingredient, String ... descriptions) {
        ingredientCatalysts.put((Object)ingredient, (Object)descriptions);
    }

    public static void registerBlacklist(IItemDefinition ingredient) {
        ingredientBlacklist.add((Object)ingredient);
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registry) {
        super.registerCategories(registry);
        if (JEIFeatures.CELL_VIEW.isEnabled()) {
            IJeiHelpers jeiHelpers = registry.getJeiHelpers();
            registry.addRecipeCategories(new IRecipeCategory[]{new JEICellCategory(jeiHelpers)});
        }
    }

    @NotNull
    public <V> List<String> getRecipeCategoryUids(@NotNull IFocus<V> focus) {
        ItemStack focusStack;
        Object object;
        if (JEIFeatures.CELL_VIEW.isEnabled() && (object = focus.getValue()) instanceof ItemStack && (focusStack = (ItemStack)object).func_77973_b() instanceof IStorageCell) {
            return Collections.singletonList("nae2:cell_view");
        }
        return Collections.emptyList();
    }

    @NotNull
    public <T extends IRecipeWrapper, V> List<T> getRecipeWrappers(@NotNull IRecipeCategory<T> recipeCategory, @NotNull IFocus<V> focus) {
        ItemStack is;
        Object object;
        if (JEIFeatures.CELL_VIEW.isEnabled() && recipeCategory instanceof JEICellCategory && (object = focus.getValue()) instanceof ItemStack && (is = (ItemStack)object).func_77973_b() instanceof IStorageCell) {
            return Collections.singletonList(new SingleStackRecipe(is));
        }
        return Collections.emptyList();
    }

    @NotNull
    public <T extends IRecipeWrapper> List<T> getRecipeWrappers(@NotNull IRecipeCategory<T> recipeCategory) {
        if (JEIFeatures.CELL_VIEW.isEnabled() && recipeCategory instanceof JEICellCategory) {
            return Collections.singletonList(new SingleStackRecipe(ItemStack.field_190927_a));
        }
        return Collections.emptyList();
    }

    public void register(@NotNull IModRegistry registry) {
        super.register(registry);
        if (JEIFeatures.CELL_VIEW.isEnabled()) {
            registry.addRecipeRegistryPlugin((IRecipeRegistryPlugin)this);
        }
        for (Object2ObjectMap.Entry descEntry : ingredientDescriptions.object2ObjectEntrySet()) {
            ((IItemDefinition)descEntry.getKey()).maybeStack(1).ifPresent(itemStack -> registry.addIngredientInfo(itemStack, VanillaTypes.ITEM, (String[])Arrays.stream((String[])descEntry.getValue()).map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0])).toArray(String[]::new)));
        }
        for (Object2ObjectMap.Entry catalystEntry : ingredientCatalysts.object2ObjectEntrySet()) {
            ((IItemDefinition)catalystEntry.getKey()).maybeStack(1).ifPresent(itemStack -> registry.addRecipeCatalyst(itemStack, (String[])Arrays.stream((String[])catalystEntry.getValue()).map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0])).toArray(String[]::new)));
        }
        IIngredientBlacklist blacklist = registry.getJeiHelpers().getIngredientBlacklist();
        for (IItemDefinition blacklistEntry : ingredientBlacklist) {
            blacklistEntry.maybeStack(1).ifPresent(arg_0 -> ((IIngredientBlacklist)blacklist).addIngredientToBlacklist(arg_0));
        }
    }
}

