/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.helpers.exposer;

import appeng.api.AEApi;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.fluids.util.AEFluidStack;
import co.neeve.nae2.common.helpers.exposer.AEStackExposerHandler;
import co.neeve.nae2.common.interfaces.IExposerHost;
import java.util.Optional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.jetbrains.annotations.Nullable;

public class FluidExposerHandler
extends AEStackExposerHandler<IAEFluidStack>
implements IFluidHandler {
    private static final IFluidTankProperties[] EMPTY = new IFluidTankProperties[0];
    private IFluidTankProperties[] cachedProperties;

    public FluidExposerHandler(IExposerHost host) {
        super(host);
    }

    public IFluidTankProperties[] getTankProperties() {
        this.updateMonitor();
        return this.cachedProperties != null ? this.cachedProperties : EMPTY;
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        IAEFluidStack pulled;
        AEFluidStack aefs;
        IAEFluidStack stack;
        this.updateMonitor();
        IItemList storage = this.getStorageList();
        if (storage != null && (stack = (IAEFluidStack)storage.findPrecise((IAEStack)(aefs = AEFluidStack.fromFluidStack((FluidStack)resource)))) != null && (pulled = (IAEFluidStack)this.pullStack(aefs, !doDrain)) != null) {
            return pulled.getFluidStack();
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        Optional stack;
        IAEFluidStack pulled;
        this.updateMonitor();
        if (!this.cache.isEmpty() && (pulled = this.pullStack((IAEFluidStack)((IAEFluidStack)(stack = this.cache.stream().findFirst()).get()).copy().setStackSize((long)maxDrain), !doDrain)) != null) {
            return pulled.getFluidStack();
        }
        return null;
    }

    @Override
    protected IStorageChannel<IAEFluidStack> getStorageChannel() {
        return AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class);
    }

    @Override
    protected void refreshCache() {
        super.refreshCache();
        this.rebuildProperties();
    }

    private void rebuildProperties() {
        if (this.cache.isEmpty()) {
            this.cachedProperties = null;
        } else {
            this.cachedProperties = new IFluidTankProperties[this.cache.size()];
            int i = 0;
            for (IAEFluidStack cachedFluid : this.cache) {
                this.cachedProperties[i++] = new FluidTankProperties(cachedFluid.getFluidStack(), (int)cachedFluid.getStackSize(), false, true);
            }
        }
    }

    @Override
    public void postChange(IBaseMonitor<IAEFluidStack> iBaseMonitor, Iterable<IAEFluidStack> iterable, IActionSource iActionSource) {
        super.postChange(iBaseMonitor, iterable, iActionSource);
        this.rebuildProperties();
    }
}

