/*
 * Decompiled with CFR 0.152.
 */
package co.neeve.nae2.common.api;

import appeng.api.storage.data.IAEStack;
import co.neeve.nae2.NAE2;
import co.neeve.nae2.common.interfaces.IExposerHandler;
import co.neeve.nae2.common.interfaces.IExposerHost;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExposerAPI {
    private final DataHolder dataHolder = new DataHolder();

    @SideOnly(value=Side.CLIENT)
    public void addTooltipInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        lines.add(I18n.func_135052_a((String)"nae2.exposer.tooltip", (Object[])new Object[0]));
        Object2ObjectMap registered = this.getRegisteredHandlers();
        if (registered.isEmpty()) {
            lines.add("");
            lines.add(I18n.func_135052_a((String)"nae2.exposer.noneregistered", (Object[])new Object[0]));
        } else {
            lines.add("");
            lines.add(I18n.func_135052_a((String)"nae2.exposer.registered", (Object[])new Object[0]));
            for (Object2ObjectMap.Entry handler : registered.object2ObjectEntrySet()) {
                String name = ((Capability)handler.getKey()).getName();
                if (name.contains(".")) {
                    name = name.substring(name.lastIndexOf(46) + 1);
                }
                lines.add(" - \u00a76" + name + "\u00a7r (" + ((HandlerInfo)handler.getValue()).getMod().getAnnotation(Mod.class).name() + ")");
            }
        }
    }

    public <T extends IAEStack<T>> IExposerHandler<T> createHandler(IExposerHost host, Capability<?> capability) {
        HandlerInfo<T> info = this.getHandlerInfo(capability);
        if (info == null) {
            return null;
        }
        try {
            IExposerHandler<T> result = info.getHandlerClass().getConstructor(IExposerHost.class).newInstance(host);
            NAE2.logger().debug("Created exposer handler for capability {} at {}: {}", capability, (Object)host.getProxy().getLocation(), result);
            return result;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends IAEStack<T>> void registerHandler(Class<?> mod, Capability<?> capability, Class<? extends IExposerHandler<T>> exposerClass) {
        HandlerInfo handlerInfo = new HandlerInfo(exposerClass, mod);
        this.dataHolder.registeredHandlers.put(capability, handlerInfo);
    }

    public <T extends IAEStack<T>, U extends Capability<?>> Object2ObjectMap<U, HandlerInfo<T>> getRegisteredHandlers() {
        return this.dataHolder.immutableWrapper;
    }

    public boolean isCapabilityRegistered(Capability<?> capability) {
        return this.dataHolder.registeredHandlers.containsKey(capability);
    }

    @Nullable
    public <T extends IAEStack<T>, U extends Capability<?>> HandlerInfo<T> getHandlerInfo(U capability) {
        return (HandlerInfo)this.dataHolder.registeredHandlers.getOrDefault(capability, null);
    }

    private static class DataHolder<T extends IAEStack<T>, U extends Capability<?>> {
        private final Object2ObjectMap<U, HandlerInfo<T>> registeredHandlers = new Object2ObjectOpenHashMap();
        private final Object2ObjectMap<U, HandlerInfo<T>> immutableWrapper = Object2ObjectMaps.unmodifiable(this.registeredHandlers);

        private DataHolder() {
        }
    }

    public static final class HandlerInfo<T extends IAEStack<T>> {
        private final Class<? extends IExposerHandler<T>> handlerClass;
        private final Class<?> mod;

        private HandlerInfo(@NotNull Class<? extends IExposerHandler<T>> handlerClass, @NotNull Class<?> mod) {
            if (!mod.isAnnotationPresent(Mod.class)) {
                throw new IllegalArgumentException("Mod class must be annotated with @Mod");
            }
            this.handlerClass = handlerClass;
            this.mod = mod;
        }

        public Class<? extends IExposerHandler<T>> getHandlerClass() {
            return this.handlerClass;
        }

        public Class<?> getMod() {
            return this.mod;
        }
    }
}

