/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal;

import codechicken.lib.CodeChickenLib;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="codechickenlib")
public class CCLLog {
    public static Logger logger = LogManager.getLogger((String)"CodeChickenLib");
    private static final Set<String> stackTraces = new HashSet<String>();
    private static final Set<String> tickMessages = new HashSet<String>();

    public static void log(Level logLevel, Object object) {
        logger.log(logLevel, String.valueOf(object));
    }

    public static void log(Level logLevel, String format, Object ... objects) {
        logger.log(logLevel, String.format(format, objects));
    }

    public static void log(Level logLevel, Throwable throwable, Object object) {
        logger.log(logLevel, String.valueOf(object), throwable);
    }

    public static void log(Level logLevel, Throwable throwable, String format, Object ... objects) {
        logger.log(logLevel, String.format(format, objects), throwable);
    }

    public static void big(Level level, String format, Object ... data) {
        CCLLog.big(level, 8, format, data);
    }

    public static void big(Level level, int lines, String format, Object ... data) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        CCLLog.log(level, "****************************************");
        CCLLog.log(level, "* " + format, data);
        for (int i = 2; i < lines && i < trace.length; ++i) {
            CCLLog.log(level, "*  at %s%s", trace[i].toString(), i == lines - 1 ? "..." : "");
        }
        CCLLog.log(level, "****************************************");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void errorOnce(Throwable t, String identifier, String format, Object ... data) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        String stackTrace = identifier + sw.toString();
        Set<String> set = stackTraces;
        synchronized (set) {
            if (!stackTraces.contains(stackTrace)) {
                CCLLog.log(Level.ERROR, t, format, data);
                stackTraces.add(stackTrace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void logOncePerTick(Level level, String format, Object ... data) {
        String l = String.format(format, data);
        Set<String> set = tickMessages;
        synchronized (set) {
            if (!tickMessages.contains(level + l)) {
                CCLLog.log(level, l);
                tickMessages.add(level + l);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTickEnd(TickEvent.ClientTickEvent event) {
        CCLLog.onTickEnd((TickEvent)event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTickEnd(TickEvent.ServerTickEvent event) {
        CCLLog.onTickEnd((TickEvent)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onTickEnd(TickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (CodeChickenLib.proxy.isClient()) {
                if (event.type == TickEvent.Type.CLIENT) {
                    Set<String> set = tickMessages;
                    synchronized (set) {
                        tickMessages.clear();
                    }
                }
            } else if (event.type == TickEvent.Type.SERVER) {
                Set<String> set = tickMessages;
                synchronized (set) {
                    tickMessages.clear();
                }
            }
        }
    }
}

