/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.place;

import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.LittleTilesConfig;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.config.LittleBuildingConfig;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxReturnedVolume;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.parent.ParentTileList;
import com.creativemd.littletiles.common.tile.parent.StructureTileList;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreviewsStructureHolder;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.IGridBased;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredient;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.creativemd.littletiles.common.util.place.PlacementPreview;
import com.creativemd.littletiles.common.util.place.PlacementResult;
import com.creativemd.littletiles.common.world.LittleNeighborUpdateCollector;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.mutable.MutableInt;

public class Placement {
    public final EntityPlayer player;
    public final World world;
    public final PlacementMode mode;
    public final BlockPos pos;
    public final EnumFacing facing;
    public final LittlePreviews previews;
    public final LinkedHashMap<BlockPos, PlacementBlock> blocks = new LinkedHashMap();
    public final PlacementStructurePreview origin;
    public final List<PlacementStructurePreview> structures = new ArrayList<PlacementStructurePreview>();
    public final BitSet availableIds = new BitSet();
    public final LittleIngredients removedIngredients;
    public final LittleAbsolutePreviews removedTiles;
    public final LittleAbsolutePreviews unplaceableTiles;
    public final List<SoundType> soundsToBePlayed = new ArrayList<SoundType>();
    protected MutableInt affectedBlocks = new MutableInt();
    protected ItemStack stack;
    protected boolean ignoreWorldBoundaries = true;
    protected BiPredicate<IParentTileList, LittleTile> predicate;
    protected boolean playSounds = true;
    protected boolean notifyAfterPlace = true;

    public Placement(EntityPlayer player, PlacementPreview preview) {
        this.player = player;
        this.world = preview.world;
        this.mode = preview.mode;
        this.pos = preview.pos;
        this.facing = preview.facing;
        this.previews = preview.previews;
        this.origin = this.createStructureTree(null, preview.previews);
        this.removedIngredients = new LittleIngredients();
        this.removedTiles = new LittleAbsolutePreviews(this.pos, LittleGridContext.getMin());
        this.unplaceableTiles = new LittleAbsolutePreviews(this.pos, LittleGridContext.getMin());
        this.createPreviews(this.origin, preview.inBlockOffset, preview.pos);
        for (PlacementBlock block : this.blocks.values()) {
            block.convertToSmallest();
        }
    }

    public Placement setPlaySounds(boolean sounds) {
        this.playSounds = sounds;
        return this;
    }

    public Placement setAfterNotifyPlace(boolean afterPlace) {
        this.notifyAfterPlace = afterPlace;
        return this;
    }

    public Placement setIgnoreWorldBoundaries(boolean value) {
        this.ignoreWorldBoundaries = value;
        return this;
    }

    public Placement setPredicate(BiPredicate<IParentTileList, LittleTile> predicate) {
        this.predicate = predicate;
        return this;
    }

    public Placement setStack(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    public void addRemovedIngredient(PlacementBlock block, LittleTile tile, LittleBoxReturnedVolume volume) {
        this.removedIngredients.add(LittleIngredient.extract(tile.getPreviewTile(), volume.getPercentVolume(block.getContext())));
    }

    public LittleIngredients overflow() {
        LittleIngredients ingredients = LittleAction.getIngredients(this.removedTiles);
        ingredients.add(this.removedIngredients);
        return ingredients;
    }

    public boolean canPlace() throws LittleActionException {
        this.affectedBlocks.setValue(0);
        for (BlockPos pos : this.blocks.keySet()) {
            if (LittleAction.isAllowedToInteract(this.world, this.player, pos, true, EnumFacing.EAST)) continue;
            LittleAction.sendBlockResetToClient(this.world, this.player, pos);
            return false;
        }
        List<BlockPos> coordsToCheck = this.mode.getCoordsToCheck(this.blocks.keySet(), this.pos);
        if (coordsToCheck != null) {
            for (BlockPos pos : coordsToCheck) {
                PlacementBlock block = this.blocks.get(pos);
                if (block == null || block.canPlace()) continue;
                return false;
            }
        }
        return true;
    }

    public PlacementResult place() throws LittleActionException {
        if (this.blocks.isEmpty()) {
            return null;
        }
        if (this.player != null && !this.world.field_72995_K) {
            if (this.player != null) {
                if (LittleTiles.CONFIG.isPlaceLimited(this.player) && this.previews.getVolumeIncludingChildren() > (double)((LittleBuildingConfig)LittleTiles.CONFIG.build.get((EntityPlayer)this.player)).maxPlaceBlocks) {
                    for (BlockPos pos : this.blocks.keySet()) {
                        LittleAction.sendBlockResetToClient(this.world, this.player, pos);
                    }
                    throw new LittleTilesConfig.NotAllowedToPlaceException(this.player);
                }
                if (LittleTiles.CONFIG.isTransparencyRestricted(this.player)) {
                    for (Object preview : this.previews) {
                        try {
                            LittleAction.isAllowedToPlacePreview(this.player, (LittlePreview)preview);
                        }
                        catch (LittleActionException littleActionException) {
                            for (BlockPos pos : this.blocks.keySet()) {
                                LittleAction.sendBlockResetToClient(this.world, this.player, pos);
                            }
                            throw littleActionException;
                        }
                    }
                }
            }
            this.affectedBlocks.setValue(0);
            ArrayList<BlockSnapshot> snaps = new ArrayList<BlockSnapshot>();
            for (BlockPos blockPos : this.blocks.keySet()) {
                snaps.add(new BlockSnapshot(this.world, blockPos, BlockTile.getState(false, false)));
            }
            BlockEvent.MultiPlaceEvent event = new BlockEvent.MultiPlaceEvent(snaps, this.world.func_180495_p(this.facing == null ? this.pos : this.pos.func_177972_a(this.facing)), this.player, EnumHand.MAIN_HAND);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                for (BlockPos snapPos : this.blocks.keySet()) {
                    LittleAction.sendBlockResetToClient(this.world, this.player, this.pos);
                }
                return null;
            }
        }
        try {
            if (this.canPlace()) {
                return this.placeTiles();
            }
        }
        catch (LittleActionException e) {
            for (BlockPos blockPos : this.blocks.keySet()) {
                LittleAction.sendBlockResetToClient(this.world, this.player, this.pos);
            }
            throw e;
        }
        return null;
    }

    public PlacementResult tryPlace() {
        try {
            return this.place();
        }
        catch (LittleActionException e) {
            return null;
        }
    }

    protected PlacementResult placeTiles() throws LittleActionException {
        PlacementResult result = new PlacementResult(this.pos);
        for (PlacementBlock block : this.blocks.values()) {
            block.place(result);
        }
        result.parentStructure = this.origin.isStructure() ? this.origin.getStructure() : null;
        LittleNeighborUpdateCollector neighbor = new LittleNeighborUpdateCollector(this.world, this.blocks.keySet());
        Iterator<Object> iterator = this.blocks.values().iterator();
        while (iterator.hasNext()) {
            PlacementBlock block = iterator.next();
            if (!block.combineTilesSecretly()) continue;
            result.tileEntities.remove(block.cached);
            iterator.remove();
        }
        for (PlacementBlock block : this.blocks.values()) {
            block.placeLate();
        }
        if (this.origin.isStructure()) {
            if (this.origin.getStructure() == null) {
                throw new LittleActionException("Missing missing mainblock of structure. Placed " + result.placedPreviews.size() + " tile(s).");
            }
            this.notifyStructurePlaced();
        }
        this.constructStructureRelations();
        for (PlacementStructurePreview preview : this.structures) {
            if (!preview.isStructure()) continue;
            preview.getStructure().afterPlaced();
        }
        neighbor.process();
        if (this.playSounds) {
            for (int i = 0; i < this.soundsToBePlayed.size(); ++i) {
                this.world.func_184133_a((EntityPlayer)null, this.pos, this.soundsToBePlayed.get(i).func_185841_e(), SoundCategory.BLOCKS, (this.soundsToBePlayed.get(i).func_185843_a() + 1.0f) / 2.0f, this.soundsToBePlayed.get(i).func_185847_b() * 0.8f);
            }
        }
        this.removedTiles.convertToSmallest();
        this.unplaceableTiles.convertToSmallest();
        for (PlacementStructurePreview preview : this.structures) {
            if (!preview.isStructure()) continue;
            preview.getStructure().finishedPlacement(this);
        }
        return result;
    }

    public void notifyStructurePlaced() {
        this.origin.getStructure().placedStructure(this.stack);
    }

    public void constructStructureRelations() {
        this.updateRelations(this.origin);
    }

    private void updateRelations(PlacementStructurePreview preview) {
        for (int i = 0; i < preview.children.size(); ++i) {
            PlacementStructurePreview child = preview.children.get(i);
            if (preview.getStructure() != null && child.getStructure() != null) {
                preview.getStructure().updateChildConnection(i, child.getStructure(), child.dynamic);
                child.getStructure().updateParentConnection(i, preview.getStructure(), child.dynamic);
            }
            this.updateRelations(child);
        }
    }

    public PlacementBlock getOrCreateBlock(BlockPos pos) {
        PlacementBlock block = this.blocks.get(pos);
        if (block == null) {
            block = new PlacementBlock(pos, this.previews.getContext());
            this.blocks.put(pos, block);
        }
        return block;
    }

    private PlacementStructurePreview createStructureTree(PlacementStructurePreview parent, LittlePreviews previews) {
        PlacementStructurePreview structure = new PlacementStructurePreview(parent, previews);
        for (LittlePreviews child : previews.getChildren()) {
            structure.addChild(this.createStructureTree(structure, child));
        }
        return structure;
    }

    private void createPreviews(PlacementStructurePreview current, LittleVec inBlockOffset, BlockPos pos) {
        if (current.previews != null) {
            HashMapList splitted = new HashMapList();
            for (PlacePreview pp : current.previews.getPlacePreviews(inBlockOffset)) {
                LittleBoxReturnedVolume volume = new LittleBoxReturnedVolume();
                pp.split(current.previews.getContext(), (HashMapList<BlockPos, PlacePreview>)splitted, pos, volume);
                if (!volume.has()) continue;
                this.unplaceableTiles.addPreview(pos, volume.createFakePreview(pp.preview), current.previews.getContext());
            }
            for (Map.Entry entry : splitted.entrySet()) {
                this.getOrCreateBlock((BlockPos)entry.getKey()).addPlacePreviews(current, current.index, (List)entry.getValue());
            }
        }
        for (PlacementStructurePreview child : current.children) {
            this.createPreviews(child, inBlockOffset, pos);
        }
    }

    public class PlacementStructurePreview {
        private LittleStructure cachedStructure;
        public final LittlePreviews previews;
        public final PlacementStructurePreview parent;
        public final int index;
        public final boolean dynamic;
        private int structureIndex = -1;
        List<PlacementStructurePreview> children = new ArrayList<PlacementStructurePreview>();

        public PlacementStructurePreview(PlacementStructurePreview parent, LittlePreviews previews) {
            this.index = Placement.this.structures.size();
            Placement.this.structures.add(this);
            this.dynamic = previews.isDynamic();
            this.parent = parent;
            this.previews = previews;
            if (previews instanceof LittlePreviewsStructureHolder) {
                this.cachedStructure = ((LittlePreviewsStructureHolder)previews).structure;
            }
        }

        public int getAttribute() {
            return this.previews.getStructureType().attribute;
        }

        public int getIndex() {
            if (this.structureIndex == -1) {
                this.structureIndex = Placement.this.availableIds.nextClearBit(0);
                Placement.this.availableIds.set(this.structureIndex);
            }
            return this.structureIndex;
        }

        public boolean isStructure() {
            return this.previews.hasStructure();
        }

        public void addChild(PlacementStructurePreview child) {
            this.children.add(child);
        }

        public void place(StructureTileList parent) {
            if (this.cachedStructure == null) {
                this.cachedStructure = parent.setStructureNBT(this.previews.structureNBT);
            } else {
                StructureTileList.setRelativePos(parent, this.cachedStructure.mainBlock.getPos().func_177973_b((Vec3i)parent.getPos()));
                this.cachedStructure.addBlock(parent);
            }
        }

        public boolean isPlaced() {
            return this.isStructure() && this.cachedStructure != null;
        }

        public LittleStructure getStructure() {
            return this.cachedStructure;
        }
    }

    public class PlacementBlock
    implements IGridBased {
        public final BlockPos pos;
        private TileEntityLittleTiles cached;
        private LittleGridContext context;
        private final List<PlacePreview>[] previews;
        private final List<PlacePreview>[] latePreviews;
        private int attribute = 0;

        public PlacementBlock(BlockPos pos, LittleGridContext context) {
            this.pos = pos;
            this.context = context;
            this.previews = new List[Placement.this.structures.size()];
            this.latePreviews = new List[Placement.this.structures.size()];
            TileEntity tileEntity = Placement.this.world.func_175625_s(pos);
            if (tileEntity instanceof TileEntityLittleTiles) {
                this.cached = (TileEntityLittleTiles)tileEntity;
                this.cached.fillUsedIds(Placement.this.availableIds);
            }
        }

        @Override
        public LittleGridContext getContext() {
            return this.context;
        }

        public void addPlacePreviews(PlacementStructurePreview structure, int index, List<PlacePreview> previews) {
            List<PlacePreview> list = this.previews[index];
            if (list == null) {
                this.previews[index] = previews;
            } else {
                list.addAll(previews);
            }
            if (structure.isStructure()) {
                this.attribute |= structure.getAttribute();
            }
        }

        @Override
        public void convertTo(LittleGridContext to) {
            for (int i = 0; i < this.previews.length; ++i) {
                if (this.previews[i] == null) continue;
                for (PlacePreview preview : this.previews[i]) {
                    preview.convertTo(this.context, to);
                }
            }
            this.context = to;
        }

        @Override
        public void convertToSmallest() {
            int size = LittleGridContext.minSize;
            for (int i = 0; i < this.previews.length; ++i) {
                if (this.previews[i] == null) continue;
                for (PlacePreview preview : this.previews[i]) {
                    size = Math.max(size, preview.getSmallestContext(this.context));
                }
            }
            if (size < this.context.size) {
                this.convertTo(LittleGridContext.get(size));
            }
        }

        private boolean needsCollisionTest() {
            for (int i = 0; i < this.previews.length; ++i) {
                if (this.previews[i] == null) continue;
                for (PlacePreview preview : this.previews[i]) {
                    if (!preview.needsCollisionTest()) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean canPlace() throws LittleActionException {
            if (!this.needsCollisionTest()) {
                return true;
            }
            if (!(Placement.this.ignoreWorldBoundaries || this.pos.func_177956_o() >= 0 && this.pos.func_177956_o() < 256)) {
                return false;
            }
            TileEntityLittleTiles te = LittleAction.loadTe(Placement.this.player, Placement.this.world, this.pos, null, false, this.attribute);
            if (te != null) {
                int size = te.tilesCount();
                for (int i = 0; i < this.previews.length; ++i) {
                    if (this.previews[i] == null) continue;
                    size += this.previews[i].size();
                }
                if (size > LittleTiles.CONFIG.general.maxAllowedDensity) {
                    throw new LittleTilesConfig.TooDenseException();
                }
                LittleGridContext contextBefore = te.getContext();
                te.forceContext(this);
                for (int i = 0; i < this.previews.length; ++i) {
                    if (this.previews[i] == null) continue;
                    for (PlacePreview preview : this.previews[i]) {
                        if (!preview.needsCollisionTest()) continue;
                        if (Placement.this.mode.checkAll()) {
                            if (te.isSpaceForLittleTile(preview.box, Placement.this.predicate)) continue;
                            if (te.getContext() != contextBefore) {
                                te.convertTo(contextBefore);
                            }
                            return false;
                        }
                        if (te.isSpaceForLittleTile(preview.box, (x, y) -> x.isStructure() && (Placement.this.predicate == null || Placement.this.predicate.test((IParentTileList)x, (LittleTile)y)))) continue;
                        if (te.getContext() != contextBefore) {
                            te.convertTo(contextBefore);
                        }
                        return false;
                    }
                }
                this.cached = te;
                return true;
            }
            int size = 0;
            for (int i = 0; i < this.previews.length; ++i) {
                if (this.previews[i] == null) continue;
                size += this.previews[i].size();
            }
            if (size > LittleTiles.CONFIG.general.maxAllowedDensity) {
                throw new LittleTilesConfig.TooDenseException();
            }
            IBlockState state = Placement.this.world.func_180495_p(this.pos);
            if (state.func_185904_a().func_76222_j()) {
                return true;
            }
            return !Placement.this.mode.checkAll() && LittleAction.isBlockValid(state) && LittleAction.canConvertBlock(Placement.this.player, Placement.this.world, this.pos, state, Placement.this.affectedBlocks.incrementAndGet());
        }

        public boolean combineTilesSecretly() {
            if (this.cached == null) {
                return false;
            }
            if (this.hasStructure()) {
                for (int i = 0; i < this.previews.length; ++i) {
                    if (this.previews[i] == null || !Placement.this.structures.get(i).isStructure()) continue;
                    this.cached.combineTilesSecretly(Placement.this.structures.get(i).getIndex());
                }
                return false;
            }
            this.cached.combineTilesSecretly();
            return this.cached.tilesCount() == 1 && this.cached.convertBlockToVanilla();
        }

        public boolean hasStructure() {
            for (int i = 0; i < this.previews.length; ++i) {
                if (this.previews[i] == null || !Placement.this.structures.get(i).isStructure()) continue;
                return true;
            }
            return false;
        }

        public void place(PlacementResult result) throws LittleActionException {
            boolean hascollideBlock = false;
            for (int i = 0; i < this.previews.length; ++i) {
                if (this.previews[i] == null) continue;
                Iterator<PlacePreview> iterator = this.previews[i].iterator();
                while (iterator.hasNext()) {
                    PlacePreview preview = iterator.next();
                    if (preview.needsCollisionTest()) {
                        hascollideBlock = true;
                        continue;
                    }
                    if (this.latePreviews[i] == null) {
                        this.latePreviews[i] = new ArrayList<PlacePreview>();
                    }
                    this.latePreviews[i].add(preview);
                    iterator.remove();
                }
            }
            if (hascollideBlock) {
                boolean requiresCollisionTest = true;
                if (this.cached == null) {
                    if (!(Placement.this.world.func_180495_p(this.pos).func_177230_c() instanceof BlockTile) && Placement.this.world.func_180495_p(this.pos).func_185904_a().func_76222_j()) {
                        requiresCollisionTest = false;
                        Placement.this.world.func_175656_a(this.pos, BlockTile.getStateByAttribute(this.attribute));
                    }
                    this.cached = LittleAction.loadTe(Placement.this.player, Placement.this.world, this.pos, Placement.this.affectedBlocks, Placement.this.mode.shouldConvertBlock(), this.attribute);
                } else {
                    this.cached = this.cached.forceSupportAttribute(this.attribute);
                }
                if (this.cached != null) {
                    int size = this.cached.tilesCount();
                    for (int i = 0; i < this.previews.length; ++i) {
                        if (this.previews[i] == null) continue;
                        size += this.previews[i].size();
                    }
                    if (size > LittleTiles.CONFIG.general.maxAllowedDensity) {
                        throw new LittleTilesConfig.TooDenseException();
                    }
                    if (this.cached.isEmpty()) {
                        requiresCollisionTest = false;
                    }
                    boolean collsionTest = requiresCollisionTest;
                    this.cached.forceContext(this);
                    try {
                        this.cached.updateTilesSecretly(x -> {
                            for (int i = 0; i < this.previews.length; ++i) {
                                if (this.previews[i] == null || this.previews[i].isEmpty()) continue;
                                ParentTileList parent = x.noneStructureTiles();
                                PlacementStructurePreview structure = Placement.this.structures.get(i);
                                if (structure.isStructure()) {
                                    StructureTileList list = x.addStructure(structure.getIndex(), structure.getAttribute());
                                    structure.place(list);
                                    parent = list;
                                }
                                Placement.this.mode.prepareBlock(Placement.this, this, collsionTest);
                                for (PlacePreview preview : this.previews[i]) {
                                    try {
                                        for (LittleTile LT : preview.placeTile(Placement.this, this, parent, structure.getStructure(), collsionTest)) {
                                            if (Placement.this.playSounds && !Placement.this.soundsToBePlayed.contains(LT.getSound())) {
                                                Placement.this.soundsToBePlayed.add(LT.getSound());
                                            }
                                            parent.add(LT);
                                            result.addPlacedTile(parent, LT);
                                        }
                                    }
                                    catch (LittleActionException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            }
                        });
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof LittleActionException) {
                            throw (LittleActionException)e.getCause();
                        }
                        throw e;
                    }
                }
            }
        }

        public void placeLate() throws LittleActionException {
            for (int i = 0; i < this.latePreviews.length; ++i) {
                if (this.latePreviews[i] == null) continue;
                PlacementStructurePreview structure = Placement.this.structures.get(i);
                for (PlacePreview preview : this.latePreviews[i]) {
                    preview.placeTile(Placement.this, this, null, structure.getStructure(), false);
                }
            }
        }

        public TileEntityLittleTiles getTe() {
            return this.cached;
        }
    }
}

