/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.place;

import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.util.place.PlaceModeAll;
import com.creativemd.littletiles.common.util.place.Placement;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.math.BlockPos;

public class PlaceModeNormal
extends PlacementMode {
    public PlaceModeNormal(String name, PlacementMode.PreviewMode mode, boolean placeInside) {
        super(name, mode, placeInside);
    }

    @Override
    public PlacementMode place() {
        if (GuiScreen.func_146271_m()) {
            return PlacementMode.fill;
        }
        return super.place();
    }

    @Override
    public List<BlockPos> getCoordsToCheck(Set<BlockPos> splittedTiles, BlockPos pos) {
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        coords.add(pos);
        return coords;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<LittleTile> placeTile(Placement placement, Placement.PlacementBlock block, IParentTileList parent, LittleStructure structure, LittleTile tile, boolean requiresCollisionTest) throws LittleActionException {
        ArrayList<LittleTile> tiles = new ArrayList<LittleTile>();
        Pair<IParentTileList, LittleTile> intersecting = null;
        if (!requiresCollisionTest || (intersecting = block.getTe().intersectingTile(tile.getBox())) == null) {
            tiles.add(tile);
            return tiles;
        } else if (this instanceof PlaceModeAll) {
            if (intersecting.key != parent) throw new LittleActionException("Could not place all tiles");
            System.out.println("Structure is not valid ... some tiles will be left out");
            return tiles;
        } else {
            placement.unplaceableTiles.addTile(parent, tile);
        }
        return tiles;
    }
}

