/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.place;

import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.littletiles.client.gui.SubGuiMarkMode;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVecContext;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.IMarkMode;
import com.creativemd.littletiles.common.util.place.PlacementPosition;
import com.creativemd.littletiles.common.util.place.PlacementPreview;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MarkMode
implements IMarkMode {
    public PlacementPosition position = null;
    public boolean allowLowResolution = true;

    public static PlacementPosition loadPosition(PlacementPosition position, PlacementPreview preview) {
        if (!preview.previews.isAbsolute()) {
            position.setVecContext(new LittleVecContext(preview.box.getCenter(), preview.context));
            EnumFacing facing = position.facing;
            if (preview.mode.placeInside) {
                facing = facing.func_176734_d();
            }
            LittleVec center = preview.size.calculateCenter();
            LittleVec centerInv = preview.size.calculateInvertedCenter();
            switch (facing) {
                case EAST: {
                    position.getVec().x -= center.x;
                    break;
                }
                case WEST: {
                    position.getVec().x += centerInv.x;
                    break;
                }
                case UP: {
                    position.getVec().y -= center.y;
                    break;
                }
                case DOWN: {
                    position.getVec().y += centerInv.y;
                    break;
                }
                case SOUTH: {
                    position.getVec().z -= center.z;
                    break;
                }
                case NORTH: {
                    position.getVec().z += centerInv.z;
                    break;
                }
            }
            if (preview.previews.size() > 1 && preview.fixed) {
                position.addVec(preview.cachedOffset);
            }
        }
        return position;
    }

    public MarkMode(EntityPlayer player, PlacementPosition position, PlacementPreview preview) {
        this.position = MarkMode.loadPosition(position, preview);
    }

    @Override
    public boolean allowLowResolution() {
        return this.allowLowResolution;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public SubGui getConfigurationGui() {
        return new SubGuiMarkMode(this);
    }

    @Override
    public PlacementPosition getPosition() {
        return this.position.copy();
    }

    @Override
    public void render(LittleGridContext positionContext, double x, double y, double z) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        double posX = this.position.getPosX();
        double posY = this.position.getPosY();
        double posZ = this.position.getPosZ();
        AxisAlignedBB box = new AxisAlignedBB(x, y, z, x + positionContext.pixelSize, y + positionContext.pixelSize, z + positionContext.pixelSize).func_186662_g(0.002).func_72317_d(-x, -y, -z);
        GlStateManager.func_187441_d((float)4.0f);
        RenderGlobal.func_189697_a((AxisAlignedBB)box, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179097_i();
        GlStateManager.func_187441_d((float)1.0f);
        RenderGlobal.func_189697_a((AxisAlignedBB)box, (float)1.0f, (float)0.3f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    @Override
    public void move(LittleGridContext positionContext, EnumFacing facing) {
        LittleVec vec = new LittleVec(facing.func_176734_d());
        vec.scale(GuiScreen.func_146271_m() ? positionContext.size : 1);
        this.position.sub(new LittleVecContext(vec, positionContext));
    }

    @Override
    public void done() {
    }
}

