/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.parent;

import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.attribute.LittleStructureAttribute;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IParentTileList
extends Iterable<LittleTile> {
    public LittleTile first();

    public LittleTile last();

    public int size();

    public int totalSize();

    public boolean isStructure();

    default public boolean isStructureChildSafe(LittleStructure structure) {
        try {
            return this.isStructureChild(structure);
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            return false;
        }
    }

    public boolean isStructureChild(LittleStructure var1) throws CorruptedConnectionException, NotYetConnectedException;

    public boolean isMain();

    public LittleStructure getStructure() throws CorruptedConnectionException, NotYetConnectedException;

    public int getAttribute();

    public void setAttribute(int var1);

    public boolean isClient();

    public TileEntityLittleTiles getTe();

    default public World getWorld() {
        TileEntityLittleTiles te = this.getTe();
        if (te.func_145830_o()) {
            return te.func_145831_w();
        }
        return te.getTempWorld();
    }

    default public BlockPos getPos() {
        return this.getTe().func_174877_v();
    }

    default public LittleGridContext getContext() {
        return this.getTe().getContext();
    }

    @SideOnly(value=Side.CLIENT)
    default public LittleRenderBox getTileRenderingCube(LittleTile tile, LittleGridContext context, BlockRenderLayer layer) {
        LittleRenderBox box = tile.getRenderingCube(context, layer);
        if (box != null && this.isStructure() && LittleStructureAttribute.emissive(this.getAttribute())) {
            box.emissive = true;
        }
        return box;
    }
}

