/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.math.location;

import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LocalStructureLocation {
    public final BlockPos pos;
    public final int index;

    public LocalStructureLocation(BlockPos pos, int index) {
        this.pos = pos;
        this.index = index;
    }

    public LocalStructureLocation(LittleStructure structure) {
        this(structure.getPos(), structure.getIndex());
    }

    public LocalStructureLocation(NBTTagCompound nbt) {
        int[] posArray = nbt.func_74759_k("pos");
        if (posArray.length != 3) {
            throw new IllegalArgumentException("Invalid pos array length " + Arrays.toString(posArray));
        }
        this.pos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        this.index = nbt.func_74762_e("index");
    }

    public NBTTagCompound write() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74783_a("pos", new int[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p()});
        nbt.func_74768_a("index", this.index);
        return nbt;
    }

    public LittleStructure find(World world) throws LittleActionException {
        TileEntity te = world.func_175625_s(this.pos);
        if (te instanceof TileEntityLittleTiles) {
            IStructureTileList structure = ((TileEntityLittleTiles)te).getStructure(this.index);
            if (structure != null) {
                return structure.getStructure();
            }
            throw new LittleActionException.StructureNotFoundException();
        }
        throw new LittleActionException.TileEntityNotFoundException();
    }
}

