/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.math.box;

import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.VectorUtils;
import com.creativemd.creativecore.common.utils.math.box.CreativeAxisAlignedBB;
import com.creativemd.creativecore.common.utils.math.box.OrientatedBoundingBox;
import com.creativemd.creativecore.common.utils.math.geo.NormalPlane;
import com.creativemd.creativecore.common.utils.math.vec.VectorFan;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleTransformableBox;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import javax.annotation.Nullable;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class TransformableAxisBox
extends CreativeAxisAlignedBB {
    private LittleGridContext context;
    private LittleBox box;

    public TransformableAxisBox(LittleBox box, LittleGridContext context, double x1, double y1, double z1, double x2, double y2, double z2) {
        super(x1, y1, z1, x2, y2, z2);
        this.box = box;
        this.context = context;
    }

    public TransformableAxisBox setMaxY(double y2) {
        return new TransformableAxisBox(this.box, this.context, this.field_72340_a, this.field_72338_b, this.field_72339_c, this.field_72336_d, y2, this.field_72334_f);
    }

    public boolean equals(Object object) {
        if (object.getClass() == TransformableAxisBox.class) {
            return ((TransformableAxisBox)((Object)object)).field_72340_a == this.field_72340_a && ((TransformableAxisBox)((Object)object)).field_72338_b == this.field_72338_b && ((TransformableAxisBox)((Object)object)).field_72339_c == this.field_72339_c && ((TransformableAxisBox)((Object)object)).field_72336_d == this.field_72336_d && ((TransformableAxisBox)((Object)object)).field_72337_e == this.field_72337_e && ((TransformableAxisBox)((Object)object)).field_72334_f == this.field_72334_f && ((TransformableAxisBox)((Object)object)).context == this.context && ((TransformableAxisBox)((Object)object)).box == this.box;
        }
        return false;
    }

    public TransformableAxisBox contract(double p_191195_1_, double p_191195_3_, double p_191195_5_) {
        double d0 = this.field_72340_a;
        double d1 = this.field_72338_b;
        double d2 = this.field_72339_c;
        double d3 = this.field_72336_d;
        double d4 = this.field_72337_e;
        double d5 = this.field_72334_f;
        if (p_191195_1_ < 0.0) {
            d0 -= p_191195_1_;
        } else if (p_191195_1_ > 0.0) {
            d3 -= p_191195_1_;
        }
        if (p_191195_3_ < 0.0) {
            d1 -= p_191195_3_;
        } else if (p_191195_3_ > 0.0) {
            d4 -= p_191195_3_;
        }
        if (p_191195_5_ < 0.0) {
            d2 -= p_191195_5_;
        } else if (p_191195_5_ > 0.0) {
            d5 -= p_191195_5_;
        }
        return new TransformableAxisBox(this.box, this.context, d0, d1, d2, d3, d4, d5);
    }

    public TransformableAxisBox expand(double x, double y, double z) {
        double d0 = this.field_72340_a;
        double d1 = this.field_72338_b;
        double d2 = this.field_72339_c;
        double d3 = this.field_72336_d;
        double d4 = this.field_72337_e;
        double d5 = this.field_72334_f;
        if (x < 0.0) {
            d0 += x;
        } else if (x > 0.0) {
            d3 += x;
        }
        if (y < 0.0) {
            d1 += y;
        } else if (y > 0.0) {
            d4 += y;
        }
        if (z < 0.0) {
            d2 += z;
        } else if (z > 0.0) {
            d5 += z;
        }
        return new TransformableAxisBox(this.box, this.context, d0, d1, d2, d3, d4, d5);
    }

    public AxisAlignedBB func_72314_b(double x, double y, double z) {
        double d0 = this.field_72340_a - x;
        double d1 = this.field_72338_b - y;
        double d2 = this.field_72339_c - z;
        double d3 = this.field_72336_d + x;
        double d4 = this.field_72337_e + y;
        double d5 = this.field_72334_f + z;
        return new TransformableAxisBox(this.box, this.context, d0, d1, d2, d3, d4, d5);
    }

    public TransformableAxisBox intersect(AxisAlignedBB p_191500_1_) {
        double d0 = Math.max(this.field_72340_a, p_191500_1_.field_72340_a);
        double d1 = Math.max(this.field_72338_b, p_191500_1_.field_72338_b);
        double d2 = Math.max(this.field_72339_c, p_191500_1_.field_72339_c);
        double d3 = Math.min(this.field_72336_d, p_191500_1_.field_72336_d);
        double d4 = Math.min(this.field_72337_e, p_191500_1_.field_72337_e);
        double d5 = Math.min(this.field_72334_f, p_191500_1_.field_72334_f);
        return new TransformableAxisBox(this.box, this.context, d0, d1, d2, d3, d4, d5);
    }

    public AxisAlignedBB func_72317_d(double x, double y, double z) {
        return new TransformableAxisBox(this.box, this.context, this.field_72340_a + x, this.field_72338_b + y, this.field_72339_c + z, this.field_72336_d + x, this.field_72337_e + y, this.field_72334_f + z);
    }

    public AxisAlignedBB func_186670_a(BlockPos pos) {
        return new TransformableAxisBox(this.box, this.context, this.field_72340_a + (double)pos.func_177958_n(), this.field_72338_b + (double)pos.func_177956_o(), this.field_72339_c + (double)pos.func_177952_p(), this.field_72336_d + (double)pos.func_177958_n(), this.field_72337_e + (double)pos.func_177956_o(), this.field_72334_f + (double)pos.func_177952_p());
    }

    public double calculateYOffsetStepUp(AxisAlignedBB other, AxisAlignedBB otherY, double offset) {
        double newOffset = this.func_72323_b(otherY, offset);
        if (offset > 0.0 ? newOffset < offset : newOffset > offset) {
            return newOffset / 2.0;
        }
        return newOffset;
    }

    public LittleTransformableBox.VectorFanFaceCache getFaceCache(EnumFacing facing) {
        LittleTransformableBox.VectorFanCache cache = ((LittleTransformableBox)this.box).requestCache();
        if (cache != null) {
            return cache.get(facing);
        }
        return null;
    }

    public double calculateOffset(AxisAlignedBB other, EnumFacing.Axis axis, double offset) {
        if (offset == 0.0) {
            return offset;
        }
        if (Math.abs(offset) < 1.0E-7) {
            return offset;
        }
        boolean positive = offset > 0.0;
        EnumFacing direction = EnumFacing.func_181076_a((EnumFacing.AxisDirection)(positive ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)axis);
        EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)axis);
        EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)axis);
        double minOne = TransformableAxisBox.getMin((AxisAlignedBB)other, (EnumFacing.Axis)one);
        minOne -= Math.floor(this.getMin(one));
        minOne *= (double)this.context.size;
        double minTwo = TransformableAxisBox.getMin((AxisAlignedBB)other, (EnumFacing.Axis)two);
        minTwo -= Math.floor(this.getMin(two));
        minTwo *= (double)this.context.size;
        double maxOne = TransformableAxisBox.getMax((AxisAlignedBB)other, (EnumFacing.Axis)one);
        maxOne -= Math.floor(this.getMin(one));
        maxOne *= (double)this.context.size;
        double maxTwo = TransformableAxisBox.getMax((AxisAlignedBB)other, (EnumFacing.Axis)two);
        maxTwo -= Math.floor(this.getMin(two));
        double otherAxis = offset > 0.0 ? TransformableAxisBox.getMax((AxisAlignedBB)other, (EnumFacing.Axis)axis) : TransformableAxisBox.getMin((AxisAlignedBB)other, (EnumFacing.Axis)axis);
        otherAxis -= Math.floor(this.getMin(axis));
        otherAxis *= (double)this.context.size;
        NormalPlane[] cuttingPlanes = new NormalPlane[]{new NormalPlane(one, (float)minOne, EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)one)), new NormalPlane(two, (float)minTwo, EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)two)), new NormalPlane(one, (float)maxOne, EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)one)), new NormalPlane(two, (float)(maxTwo *= (double)this.context.size), EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)two))};
        VectorFan tempFan = new VectorFan(null);
        LittleTransformableBox.VectorFanFaceCache front = this.getFaceCache(direction.func_176734_d());
        if (front.hasAxisStrip()) {
            for (VectorFan vectorFan : front.axisStrips) {
                double d0;
                tempFan.set(vectorFan);
                if (!tempFan.cutWithoutCopy(cuttingPlanes)) continue;
                if (offset > 0.0 && TransformableAxisBox.getMax((AxisAlignedBB)other, (EnumFacing.Axis)axis) <= this.getMin(axis)) {
                    double d1 = this.getMin(axis) - TransformableAxisBox.getMax((AxisAlignedBB)other, (EnumFacing.Axis)axis);
                    if (d1 < offset) {
                        return d1;
                    }
                } else if (offset < 0.0 && TransformableAxisBox.getMin((AxisAlignedBB)other, (EnumFacing.Axis)axis) >= this.getMax(axis) && (d0 = this.getMax(axis) - TransformableAxisBox.getMin((AxisAlignedBB)other, (EnumFacing.Axis)axis)) > offset) {
                    return d0;
                }
                return offset;
            }
        }
        double distance = Double.POSITIVE_INFINITY;
        for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
            LittleTransformableBox.VectorFanFaceCache face;
            EnumFacing facing = EnumFacing.field_82609_l[i];
            if (facing == direction || !(face = this.getFaceCache(facing)).hasTiltedStrip()) continue;
            for (VectorFan vectorFan : face.tilted()) {
                tempFan.set(vectorFan);
                tempFan.cutWithoutCopy(cuttingPlanes);
                if (tempFan.isEmpty()) continue;
                for (int j = 0; j < tempFan.count(); ++j) {
                    double tempDistance;
                    Vector3f vec = tempFan.get(j);
                    double d = tempDistance = positive ? (double)VectorUtils.get((EnumFacing.Axis)axis, (Tuple3f)vec) - otherAxis : otherAxis - (double)VectorUtils.get((EnumFacing.Axis)axis, (Tuple3f)vec);
                    if (tempDistance < 0.0 && !OrientatedBoundingBox.equals((double)tempDistance, (double)0.0)) {
                        return offset;
                    }
                    if (!(tempDistance < distance)) continue;
                    distance = tempDistance;
                }
            }
        }
        if (Double.isInfinite(distance)) {
            return offset;
        }
        distance *= this.context.pixelSize;
        if (offset > 0.0) {
            if (distance < offset) {
                return distance;
            }
            return offset;
        }
        if (offset < 0.0) {
            if (-distance > offset) {
                return -distance;
            }
            return offset;
        }
        return offset;
    }

    private static Vector3f[] reverse(Vector3f[] array) {
        Vector3f[] b = new Vector3f[array.length];
        int j = array.length;
        for (int i = 0; i < array.length; ++i) {
            b[j - 1] = array[i];
            --j;
        }
        return b;
    }

    public double func_72316_a(AxisAlignedBB other, double offsetX) {
        return this.calculateOffset(other, EnumFacing.Axis.X, offsetX);
    }

    public double func_72323_b(AxisAlignedBB other, double offsetY) {
        return this.calculateOffset(other, EnumFacing.Axis.Y, offsetY);
    }

    public double func_72322_c(AxisAlignedBB other, double offsetZ) {
        return this.calculateOffset(other, EnumFacing.Axis.Z, offsetZ);
    }

    @Nullable
    protected Vec3d collideWithPlane(EnumFacing.Axis axis, double value, Vec3d vecA, Vec3d vecB) {
        Vec3d vec3d = axis != EnumFacing.Axis.X ? (axis != EnumFacing.Axis.Y ? vecA.func_72434_d(vecB, value) : vecA.func_72435_c(vecB, value)) : vecA.func_72429_b(vecB, value);
        return vec3d != null && this.intersectsWithAxis(axis, vec3d) ? vec3d : null;
    }

    public boolean intersectsWithAxis(EnumFacing.Axis axis, Vec3d vec) {
        switch (axis) {
            case X: {
                return this.func_186660_b(vec);
            }
            case Y: {
                return this.func_186667_c(vec);
            }
            case Z: {
                return this.func_186669_d(vec);
            }
        }
        return false;
    }

    public String toString() {
        return "tbb[" + this.field_72340_a + ", " + this.field_72338_b + ", " + this.field_72339_c + " -> " + this.field_72336_d + ", " + this.field_72337_e + ", " + this.field_72334_f + "]";
    }
}

