/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type.premade.signal;

import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.VectorUtils;
import com.creativemd.creativecore.common.utils.math.box.AlignedBox;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.signal.component.ISignalComponent;
import com.creativemd.littletiles.common.structure.signal.component.ISignalStructureBase;
import com.creativemd.littletiles.common.structure.signal.component.InvalidSignalComponent;
import com.creativemd.littletiles.common.structure.signal.component.SignalComponentType;
import com.creativemd.littletiles.common.structure.signal.network.SignalNetwork;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.vec.SurroundingBox;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleSignalCableBase
extends LittleStructurePremade
implements ISignalStructureBase {
    public static final int DEFAULT_CABLE_COLOR = -13619152;
    private SignalNetwork network;
    public int color;
    protected LittleConnectionFace[] faces = new LittleConnectionFace[this.getNumberOfConnections()];

    public LittleSignalCableBase(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    @Override
    public boolean compatible(ISignalStructureBase other) {
        if (ISignalStructureBase.super.compatible(other)) {
            if (other.getType() == SignalComponentType.TRANSMITTER && this.getType() == SignalComponentType.TRANSMITTER) {
                return other.getColor() == -13619152 || this.getColor() == -13619152 || this.getColor() == other.getColor();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasStructureColor() {
        return true;
    }

    @Override
    public int getStructureColor() {
        return this.color;
    }

    @Override
    public int getDefaultColor() {
        return -13619152;
    }

    @Override
    public void paint(int color) {
        this.color = color;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public SignalNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(SignalNetwork network) {
        this.network = network;
    }

    @Override
    public World getStructureWorld() {
        return this.getWorld();
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        int[] result = nbt.func_74759_k("faces");
        if (result != null && result.length == this.getNumberOfConnections() * 3) {
            for (int i = 0; i < this.faces.length; ++i) {
                int distance = result[i * 3];
                if (distance < 0) {
                    this.faces[i] = null;
                    continue;
                }
                this.faces[i] = new LittleConnectionFace();
                this.faces[i].distance = distance;
                this.faces[i].context = LittleGridContext.get(result[i * 3 + 1]);
                this.faces[i].oneSidedRenderer = result[i * 3 + 2] == 1;
            }
        } else if (result != null && result.length == this.getNumberOfConnections() * 2) {
            for (int i = 0; i < this.faces.length; ++i) {
                int distance = result[i * 2];
                if (distance < 0) {
                    this.faces[i] = null;
                    continue;
                }
                this.faces[i] = new LittleConnectionFace();
                this.faces[i].distance = distance;
                this.faces[i].context = LittleGridContext.get(result[i * 2 + 1]);
            }
        }
        this.color = nbt.func_74764_b("color") ? nbt.func_74762_e("color") : -13619152;
    }

    @Override
    protected void writeToNBTExtraInternal(NBTTagCompound nbt, boolean preview) {
        super.writeToNBTExtraInternal(nbt, preview);
        if (!preview && this.faces != null) {
            int[] result = new int[this.getNumberOfConnections() * 3];
            for (int i = 0; i < this.faces.length; ++i) {
                if (this.faces[i] != null && !this.faces[i].invalid) {
                    result[i * 3] = this.faces[i].distance;
                    result[i * 3 + 1] = this.faces[i].context.size;
                    result[i * 3 + 2] = this.faces[i].oneSidedRenderer ? 1 : 0;
                    continue;
                }
                result[i * 3] = -1;
                result[i * 3 + 1] = 0;
                result[i * 3 + 2] = 0;
            }
            nbt.func_74783_a("faces", result);
        }
        if (this.color != -1) {
            nbt.func_74768_a("color", this.color);
        }
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
    }

    public abstract EnumFacing getFacing(int var1);

    public abstract int getIndex(EnumFacing var1);

    @Override
    public int getBandwidth() {
        return ((LittleStructureTypeNetwork)this.type).bandwidth;
    }

    public int getNumberOfConnections() {
        return ((LittleStructureTypeNetwork)this.type).numberOfConnections;
    }

    @Override
    public boolean connect(EnumFacing facing, ISignalStructureBase base, LittleGridContext context, int distance, boolean oneSidedRenderer) {
        int index = this.getIndex(facing);
        if (this.faces[index] != null) {
            if (this.faces[index].getConnection() == base) {
                return false;
            }
            this.faces[index].disconnect(facing);
        } else {
            this.faces[index] = new LittleConnectionFace();
        }
        this.faces[index].connect(base, context, distance, oneSidedRenderer);
        return true;
    }

    @Override
    public void disconnect(EnumFacing facing, ISignalStructureBase base) {
        int index = this.getIndex(facing);
        if (this.faces[index] != null) {
            this.faces[index] = null;
            this.updateStructure();
        }
    }

    @Override
    public void neighbourChanged() {
        try {
            this.load();
            if (this.getWorld().field_72995_K) {
                return;
            }
            LittleAbsoluteBox box = this.getSurroundingBox().getAbsoluteBox();
            boolean changed = false;
            for (int i = 0; i < this.faces.length; ++i) {
                EnumFacing facing = this.getFacing(i);
                LittleConnectResult result = this.checkConnection(facing, box);
                if (result != null) {
                    changed |= this.connect(facing, result.base, result.context, result.distance, result.oneSidedRenderer);
                    changed |= result.base.connect(facing.func_176734_d(), this, result.context, result.distance, result.oneSidedRenderer);
                    continue;
                }
                if (this.faces[i] != null) {
                    this.faces[i].disconnect(facing);
                    changed = true;
                }
                this.faces[i] = null;
            }
            if (changed) {
                this.findNetwork();
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
    }

    @Override
    public Iterator<ISignalStructureBase> connections() {
        try {
            this.load();
            return new Iterator<ISignalStructureBase>(){
                LittleAbsoluteBox box;
                int index;
                {
                    this.box = LittleSignalCableBase.this.getSurroundingBox().getAbsoluteBox();
                    this.index = this.searchForNextIndex(0);
                }

                int searchForNextIndex(int index) {
                    while (!(index >= LittleSignalCableBase.this.faces.length || LittleSignalCableBase.this.faces[index] != null && LittleSignalCableBase.this.faces[index].verifyConnect(LittleSignalCableBase.this.getFacing(index), this.box))) {
                        LittleSignalCableBase.this.faces[index] = null;
                        ++index;
                    }
                    return index;
                }

                @Override
                public boolean hasNext() {
                    return this.index < LittleSignalCableBase.this.faces.length && LittleSignalCableBase.this.faces[this.index] != null;
                }

                @Override
                public ISignalStructureBase next() {
                    ISignalStructureBase next = LittleSignalCableBase.this.faces[this.index].getConnection();
                    this.index = this.searchForNextIndex(this.index + 1);
                    return next;
                }
            };
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            return new Iterator<ISignalStructureBase>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public ISignalStructureBase next() {
                    return null;
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LittleConnectResult checkConnection(World world, LittleAbsoluteBox box, EnumFacing facing, BlockPos pos) throws ConnectionException, NotYetConnectedException {
        try {
            Chunk chunk = world.func_175726_f(pos);
            if (chunk == null) {
                throw new NotYetConnectedException();
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileEntityLittleTiles) {
                TileEntityLittleTiles te = (TileEntityLittleTiles)tileEntity;
                LittleTile closest = null;
                IParentTileList parent = null;
                int minDistance = 0;
                for (Pair<IParentTileList, LittleTile> pair : te.allTiles()) {
                    int distance;
                    LittleTile tile = (LittleTile)pair.value;
                    if (((IParentTileList)pair.key).isStructureChild(this) || (distance = box.getDistanceIfEqualFromOneSide(facing, tile.getBox(), ((IParentTileList)pair.key).getPos(), ((IParentTileList)pair.key).getContext())) < 0 || closest != null && minDistance <= distance) continue;
                    closest = tile;
                    parent = (IParentTileList)pair.key;
                    minDistance = distance;
                }
                if (closest != null && parent.isStructure()) {
                    LittleStructure structure = parent.getStructure();
                    if (structure instanceof ISignalStructureBase && ((ISignalStructureBase)((Object)structure)).compatible(this)) {
                        box = box.createBoxFromFace(facing, minDistance);
                        HashMapList<BlockPos, LittleBox> boxes = box.splitted();
                        for (Map.Entry entry : boxes.entrySet()) {
                            TileEntity toSearchIn = world.func_175625_s((BlockPos)entry.getKey());
                            if (toSearchIn instanceof TileEntityLittleTiles) {
                                TileEntityLittleTiles parsedSearch = (TileEntityLittleTiles)toSearchIn;
                                LittleBox toCheck = (LittleBox)((ArrayList)entry.getValue()).get(0);
                                try {
                                    parsedSearch.convertToAtMinimum(box.getContext());
                                    if (parsedSearch.getContext().size > box.getContext().size) {
                                        toCheck.convertTo(box.getContext(), parsedSearch.getContext());
                                    }
                                    if (parsedSearch.isSpaceForLittleTile(toCheck)) continue;
                                    throw new ConnectionException("No space");
                                }
                                finally {
                                    parsedSearch.convertToSmallest();
                                    continue;
                                }
                            }
                            if (world.func_180495_p((BlockPos)entry.getKey()).func_185904_a().func_76222_j()) continue;
                            throw new ConnectionException("Block in the way");
                        }
                        ISignalStructureBase base = (ISignalStructureBase)((Object)structure);
                        if (base.canConnect(facing.func_176734_d())) {
                            return new LittleConnectResult(base, box.getContext(), minDistance, false);
                        }
                        throw new ConnectionException("Side is invalid");
                    }
                    if (closest != null) {
                        throw new ConnectionException("Tile in the way");
                    }
                }
            } else if (tileEntity instanceof ISignalStructureBase && ((ISignalStructureBase)tileEntity).compatible(this)) {
                EnumFacing.Axis axis = facing.func_176740_k();
                boolean positive = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
                LittleGridContext context = box.context;
                int minDistance = positive ? 0 - context.toGrid(VectorUtils.get((EnumFacing.Axis)axis, (Vec3i)box.pos) - VectorUtils.get((EnumFacing.Axis)axis, (Vec3i)pos)) - box.box.getMax(axis) : box.box.getMin(axis) - (context.size - context.toGrid(VectorUtils.get((EnumFacing.Axis)axis, (Vec3i)box.pos) - VectorUtils.get((EnumFacing.Axis)axis, (Vec3i)pos)));
                box = box.createBoxFromFace(facing, minDistance);
                HashMapList<BlockPos, LittleBox> boxes = box.splitted();
                for (Map.Entry entry : boxes.entrySet()) {
                    TileEntity toSearchIn = world.func_175625_s((BlockPos)entry.getKey());
                    if (toSearchIn instanceof TileEntityLittleTiles) {
                        TileEntityLittleTiles parsedSearch = (TileEntityLittleTiles)toSearchIn;
                        LittleBox toCheck = (LittleBox)((ArrayList)entry.getValue()).get(0);
                        try {
                            parsedSearch.convertToAtMinimum(box.getContext());
                            if (parsedSearch.getContext().size > box.getContext().size) {
                                toCheck.convertTo(box.getContext(), parsedSearch.getContext());
                            }
                            if (parsedSearch.isSpaceForLittleTile(toCheck)) continue;
                            throw new ConnectionException("No space");
                        }
                        finally {
                            parsedSearch.convertToSmallest();
                            continue;
                        }
                    }
                    if (world.func_180495_p((BlockPos)entry.getKey()).func_185904_a().func_76222_j()) continue;
                    throw new ConnectionException("Block in the way");
                }
                ISignalStructureBase base = (ISignalStructureBase)tileEntity;
                if (base.canConnect(facing.func_176734_d())) {
                    return new LittleConnectResult(base, box.getContext(), minDistance, true);
                }
                throw new ConnectionException("Side is invalid");
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
        return null;
    }

    public LittleConnectResult checkConnection(EnumFacing facing, LittleAbsoluteBox box) throws NotYetConnectedException {
        boolean positive;
        if (!this.canConnect(facing)) {
            return null;
        }
        BlockPos pos = box.getMinPos();
        EnumFacing.Axis axis = facing.func_176740_k();
        boolean bl = positive = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
        if (positive) {
            pos = VectorUtils.set((BlockPos)pos, (int)box.getMaxPos(axis), (EnumFacing.Axis)axis);
        }
        World world = this.getWorld();
        try {
            LittleConnectResult result;
            if ((positive ? box.getMaxGridFrom(axis, pos) < box.getContext().size : box.getMinGridFrom(axis, pos) > 0) && (result = this.checkConnection(world, box, facing, pos)) != null) {
                return result;
            }
            return this.checkConnection(world, box, facing, pos.func_177972_a(facing));
        }
        catch (ConnectionException e) {
            return null;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getRenderingCubes(BlockPos pos, BlockRenderLayer layer, List<LittleRenderBox> cubes) {
        if (ColorUtils.isInvisible((int)this.color)) {
            return;
        }
        if (layer != (ColorUtils.isTransparent((int)this.color) ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.SOLID)) {
            return;
        }
        try {
            SurroundingBox box = this.getSurroundingBox();
            LittleVec min = box.getMinPosOffset();
            LittleVec max = box.getSize();
            max.add(min);
            LittleBox overallBox = new LittleBox(min, max);
            BlockPos difference = pos.func_177973_b((Vec3i)box.getMinPos());
            overallBox.sub(box.getContext().toGrid(difference.func_177958_n()), box.getContext().toGrid(difference.func_177956_o()), box.getContext().toGrid(difference.func_177952_p()));
            this.render(box, overallBox, cubes);
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderFace(EnumFacing facing, LittleGridContext context, LittleBox renderBox, int distance, EnumFacing.Axis axis, EnumFacing.Axis one, EnumFacing.Axis two, boolean positive, boolean oneSidedRenderer, List<LittleRenderBox> cubes) {
        if (positive) {
            renderBox.setMin(axis, renderBox.getMax(axis));
            renderBox.setMax(axis, renderBox.getMax(axis) + distance);
        } else {
            renderBox.setMax(axis, renderBox.getMin(axis));
            renderBox.setMin(axis, renderBox.getMin(axis) - distance);
        }
        LittleRenderBox cube = renderBox.getRenderingCube(context, LittleTiles.singleCable, axis.ordinal());
        if (!oneSidedRenderer) {
            if (positive) {
                cube.setMax(axis, cube.getMin(axis) + cube.getSize(axis) / 2.0f);
            } else {
                cube.setMin(axis, cube.getMax(axis) - cube.getSize(axis) / 2.0f);
            }
        }
        cube.color = this.color;
        cube.keepVU = true;
        cube.allowOverlap = true;
        float shrink = 0.18f;
        float shrinkOne = cube.getSize(one) * shrink;
        float shrinkTwo = cube.getSize(two) * shrink;
        cube.setMin(one, cube.getMin(one) + shrinkOne);
        cube.setMax(one, cube.getMax(one) - shrinkOne);
        cube.setMin(two, cube.getMin(two) + shrinkTwo);
        cube.setMax(two, cube.getMax(two) - shrinkTwo);
        cubes.add(cube);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(SurroundingBox box, LittleBox overallBox, List<LittleRenderBox> cubes) {
        for (int i = 0; i < this.faces.length; ++i) {
            if (this.faces[i] == null) continue;
            int distance = this.faces[i].distance;
            EnumFacing facing = this.getFacing(i);
            EnumFacing.Axis axis = facing.func_176740_k();
            EnumFacing.Axis one = RotationUtils.getOne((EnumFacing.Axis)axis);
            EnumFacing.Axis two = RotationUtils.getTwo((EnumFacing.Axis)axis);
            boolean positive = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
            LittleGridContext context = this.faces[i].context;
            LittleBox renderBox = overallBox.copy();
            if (box.getContext().size > context.size) {
                distance *= box.getContext().size / context.size;
                context = box.getContext();
            } else if (context.size > box.getContext().size) {
                renderBox.convertTo(box.getContext(), context);
            }
            this.renderFace(facing, context, renderBox, distance, axis, one, two, positive, this.faces[i].oneSidedRenderer, cubes);
        }
    }

    @Override
    public void onStructureDestroyed() {
        if (this.network != null && this.network.remove(this)) {
            for (int i = 0; i < this.faces.length; ++i) {
                if (this.faces[i] == null) continue;
                ISignalStructureBase connection = this.faces[i].connection;
                this.faces[i].disconnect(this.getFacing(i));
                if (connection == null) continue;
                connection.findNetwork();
            }
        }
    }

    @Override
    public void unload() {
        super.unload();
        for (int i = 0; i < this.faces.length; ++i) {
            if (this.faces[i] == null) continue;
            this.faces[i].unload(this.getFacing(i));
        }
        if (this.network != null) {
            this.network.unload(this);
        }
    }

    @Override
    public void unload(EnumFacing facing, ISignalStructureBase base) {
        int index = this.getIndex(facing);
        if (this.faces[index] != null) {
            this.faces[index].connection = null;
        }
    }

    public static abstract class LittleStructureTypeNetwork
    extends LittleStructurePremade.LittleStructureTypePremade
    implements ISignalComponent {
        public final int bandwidth;
        public final int numberOfConnections;

        public LittleStructureTypeNetwork(String id, String category, Class<? extends LittleStructure> structureClass, int attribute, String modid, int bandwidth, int numberOfConnections) {
            super(id, category, structureClass, attribute | 0x10000, modid);
            this.bandwidth = bandwidth;
            this.numberOfConnections = numberOfConnections;
        }

        public int getColor(LittlePreviews previews) {
            if (previews.structureNBT.func_74764_b("color")) {
                return previews.structureNBT.func_74762_e("color");
            }
            return -13619152;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<LittleRenderBox> getPositingCubes(World world, BlockPos pos, ItemStack stack) {
            try {
                ArrayList<LittleRenderBox> cubes = new ArrayList<LittleRenderBox>();
                for (int i = 0; i < 6; ++i) {
                    EnumFacing facing = EnumFacing.field_82609_l[i];
                    EnumFacing.Axis axis = facing.func_176740_k();
                    TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(facing));
                    if (!(tileEntity instanceof TileEntityLittleTiles)) continue;
                    for (LittleStructure structure : ((TileEntityLittleTiles)tileEntity).loadedStructures()) {
                        if (!(structure instanceof ISignalStructureBase) || ((ISignalStructureBase)((Object)structure)).getBandwidth() != this.bandwidth || !((ISignalStructureBase)((Object)structure)).canConnect(facing.func_176734_d())) continue;
                        LittleRenderBox cube = new LittleRenderBox(new AlignedBox(structure.getSurroundingBox().getAABB().func_72317_d((double)(-tileEntity.func_174877_v().func_177958_n()), (double)(-tileEntity.func_174877_v().func_177956_o()), (double)(-tileEntity.func_174877_v().func_177952_p()))), null, Blocks.field_150350_a, 0);
                        cube.setMin(axis, 0.0f);
                        cube.setMax(axis, 1.0f);
                        cubes.add(cube);
                    }
                }
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity instanceof TileEntityLittleTiles) {
                    for (LittleStructure structure : ((TileEntityLittleTiles)tileEntity).loadedStructures()) {
                        LittleRenderBox cube;
                        if (!(structure instanceof ISignalStructureBase) || ((ISignalStructureBase)((Object)structure)).getBandwidth() != this.bandwidth) continue;
                        AxisAlignedBB box = structure.getSurroundingBox().getAABB().func_72317_d((double)(-tileEntity.func_174877_v().func_177958_n()), (double)(-tileEntity.func_174877_v().func_177956_o()), (double)(-tileEntity.func_174877_v().func_177952_p()));
                        if (((ISignalStructureBase)((Object)structure)).canConnect(EnumFacing.WEST) || ((ISignalStructureBase)((Object)structure)).canConnect(EnumFacing.EAST)) {
                            cube = new LittleRenderBox(new AlignedBox(box), null, Blocks.field_150350_a, 0);
                            if (((ISignalStructureBase)((Object)structure)).canConnect(EnumFacing.WEST)) {
                                cube.setMin(EnumFacing.Axis.X, 0.0f);
                            }
                            if (((ISignalStructureBase)((Object)structure)).canConnect(EnumFacing.EAST)) {
                                cube.setMax(EnumFacing.Axis.X, 1.0f);
                            }
                            cubes.add(cube);
                        }
                        if (((ISignalStructureBase)((Object)structure)).canConnect(EnumFacing.DOWN) || ((ISignalStructureBase)((Object)structure)).canConnect(EnumFacing.UP)) {
                            cube = new LittleRenderBox(new AlignedBox(box), null, Blocks.field_150350_a, 0);
                            if (((ISignalStructureBase)((Object)structure)).canConnect(EnumFacing.DOWN)) {
                                cube.setMin(EnumFacing.Axis.Y, 0.0f);
                            }
                            if (((ISignalStructureBase)((Object)structure)).canConnect(EnumFacing.UP)) {
                                cube.setMax(EnumFacing.Axis.Y, 1.0f);
                            }
                            cubes.add(cube);
                        }
                        if (!((ISignalStructureBase)((Object)structure)).canConnect(EnumFacing.NORTH) && !((ISignalStructureBase)((Object)structure)).canConnect(EnumFacing.SOUTH)) continue;
                        cube = new LittleRenderBox(new AlignedBox(box), null, Blocks.field_150350_a, 0);
                        if (((ISignalStructureBase)((Object)structure)).canConnect(EnumFacing.NORTH)) {
                            cube.setMin(EnumFacing.Axis.Z, 0.0f);
                        }
                        if (((ISignalStructureBase)((Object)structure)).canConnect(EnumFacing.SOUTH)) {
                            cube.setMax(EnumFacing.Axis.Z, 1.0f);
                        }
                        cubes.add(cube);
                    }
                }
                if (cubes.isEmpty()) {
                    return null;
                }
                for (LittleRenderBox cube : cubes) {
                    cube.color = ColorUtils.RGBAToInt((int)255, (int)255, (int)255, (int)90);
                }
                return cubes;
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                return null;
            }
        }

        @Override
        public World getStructureWorld() {
            return null;
        }

        @Override
        public LittleStructure getStructure() {
            return null;
        }
    }

    public static class ConnectionException
    extends Exception {
        public ConnectionException(String msg) {
            super(msg);
        }
    }

    public static class LittleConnectResult {
        public final ISignalStructureBase base;
        public final LittleGridContext context;
        public final int distance;
        public final boolean oneSidedRenderer;

        public LittleConnectResult(ISignalStructureBase base, LittleGridContext context, int distance, boolean oneSidedRenderer) {
            this.base = base;
            this.context = context;
            this.distance = distance;
            this.oneSidedRenderer = oneSidedRenderer;
        }
    }

    public class LittleConnectionFace {
        public ISignalStructureBase connection;
        public int distance;
        public LittleGridContext context;
        public boolean oneSidedRenderer;
        private boolean invalid;

        public void disconnect(EnumFacing facing) {
            if (this.connection != null) {
                this.connection.disconnect(facing.func_176734_d(), LittleSignalCableBase.this);
                if (LittleSignalCableBase.this.hasNetwork()) {
                    LittleSignalCableBase.this.getNetwork().remove(LittleSignalCableBase.this);
                }
            }
            this.connection = null;
            LittleSignalCableBase.this.updateStructure();
        }

        public void unload(EnumFacing facing) {
            if (this.connection != null) {
                this.connection.unload(facing.func_176734_d(), LittleSignalCableBase.this);
            }
            this.connection = null;
        }

        public void connect(ISignalStructureBase connection, LittleGridContext context, int distance, boolean oneSidedRenderer) {
            if (this.connection != null) {
                throw new RuntimeException("Cannot connect until old connection is closed");
            }
            this.oneSidedRenderer = oneSidedRenderer;
            if (LittleSignalCableBase.this.hasNetwork()) {
                LittleSignalCableBase.this.getNetwork().add(connection);
            }
            this.connection = connection;
            this.context = context;
            this.distance = distance;
            LittleSignalCableBase.this.updateStructure();
        }

        public boolean verifyConnect(EnumFacing facing, LittleAbsoluteBox box) {
            if (this.connection != null) {
                return true;
            }
            try {
                LittleConnectResult result = LittleSignalCableBase.this.checkConnection(facing, box);
                this.invalid = false;
                if (result != null) {
                    this.connection = result.base;
                    this.context = result.context;
                    this.distance = result.distance;
                    return true;
                }
            }
            catch (NotYetConnectedException e) {
                this.invalid = true;
            }
            return false;
        }

        public ISignalStructureBase getConnection() {
            if (this.invalid) {
                return InvalidSignalComponent.INSTANCE;
            }
            return this.connection;
        }
    }
}

