/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type.premade;

import com.creativemd.creativecore.common.utils.mc.InventoryUtils;
import com.creativemd.littletiles.client.gui.handler.LittleStructureGuiHandler;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.type.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LittleStructureBuilder
extends LittleStructurePremade {
    private static HashMap<String, LittleStructureBuilderType> types = new HashMap();
    public InventoryBasic inventory = new InventoryBasic("recipe", false, 1);
    public int lastSizeX = 16;
    public int lastSizeY = 16;
    public int lastThickness = 1;
    public IBlockState lastBlockState;
    public String lastStructureType;
    public int lastGrid = 16;

    public static void register(LittleStructureBuilderType type) {
        types.put(type.type.id, type);
    }

    public static Set<String> getNames() {
        return types.keySet();
    }

    public static LittleStructureBuilderType get(String id) {
        return types.get(id);
    }

    public LittleStructureBuilder(LittleStructureType type, IStructureTileList mainBlock) {
        super(type, mainBlock);
    }

    @Override
    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        LittleStructureGuiHandler.openGui("structure_builder", new NBTTagCompound(), playerIn, this);
        return true;
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.lastSizeX = nbt.func_74764_b("sizeX") ? nbt.func_74762_e("sizeX") : 16;
        this.lastSizeY = nbt.func_74764_b("sizeY") ? nbt.func_74762_e("sizeY") : 16;
        this.lastThickness = nbt.func_74764_b("thickness") ? nbt.func_74762_e("thickness") : 1;
        this.lastGrid = nbt.func_74764_b("grid") ? nbt.func_74762_e("grid") : 16;
        this.lastStructureType = nbt.func_74779_i("type");
        if (nbt.func_74764_b("block")) {
            String[] parts = nbt.func_74779_i("block").split(":");
            Block block = Block.func_149684_b((String)(parts[0] + ":" + parts[1]));
            int meta = parts.length == 3 ? Integer.parseInt(parts[2]) : 0;
            this.lastBlockState = block.func_176203_a(meta);
        } else {
            this.lastBlockState = Blocks.field_150344_f.func_176223_P();
        }
        this.inventory = InventoryUtils.loadInventoryBasic((NBTTagCompound)nbt, (int)1);
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74768_a("sizeX", this.lastSizeX);
        nbt.func_74768_a("sizeY", this.lastSizeY);
        nbt.func_74768_a("thickness", this.lastThickness);
        InventoryUtils.saveInventoryBasic((IInventory)this.inventory);
        Block block = this.lastBlockState.func_177230_c();
        int meta = block.func_176201_c(this.lastBlockState);
        nbt.func_74778_a("block", block.getRegistryName().toString() + (meta != 0 ? ":" + meta : ""));
        nbt.func_74768_a("grid", this.lastGrid);
        nbt.func_74778_a("type", this.lastStructureType);
    }

    public static class LittleStructureBuilderType {
        public final LittleStructureType type;
        public final String frameVariableName;

        public LittleStructureBuilderType(LittleStructureType type, String frameVariableName) {
            this.type = type;
            this.frameVariableName = frameVariableName;
        }

        public LittlePreviews construct(LittleGridContext context, int width, int height, int thickness, NBTTagCompound tileData) {
            NBTTagCompound structureNBT = new NBTTagCompound();
            structureNBT.func_74778_a("id", this.type.id);
            structureNBT.func_74783_a("topRight", new int[]{Float.floatToIntBits(0.0f), Float.floatToIntBits(1.0f), Float.floatToIntBits(1.0f)});
            structureNBT.func_74783_a(this.frameVariableName, new int[]{thickness, 0, 0, thickness + 1, height, width, context.size});
            LittlePreviews previews = new LittlePreviews(structureNBT, context);
            for (int x = 0; x < thickness; x += context.size) {
                for (int y = 0; y < height; y += context.size) {
                    for (int z = 0; z < width; z += context.size) {
                        previews.addWithoutCheckingPreview(new LittlePreview(new LittleBox(x, y, z, Math.min(x + 16, thickness), Math.min(y + 16, height), Math.min(z + 16, width)), tileData.func_74737_b()));
                    }
                }
            }
            return previews;
        }
    }
}

