/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal.schedule;

import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.littletiles.common.structure.signal.output.SignalOutputHandler;
import com.creativemd.littletiles.common.structure.signal.schedule.ISignalScheduleTicket;
import com.creativemd.littletiles.common.structure.signal.schedule.SignalTicker;
import java.lang.ref.WeakReference;
import net.minecraft.world.World;

public class SignalScheduleTicket
implements ISignalScheduleTicket {
    private int delay;
    private final WeakReference<SignalOutputHandler> outputCondition;
    private final boolean[] result;

    public SignalScheduleTicket(SignalOutputHandler outputCondition, boolean[] result, int delay) {
        this.outputCondition = new WeakReference<SignalOutputHandler>(outputCondition);
        this.result = result;
        this.delay = delay;
    }

    public int tick() {
        --this.delay;
        return this.delay;
    }

    public void run() {
        SignalOutputHandler handler = (SignalOutputHandler)this.outputCondition.get();
        if (handler != null && handler.isStillAvailable()) {
            try {
                handler.performStateChange(this.result);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.markObsolete();
    }

    @Override
    public int getDelay() {
        SignalOutputHandler handler;
        if (this.inShortQueue() && (handler = (SignalOutputHandler)this.outputCondition.get()) != null) {
            return SignalTicker.get(handler.component).getDelayOfQueue(this.delay);
        }
        return this.delay;
    }

    public int getExactDelayValue() {
        return this.delay;
    }

    public boolean is(SignalOutputHandler output) {
        return this.outputCondition.get() == output;
    }

    public boolean inShortQueue() {
        return this.delay < 20;
    }

    public void enterShortQueue(int index) {
        this.delay = index;
    }

    @Override
    public boolean[] getState() {
        return this.result;
    }

    @Override
    public void overwriteState(boolean[] newState) {
        BooleanUtils.set((boolean[])this.result, (boolean[])newState);
    }

    @Override
    public void markObsolete() {
        this.outputCondition.clear();
    }

    public World getWorld() {
        SignalOutputHandler handler = (SignalOutputHandler)this.outputCondition.get();
        if (handler != null) {
            return handler.component.getStructureWorld();
        }
        return null;
    }
}

