/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal.output;

import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.signal.component.ISignalComponent;
import com.creativemd.littletiles.common.structure.signal.logic.SignalMode;
import net.minecraft.nbt.NBTTagCompound;

public abstract class SignalOutputHandler {
    public final ISignalComponent component;
    public final int delay;
    public boolean[] lastReacted;

    public SignalOutputHandler(ISignalComponent component, int delay, NBTTagCompound nbt) {
        this.component = component;
        this.delay = delay;
    }

    public abstract SignalMode getMode();

    public void schedule(boolean[] state) {
        if (this.lastReacted != null && BooleanUtils.equals((boolean[])state, (boolean[])this.lastReacted)) {
            return;
        }
        this.queue(state);
        if (this.lastReacted == null) {
            this.lastReacted = new boolean[state.length];
        }
        BooleanUtils.set((boolean[])this.lastReacted, (boolean[])state);
    }

    public abstract void queue(boolean[] var1);

    public void performStateChange(boolean[] state) {
        this.component.updateState(state);
    }

    public int getBandwidth() throws CorruptedConnectionException, NotYetConnectedException {
        return this.component.getBandwidth();
    }

    public abstract void write(boolean var1, NBTTagCompound var2);

    public static SignalOutputHandler create(ISignalComponent component, SignalMode mode, int delay, NBTTagCompound nbt, LittleStructure structure) {
        return mode.create(component, delay, nbt, structure != null && structure.hasWorld() && !structure.getWorld().field_72995_K);
    }

    public boolean isStillAvailable() {
        return this.component.getStructure().isStillAvailable();
    }

    public String toString() {
        return this.component.toString();
    }
}

