/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal.component;

import com.creativemd.littletiles.common.structure.signal.component.SignalComponentType;
import com.creativemd.littletiles.common.structure.signal.network.SignalNetwork;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.Iterator;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public interface ISignalStructureBase {
    default public boolean compatible(ISignalStructureBase other) {
        if (other.getType() != SignalComponentType.TRANSMITTER && other.getType() == this.getType()) {
            return false;
        }
        return this.getBandwidth() == other.getBandwidth();
    }

    public World getStructureWorld();

    public int getBandwidth();

    public SignalNetwork getNetwork();

    public void setNetwork(SignalNetwork var1);

    public Iterator<ISignalStructureBase> connections();

    public boolean canConnect(EnumFacing var1);

    public boolean connect(EnumFacing var1, ISignalStructureBase var2, LittleGridContext var3, int var4, boolean var5);

    public void disconnect(EnumFacing var1, ISignalStructureBase var2);

    public void unload(EnumFacing var1, ISignalStructureBase var2);

    default public boolean hasNetwork() {
        return this.getNetwork() != null;
    }

    default public SignalNetwork findNetwork() {
        if (this.hasNetwork()) {
            if (this.getNetwork().requiresResearch()) {
                this.getNetwork().deleteNetwork();
            } else {
                return this.getNetwork();
            }
        }
        Iterator<ISignalStructureBase> connections = this.connections();
        while (connections.hasNext()) {
            ISignalStructureBase connection = connections.next();
            if (!connection.hasNetwork()) continue;
            connection.getNetwork().add(this);
            return this.getNetwork();
        }
        SignalNetwork network = new SignalNetwork(this.getBandwidth());
        network.add(this);
        return this.getNetwork();
    }

    public SignalComponentType getType();

    public int getColor();
}

