/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.block;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.api.IFakeRenderingBlock;
import com.creativemd.littletiles.common.api.block.ISpecialBlockHandler;
import com.creativemd.littletiles.common.block.BlockLittleDyeableTransparent;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLTFlowingWater
extends Block
implements ISpecialBlockHandler,
IFakeRenderingBlock {
    public static final PropertyEnum<EnumFacing> DIRECTION = PropertyEnum.func_177709_a((String)"direction", EnumFacing.class);
    public final BlockLittleDyeableTransparent.LittleDyeableTransparent still;

    public BlockLTFlowingWater(BlockLittleDyeableTransparent.LittleDyeableTransparent still) {
        super(Material.field_151586_h);
        this.still = still;
        this.func_149647_a(LittleTiles.littleTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(DIRECTION, (Comparable)EnumFacing.EAST));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        if (block == this) {
            return false;
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(DIRECTION)).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(DIRECTION, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(DIRECTION)).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DIRECTION});
    }

    @Override
    public boolean canWalkThrough(LittleTile tile) {
        return true;
    }

    @Override
    public boolean isMaterial(LittleTile tile, Material material) {
        return material == Material.field_151586_h;
    }

    @Override
    public boolean isLiquid(LittleTile tile) {
        return true;
    }

    @Override
    public Vec3d modifyAcceleration(IParentTileList parent, LittleTile tile, Entity entityIn, Vec3d motion) {
        AxisAlignedBB box = entityIn.func_174813_aQ();
        LittleVec center = new LittleVec(parent.getContext(), new Vec3d((box.field_72340_a + box.field_72336_d) / 2.0, (box.field_72338_b + box.field_72337_e) / 2.0, (box.field_72339_c + box.field_72334_f) / 2.0).func_178788_d(new Vec3d((Vec3i)parent.getPos())));
        LittleBox testBox = new LittleBox(center, 1, 1, 1);
        if (tile.intersectsWith(testBox)) {
            double scale = 0.01;
            Vec3d vec = new Vec3d(((EnumFacing)tile.getBlockState().func_177229_b(DIRECTION)).func_176730_m()).func_72432_b();
            entityIn.field_70159_w += vec.field_72450_a * scale;
            entityIn.field_70181_x += vec.field_72448_b * scale;
            entityIn.field_70179_y += vec.field_72449_c * scale;
        }
        return new Vec3d(((EnumFacing)tile.getBlockState().func_177229_b(DIRECTION)).func_176730_m());
    }

    @Override
    public boolean canBeConvertedToVanilla(LittleTile tile) {
        return false;
    }

    @Override
    public IBlockState getFakeState(IBlockState state) {
        return Blocks.field_150358_i.func_176223_P();
    }

    @Override
    public boolean onBlockActivated(IParentTileList parent, LittleTile tile, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND && heldItem.func_77973_b() instanceof ItemBucket && LittleTiles.CONFIG.general.allowFlowingWater) {
            int meta = tile.getMeta() + 1;
            if (meta > EnumFacing.field_82609_l.length) {
                tile.setBlock(LittleTiles.dyeableBlockTransparent, this.still.ordinal());
            } else {
                tile.setMeta(meta);
            }
            parent.getTe().updateTiles();
            return true;
        }
        return ISpecialBlockHandler.super.onBlockActivated(parent, tile, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canBeRenderCombined(LittleTile thisTile, LittleTile tile) {
        if (tile.getBlock() == this) {
            return true;
        }
        return tile.getBlock() == LittleTiles.dyeableBlockTransparent && BlockLittleDyeableTransparent.LittleDyeableTransparent.values()[tile.getMeta()].isWater();
    }

    @Override
    public Vec3d getFogColor(IParentTileList parent, LittleTile tile, Entity entity, Vec3d originalColor, float partialTicks) {
        float f12 = 0.0f;
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase ent = (EntityLivingBase)entity;
            f12 = (float)EnchantmentHelper.func_185292_c((EntityLivingBase)ent) * 0.2f;
            if (ent.func_70644_a(MobEffects.field_76427_o)) {
                f12 = f12 * 0.3f + 0.6f;
            }
        }
        return new Vec3d((double)(0.02f + f12), (double)(0.02f + f12), (double)(0.2f + f12));
    }

    @Override
    public void rotatePreview(Rotation rotation, LittlePreview preview, LittleVec doubledCenter) {
        preview.getTileData().func_74768_a("meta", RotationUtils.rotate((EnumFacing)EnumFacing.func_82600_a((int)preview.getMeta()), (Rotation)rotation).ordinal());
    }

    @Override
    public void flipPreview(EnumFacing.Axis axis, LittlePreview preview, LittleVec doubledCenter) {
        EnumFacing facing = EnumFacing.func_82600_a((int)preview.getMeta());
        if (facing.func_176740_k() == axis) {
            facing = facing.func_176734_d();
        }
        preview.getTileData().func_74768_a("meta", facing.ordinal());
    }

    public static class LittleFlowingWaterPreview
    extends LittlePreview {
        public LittleFlowingWaterPreview(NBTTagCompound nbt) {
            super(nbt);
        }

        public LittleFlowingWaterPreview(LittleBox box, NBTTagCompound tileData) {
            super(box, tileData);
        }
    }
}

