/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.creativecore.common.utils.mc.PlayerUtils;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.LittleTilesConfig;
import com.creativemd.littletiles.client.LittleTilesClient;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.api.ILittleIngredientInventory;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.config.LittleBuildingConfig;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.event.ActionEvent;
import com.creativemd.littletiles.common.item.ItemPremadeStructure;
import com.creativemd.littletiles.common.mod.chiselsandbits.ChiselsAndBitsManager;
import com.creativemd.littletiles.common.mod.coloredlights.ColoredLightsManager;
import com.creativemd.littletiles.common.packet.LittleBlockUpdatePacket;
import com.creativemd.littletiles.common.packet.LittleBlocksUpdatePacket;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxesNoOverlap;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxesSimple;
import com.creativemd.littletiles.common.tile.math.location.StructureLocation;
import com.creativemd.littletiles.common.tile.math.location.TileLocation;
import com.creativemd.littletiles.common.tile.math.vec.LittleAbsoluteVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVecContext;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.compression.LittleNBTCompressionTools;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredient;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import com.creativemd.littletiles.common.util.ingredient.NotEnoughIngredientsException;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.creativemd.littletiles.common.util.selection.selector.TileSelector;
import com.creativemd.littletiles.common.util.tooltip.ActionMessage;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class LittleAction
extends CreativeCorePacket {
    private static List<LittleAction> lastActions = new ArrayList<LittleAction>();
    private static int index = 0;
    public List<LittleAction> furtherActions = null;
    private static Method WorldEditEvent = LittleAction.loadWorldEditEvent();
    private static Object worldEditInstance = null;

    @SideOnly(value=Side.CLIENT)
    public static boolean isUsingSecondMode(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        if (LittleTiles.CONFIG.building.useALTForEverything) {
            return GuiScreen.func_175283_s();
        }
        if (LittleTiles.CONFIG.building.useAltWhenFlying) {
            return player.field_71075_bZ.field_75100_b ? GuiScreen.func_175283_s() : player.func_70093_af();
        }
        return player.func_70093_af();
    }

    public static void rememberAction(LittleAction action) {
        if (!action.canBeReverted()) {
            return;
        }
        if (index > 0) {
            lastActions = index < lastActions.size() ? lastActions.subList(index, lastActions.size()) : new ArrayList<LittleAction>();
        }
        index = 0;
        if (lastActions.size() == LittleTiles.CONFIG.building.maxSavedActions) {
            lastActions.remove(LittleTiles.CONFIG.building.maxSavedActions - 1);
        }
        lastActions.add(0, action);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean undo() throws LittleActionException {
        if (lastActions.size() > index) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            LittleAction reverted = lastActions.get(index).revert((EntityPlayer)player);
            if (reverted == null) {
                throw new LittleActionException("action.revert.notavailable");
            }
            reverted.furtherActions = lastActions.get(index).revertFurtherActions();
            if (reverted.action((EntityPlayer)player)) {
                MinecraftForge.EVENT_BUS.post((Event)new ActionEvent(reverted, ActionEvent.ActionType.undo, (EntityPlayer)player));
                if (reverted.sendToServer()) {
                    PacketHandler.sendPacketToServer((CreativeCorePacket)reverted);
                }
                if (reverted.furtherActions != null && !reverted.furtherActions.isEmpty()) {
                    for (int i = 0; i < reverted.furtherActions.size(); ++i) {
                        LittleAction subAction = reverted.furtherActions.get(i);
                        if (subAction == null) continue;
                        try {
                            subAction.action((EntityPlayer)player);
                            if (!subAction.sendToServer()) continue;
                            PacketHandler.sendPacketToServer((CreativeCorePacket)subAction);
                            continue;
                        }
                        catch (LittleActionException e) {
                            LittleAction.handleExceptionClient(e);
                        }
                    }
                }
                lastActions.set(index, reverted);
                ++index;
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void unloadWorld() {
        lastActions.clear();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean redo() throws LittleActionException {
        if (index > 0 && index <= lastActions.size()) {
            LittleAction reverted;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if ((reverted = lastActions.get(--index).revert((EntityPlayer)player)) == null) {
                throw new LittleActionException("action.revert.notavailable");
            }
            reverted.furtherActions = lastActions.get(index).revertFurtherActions();
            if (reverted.action((EntityPlayer)player)) {
                MinecraftForge.EVENT_BUS.post((Event)new ActionEvent(reverted, ActionEvent.ActionType.redo, (EntityPlayer)player));
                if (reverted.sendToServer()) {
                    PacketHandler.sendPacketToServer((CreativeCorePacket)reverted);
                }
                if (reverted.furtherActions != null && !reverted.furtherActions.isEmpty()) {
                    for (int i = 0; i < reverted.furtherActions.size(); ++i) {
                        LittleAction subAction = reverted.furtherActions.get(i);
                        if (subAction == null) continue;
                        try {
                            subAction.action((EntityPlayer)player);
                            if (!subAction.sendToServer()) continue;
                            PacketHandler.sendPacketToServer((CreativeCorePacket)subAction);
                            continue;
                        }
                        catch (LittleActionException e) {
                            LittleAction.handleExceptionClient(e);
                        }
                    }
                }
                lastActions.set(index, reverted);
                return true;
            }
        }
        return false;
    }

    public static void registerLittleAction(String id, Class<? extends LittleAction> ... classTypes) {
        for (int i = 0; i < classTypes.length; ++i) {
            CreativeCorePacket.registerPacket(classTypes[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public abstract boolean canBeReverted();

    @SideOnly(value=Side.CLIENT)
    public abstract LittleAction revert(EntityPlayer var1) throws LittleActionException;

    private List<LittleAction> revertFurtherActions() {
        if (this.furtherActions == null || this.furtherActions.isEmpty()) {
            return null;
        }
        ArrayList<LittleAction> result = new ArrayList<LittleAction>(this.furtherActions.size());
        for (int i = this.furtherActions.size() - 1; i >= 0; --i) {
            result.add(this.furtherActions.get(i));
        }
        return result;
    }

    public boolean sendToServer() {
        return true;
    }

    protected abstract boolean action(EntityPlayer var1) throws LittleActionException;

    @SideOnly(value=Side.CLIENT)
    public boolean execute() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        try {
            if (this.action((EntityPlayer)player)) {
                LittleAction.rememberAction(this);
                MinecraftForge.EVENT_BUS.post((Event)new ActionEvent(this, ActionEvent.ActionType.normal, (EntityPlayer)player));
                if (this.sendToServer()) {
                    PacketHandler.sendPacketToServer((CreativeCorePacket)this);
                }
                if (this.furtherActions != null && !this.furtherActions.isEmpty()) {
                    for (int i = 0; i < this.furtherActions.size(); ++i) {
                        LittleAction subAction = this.furtherActions.get(i);
                        if (subAction == null) continue;
                        try {
                            subAction.action((EntityPlayer)player);
                            if (!subAction.sendToServer()) continue;
                            PacketHandler.sendPacketToServer((CreativeCorePacket)subAction);
                            continue;
                        }
                        catch (LittleActionException e) {
                            LittleAction.handleExceptionClient(e);
                        }
                    }
                }
                return true;
            }
        }
        catch (LittleActionException e) {
            LittleAction.handleExceptionClient(e);
        }
        return false;
    }

    public void executeClient(EntityPlayer player) {
    }

    public void executeServer(EntityPlayer player) {
        try {
            this.action(player);
        }
        catch (LittleActionException e) {
            player.func_146105_b((ITextComponent)new TextComponentString(e.getLocalizedMessage()), true);
        }
    }

    public boolean activateServer(EntityPlayer player) {
        try {
            return this.action(player);
        }
        catch (LittleActionException e) {
            return false;
        }
    }

    public abstract LittleAction flip(EnumFacing.Axis var1, LittleAbsoluteBox var2);

    @SideOnly(value=Side.CLIENT)
    public static void handleExceptionClient(LittleActionException e) {
        if (e.isHidden()) {
            return;
        }
        ActionMessage message = e.getActionMessage();
        if (message != null) {
            LittleTilesClient.displayActionMessage(message);
        } else {
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentString(e.getLocalizedMessage()), true);
        }
    }

    public static boolean canConvertBlock(EntityPlayer player, World world, BlockPos pos, IBlockState state, int affected) throws LittleActionException {
        if (((LittleBuildingConfig)LittleTiles.CONFIG.build.get((EntityPlayer)player)).limitAffectedBlocks && ((LittleBuildingConfig)LittleTiles.CONFIG.build.get((EntityPlayer)player)).maxAffectedBlocks < affected) {
            throw new LittleTilesConfig.NotAllowedToConvertBlockException(player);
        }
        if (!((LittleBuildingConfig)LittleTiles.CONFIG.build.get((EntityPlayer)player)).editUnbreakable && state.func_177230_c().func_176195_g(state, world, pos) < 0.0f) {
            throw new LittleTilesConfig.NotAllowedToConvertBlockException(player);
        }
        return LittleTiles.CONFIG.canEditBlock(player, state, pos);
    }

    public static boolean canUseUndoOrRedo(EntityPlayer player) {
        GameType type = PlayerUtils.getGameType((EntityPlayer)player);
        return type == GameType.CREATIVE || type == GameType.SURVIVAL;
    }

    public static boolean canPlace(EntityPlayer player) {
        GameType type = PlayerUtils.getGameType((EntityPlayer)player);
        return type == GameType.CREATIVE || type == GameType.SURVIVAL || type == GameType.ADVENTURE;
    }

    public static boolean canPlaceInside(LittlePreviews previews, World world, BlockPos pos, boolean placeInside) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.func_176200_f((IBlockAccess)world, pos) || block instanceof BlockTile) {
            TileEntity te;
            if (!placeInside && (te = world.func_175625_s(pos)) instanceof TileEntityLittleTiles) {
                TileEntityLittleTiles teTiles = (TileEntityLittleTiles)te;
                for (LittlePreview preview : previews.allPreviews()) {
                    if (teTiles.isSpaceForLittleTile(preview.box)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static TileEntityLittleTiles loadTe(EntityPlayer player, World world, BlockPos pos, MutableInt affected, boolean shouldConvert, int attribute) throws LittleActionException {
        Object tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntityLittleTiles)) {
            LittleGridContext context;
            ArrayList<LittleTile> tiles = new ArrayList<LittleTile>();
            List<LittleTile> chiselTiles = ChiselsAndBitsManager.getTiles(tileEntity);
            LittleGridContext littleGridContext = context = chiselTiles != null ? LittleGridContext.get(ChiselsAndBitsManager.convertingFrom) : LittleGridContext.get();
            if (chiselTiles != null) {
                tiles.addAll(chiselTiles);
            } else if (tileEntity == null && shouldConvert) {
                IBlockState state = world.func_180495_p(pos);
                if (LittleAction.isBlockValid(state) && LittleAction.canConvertBlock(player, world, pos, state, affected == null ? 0 : affected.incrementAndGet())) {
                    context = LittleGridContext.get(LittleGridContext.minSize);
                    LittleBox box = new LittleBox(0, 0, 0, context.maxPos, context.maxPos, context.maxPos);
                    LittleTile tile = new LittleTile(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
                    tile.setBox(box);
                    tiles.add(tile);
                } else if (state.func_185904_a().func_76222_j()) {
                    if (!world.func_175656_a(pos, BlockTile.getStateByAttribute(attribute))) {
                        return null;
                    }
                    tileEntity = world.func_175625_s(pos);
                }
            }
            if (tiles != null && !tiles.isEmpty()) {
                world.func_175656_a(pos, BlockTile.getStateByAttribute(attribute));
                TileEntityLittleTiles te = (TileEntityLittleTiles)world.func_175625_s(pos);
                te.convertTo(context);
                te.updateTilesSecretly(x -> x.noneStructureTiles().addAll((Collection<? extends LittleTile>)tiles));
                te.convertToSmallest();
                tileEntity = te;
            }
        }
        if (tileEntity instanceof TileEntityLittleTiles) {
            return (TileEntityLittleTiles)tileEntity;
        }
        return null;
    }

    public static void fireBlockBreakEvent(World world, BlockPos pos, EntityPlayer player) throws LittleTilesConfig.AreaProtected {
        if (world.field_72995_K) {
            return;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, world.func_180495_p(pos), player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            LittleAction.sendBlockResetToClient(world, player, pos);
            throw new LittleTilesConfig.AreaProtected();
        }
    }

    private static Method loadWorldEditEvent() {
        try {
            Class<?> clazz = Class.forName("com.sk89q.worldedit.forge.ForgeWorldEdit");
            worldEditInstance = clazz.getField("inst").get(null);
            return clazz.getMethod("onPlayerInteract", PlayerInteractEvent.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void sendBlockResetToClient(World world, EntityPlayer player, BlockPos pos) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        if (world instanceof CreativeWorld && ((CreativeWorld)world).parent == null) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            LittleAction.sendBlockResetToClient(world, player, te);
        } else if (world instanceof CreativeWorld) {
            PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleBlockUpdatePacket(world, pos, null), (EntityPlayerMP)((EntityPlayerMP)player));
        } else {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(player.field_70170_p, pos));
        }
    }

    public static void sendBlockResetToClient(World world, EntityPlayer player, TileEntity te) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        if (world instanceof CreativeWorld && ((CreativeWorld)world).parent == null) {
            return;
        }
        if (world instanceof CreativeWorld) {
            PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleBlockUpdatePacket(world, te.func_174877_v(), te), (EntityPlayerMP)((EntityPlayerMP)player));
        } else {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(player.field_70170_p, te.func_174877_v()));
            if (te != null) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)te.func_189518_D_());
            }
        }
    }

    public static void sendBlockResetToClient(World world, EntityPlayer player, Iterable<TileEntityLittleTiles> tileEntities) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        if (world instanceof CreativeWorld && ((CreativeWorld)world).parent == null) {
            return;
        }
        PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleBlocksUpdatePacket(world, tileEntities), (EntityPlayerMP)((EntityPlayerMP)player));
    }

    public static void sendBlockResetToClient(World world, EntityPlayer player, LittleStructure structure) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        try {
            if (world instanceof CreativeWorld && ((CreativeWorld)world).parent == null) {
                return;
            }
            LittleAction.sendBlockResetToClient(world, player, structure.blocks());
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            e.printStackTrace();
        }
    }

    public static boolean isAllowedToInteract(EntityPlayer player, EntityAnimation animation, boolean rightClick) {
        return !player.func_175149_v() && (rightClick || !PlayerUtils.isAdventure((EntityPlayer)player) && player.func_175142_cm());
    }

    public static boolean isAllowedToInteract(World world, EntityPlayer player, BlockPos pos, boolean rightClick, EnumFacing facing) {
        ItemStack stack;
        if (player == null || player.field_70170_p.field_72995_K) {
            return true;
        }
        if (player.func_175149_v()) {
            return false;
        }
        if (!rightClick && PlayerUtils.isAdventure((EntityPlayer)player) ? !(stack = player.func_184614_ca()).func_179544_c(world.func_180495_p(pos).func_177230_c()) : !rightClick && !player.func_175142_cm()) {
            return false;
        }
        if (WorldEditEvent != null) {
            PlayerInteractEvent.RightClickBlock event = rightClick ? new PlayerInteractEvent.RightClickBlock(player, EnumHand.MAIN_HAND, pos, facing, new Vec3d((Vec3i)pos)) : new PlayerInteractEvent.LeftClickBlock(player, pos, facing, new Vec3d((Vec3i)pos));
            try {
                if (worldEditInstance == null) {
                    LittleAction.loadWorldEditEvent();
                }
                WorldEditEvent.invoke(worldEditInstance, event);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
            if (event.isCanceled()) {
                return false;
            }
        }
        return !player.func_184102_h().func_175579_a(player.field_70170_p, pos, player);
    }

    public static boolean isAllowedToPlacePreview(EntityPlayer player, LittlePreview preview) throws LittleActionException {
        if (preview == null) {
            return true;
        }
        if (preview.hasColor() && ColorUtils.getAlpha((int)preview.getColor()) < LittleTiles.CONFIG.getMinimumTransparency(player)) {
            throw new LittleTilesConfig.NotAllowedToPlaceColorException(player);
        }
        return true;
    }

    public static double getVolume(LittleGridContext context, List<PlacePreview> tiles) {
        double volume = 0.0;
        for (PlacePreview preview : tiles) {
            volume += preview.box.getPercentVolume(context);
        }
        return volume;
    }

    public static void writeTileLocation(TileLocation location, ByteBuf buf) {
        LittleAction.writePos((ByteBuf)buf, (BlockPos)location.pos);
        buf.writeBoolean(location.isStructure);
        buf.writeInt(location.index);
        int[] boxArray = location.box.getArray();
        buf.writeInt(boxArray.length);
        for (int i = 0; i < boxArray.length; ++i) {
            buf.writeInt(boxArray[i]);
        }
        if (location.worldUUID != null) {
            buf.writeBoolean(true);
            LittleAction.writeString((ByteBuf)buf, (String)location.worldUUID.toString());
        } else {
            buf.writeBoolean(false);
        }
    }

    public static TileLocation readTileLocation(ByteBuf buf) {
        BlockPos pos = LittleAction.readPos((ByteBuf)buf);
        boolean isStructure = buf.readBoolean();
        int index = buf.readInt();
        int[] boxArray = new int[buf.readInt()];
        for (int i = 0; i < boxArray.length; ++i) {
            boxArray[i] = buf.readInt();
        }
        UUID world = null;
        if (buf.readBoolean()) {
            world = UUID.fromString(LittleAction.readString((ByteBuf)buf));
        }
        return new TileLocation(pos, isStructure, index, LittleBox.createBox(boxArray), world);
    }

    public static void writeStructureLocation(StructureLocation location, ByteBuf buf) {
        LittleAction.writePos((ByteBuf)buf, (BlockPos)location.pos);
        buf.writeInt(location.index);
        if (location.worldUUID != null) {
            buf.writeBoolean(true);
            LittleAction.writeString((ByteBuf)buf, (String)location.worldUUID.toString());
        } else {
            buf.writeBoolean(false);
        }
    }

    public static StructureLocation readStructureLocation(ByteBuf buf) {
        BlockPos pos = LittleAction.readPos((ByteBuf)buf);
        int index = buf.readInt();
        UUID world = null;
        if (buf.readBoolean()) {
            world = UUID.fromString(LittleAction.readString((ByteBuf)buf));
        }
        return new StructureLocation(pos, index, world);
    }

    public static void writePreviews(LittlePreviews previews, ByteBuf buf) {
        buf.writeBoolean(previews.isAbsolute());
        buf.writeBoolean(previews.hasStructure());
        if (previews.hasStructure()) {
            LittleAction.writeNBT((ByteBuf)buf, (NBTTagCompound)previews.structureNBT);
        }
        if (previews.isAbsolute()) {
            LittleAction.writePos((ByteBuf)buf, (BlockPos)((LittleAbsolutePreviews)previews).pos);
        }
        LittleAction.writeContext(previews.getContext(), buf);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("list", (NBTBase)LittleNBTCompressionTools.writePreviews(previews));
        NBTTagList children = new NBTTagList();
        for (LittlePreviews child : previews.getChildren()) {
            children.func_74742_a((NBTBase)LittlePreview.saveChildPreviews(child));
        }
        nbt.func_74782_a("children", (NBTBase)children);
        LittleAction.writeNBT((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    public static LittlePreviews readPreviews(ByteBuf buf) {
        LittlePreviews previews;
        NBTTagCompound nbt;
        boolean absolute = buf.readBoolean();
        boolean structure = buf.readBoolean();
        if (absolute) {
            if (structure) {
                nbt = LittleAction.readNBT((ByteBuf)buf);
                previews = LittleNBTCompressionTools.readPreviews(new LittleAbsolutePreviews(LittleAction.readNBT((ByteBuf)buf), LittleAction.readPos((ByteBuf)buf), LittleAction.readContext(buf)), nbt.func_150295_c("list", 10));
            } else {
                nbt = LittleAction.readNBT((ByteBuf)buf);
                previews = LittleNBTCompressionTools.readPreviews(new LittleAbsolutePreviews(LittleAction.readPos((ByteBuf)buf), LittleAction.readContext(buf)), nbt.func_150295_c("list", 10));
            }
        } else if (structure) {
            nbt = LittleAction.readNBT((ByteBuf)buf);
            previews = LittleNBTCompressionTools.readPreviews(new LittlePreviews(LittleAction.readNBT((ByteBuf)buf), LittleAction.readContext(buf)), nbt.func_150295_c("list", 10));
        } else {
            nbt = LittleAction.readNBT((ByteBuf)buf);
            previews = LittleNBTCompressionTools.readPreviews(new LittlePreviews(LittleAction.readContext(buf)), nbt.func_150295_c("list", 10));
        }
        NBTTagList list = nbt.func_150295_c("children", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound child = list.func_150305_b(i);
            previews.addChild(LittlePreviews.getChild(previews.getContext(), child), child.func_74767_n("dynamic"));
        }
        return previews;
    }

    public static void writePlacementMode(PlacementMode mode, ByteBuf buf) {
        LittleAction.writeString((ByteBuf)buf, (String)mode.name);
    }

    public static PlacementMode readPlacementMode(ByteBuf buf) {
        return PlacementMode.getModeOrDefault(LittleAction.readString((ByteBuf)buf));
    }

    public static void writeContext(LittleGridContext context, ByteBuf buf) {
        buf.writeInt(context.size);
    }

    public static LittleGridContext readContext(ByteBuf buf) {
        return LittleGridContext.get(buf.readInt());
    }

    public static void writeLittleVecContext(LittleVecContext vec, ByteBuf buf) {
        LittleAction.writeLittleVec(vec.getVec(), buf);
        LittleAction.writeContext(vec.getContext(), buf);
    }

    public static LittleVecContext readLittleVecContext(ByteBuf buf) {
        return new LittleVecContext(LittleAction.readLittleVec(buf), LittleAction.readContext(buf));
    }

    public static void writeBoxes(LittleBoxes boxes, ByteBuf buf) {
        LittleAction.writePos((ByteBuf)buf, (BlockPos)boxes.pos);
        LittleAction.writeContext(boxes.context, buf);
        if (boxes instanceof LittleBoxesSimple) {
            buf.writeBoolean(true);
            buf.writeInt(boxes.size());
            for (LittleBox box : boxes.all()) {
                LittleAction.writeLittleBox(box, buf);
            }
        } else {
            buf.writeBoolean(false);
            HashMapList<BlockPos, LittleBox> map = boxes.generateBlockWise();
            buf.writeInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                LittleAction.writePos((ByteBuf)buf, (BlockPos)((BlockPos)entry.getKey()));
                buf.writeInt(((ArrayList)entry.getValue()).size());
                for (LittleBox box : (ArrayList)entry.getValue()) {
                    LittleAction.writeLittleBox(box, buf);
                }
            }
        }
    }

    public static LittleBoxes readBoxes(ByteBuf buf) {
        BlockPos pos = LittleAction.readPos((ByteBuf)buf);
        LittleGridContext context = LittleAction.readContext(buf);
        if (buf.readBoolean()) {
            LittleBoxesSimple boxes = new LittleBoxesSimple(pos, context);
            int length = buf.readInt();
            for (int i = 0; i < length; ++i) {
                ((LittleBoxes)boxes).add(LittleAction.readLittleBox(buf));
            }
            return boxes;
        }
        int posCount = buf.readInt();
        HashMapList map = new HashMapList();
        for (int i = 0; i < posCount; ++i) {
            BlockPos posList = LittleAction.readPos((ByteBuf)buf);
            int boxCount = buf.readInt();
            ArrayList<LittleBox> blockBoxes = new ArrayList<LittleBox>();
            for (int j = 0; j < boxCount; ++j) {
                blockBoxes.add(LittleAction.readLittleBox(buf));
            }
            map.add((Object)posList, blockBoxes);
        }
        return new LittleBoxesNoOverlap(pos, context, (HashMapList<BlockPos, LittleBox>)map);
    }

    public static void writeLittlePos(LittleAbsoluteVec pos, ByteBuf buf) {
        LittleAction.writePos((ByteBuf)buf, (BlockPos)pos.getPos());
        LittleAction.writeLittleVecContext(pos.getVecContext(), buf);
    }

    public static LittleAbsoluteVec readLittlePos(ByteBuf buf) {
        return new LittleAbsoluteVec(LittleAction.readPos((ByteBuf)buf), LittleAction.readLittleVecContext(buf));
    }

    public static void writeLittleVec(LittleVec vec, ByteBuf buf) {
        buf.writeInt(vec.x);
        buf.writeInt(vec.y);
        buf.writeInt(vec.z);
    }

    public static LittleVec readLittleVec(ByteBuf buf) {
        return new LittleVec(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void writeSelector(TileSelector selector, ByteBuf buf) {
        LittleAction.writeNBT((ByteBuf)buf, (NBTTagCompound)selector.writeNBT(new NBTTagCompound()));
    }

    public static TileSelector readSelector(ByteBuf buf) {
        return TileSelector.loadSelector(LittleAction.readNBT((ByteBuf)buf));
    }

    public static void writeLittleBox(LittleBox box, ByteBuf buf) {
        int[] array = box.getArray();
        buf.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            buf.writeInt(array[i]);
        }
    }

    public static LittleBox readLittleBox(ByteBuf buf) {
        int[] array = new int[buf.readInt()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = buf.readInt();
        }
        return LittleBox.createBox(array);
    }

    public static void writeActionMessage(ActionMessage message, ByteBuf buf) {
        LittleAction.writeString((ByteBuf)buf, (String)message.text);
        buf.writeInt(message.objects.length);
        for (int i = 0; i < message.objects.length; ++i) {
            ActionMessage.ActionMessageObjectType type = ActionMessage.getType(message.objects[i]);
            buf.writeInt(type.index());
            type.write(message.objects[i], buf);
        }
    }

    public static ActionMessage readActionMessage(ByteBuf buf) {
        String text = LittleAction.readString((ByteBuf)buf);
        Object[] objects = new Object[buf.readInt()];
        for (int i = 0; i < objects.length; ++i) {
            ActionMessage.ActionMessageObjectType type = ActionMessage.getType(buf.readInt());
            objects[i] = type.read(buf);
        }
        return new ActionMessage(text, objects);
    }

    public static boolean needIngredients(EntityPlayer player) {
        return !player.func_184812_l_();
    }

    public static LittleIngredients getIngredients(IParentTileList parent, LittleTile tile) {
        LittlePreviews previews = new LittlePreviews(parent.getContext());
        previews.addTile(parent, tile);
        return LittleAction.getIngredients(previews);
    }

    public static LittleIngredients getIngredients(IParentTileList parent, List<LittleTile> tiles) {
        LittlePreviews previews = new LittlePreviews(parent.getContext());
        for (LittleTile tile : tiles) {
            previews.addTile(parent, tile);
        }
        return LittleAction.getIngredients(previews);
    }

    public static LittleIngredients getIngredients(LittlePreviews previews) {
        return LittleIngredient.extract(previews);
    }

    public static LittleIngredients getIngredients(LittlePreview preview, double volume) {
        return LittleIngredient.extract(preview, volume);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canTake(EntityPlayer player, LittleInventory inventory, LittleIngredients ingredients) throws NotEnoughIngredientsException {
        if (LittleAction.needIngredients(player)) {
            try {
                inventory.startSimulation();
                inventory.take(ingredients.copy());
                boolean bl = true;
                return bl;
            }
            finally {
                inventory.stopSimulation();
            }
        }
        return true;
    }

    public static boolean checkAndTake(EntityPlayer player, LittleInventory inventory, LittleIngredients ingredients) throws NotEnoughIngredientsException {
        if (LittleAction.needIngredients(player)) {
            try {
                inventory.startSimulation();
                inventory.take(ingredients.copy());
            }
            finally {
                inventory.stopSimulation();
            }
            inventory.take(ingredients.copy());
        }
        return true;
    }

    public static boolean take(EntityPlayer player, LittleInventory inventory, LittleIngredients ingredients) throws NotEnoughIngredientsException {
        if (LittleAction.needIngredients(player)) {
            inventory.take(ingredients.copy());
        }
        return true;
    }

    public static boolean take(EntityPlayer player, LittleInventory inventory, ItemStack toDrain) throws NotEnoughIngredientsException {
        if (!LittleAction.needIngredients(player)) {
            return true;
        }
        String id = ItemPremadeStructure.getPremadeId(toDrain);
        for (ItemStack stack : inventory) {
            if (stack.func_77973_b() != LittleTiles.premade || !ItemPremadeStructure.getPremadeId(stack).equals(id)) continue;
            stack.func_190918_g(1);
            return true;
        }
        throw new NotEnoughIngredientsException(toDrain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canGive(EntityPlayer player, LittleInventory inventory, LittleIngredients ingredients) throws NotEnoughIngredientsException {
        if (LittleAction.needIngredients(player)) {
            try {
                inventory.startSimulation();
                inventory.give(ingredients.copy());
                boolean bl = true;
                return bl;
            }
            finally {
                inventory.stopSimulation();
            }
        }
        return true;
    }

    public static boolean checkAndGive(EntityPlayer player, LittleInventory inventory, LittleIngredients ingredients) throws NotEnoughIngredientsException {
        if (LittleAction.needIngredients(player)) {
            try {
                inventory.startSimulation();
                inventory.give(ingredients.copy());
            }
            finally {
                inventory.stopSimulation();
            }
            inventory.give(ingredients.copy());
        }
        return true;
    }

    public static boolean give(EntityPlayer player, LittleInventory inventory, LittleIngredients ingredients) throws NotEnoughIngredientsException {
        if (LittleAction.needIngredients(player)) {
            inventory.give(ingredients.copy());
        }
        return true;
    }

    public static boolean giveOrDrop(EntityPlayer player, LittleInventory inventory, IParentTileList parent, List<LittleTile> tiles) {
        if (LittleAction.needIngredients(player) && !tiles.isEmpty()) {
            LittlePreviews previews = new LittlePreviews(parent.getContext());
            for (LittleTile tile : tiles) {
                previews.addTile(parent, tile);
            }
            try {
                LittleAction.checkAndGive(player, inventory, LittleAction.getIngredients(previews));
            }
            catch (NotEnoughIngredientsException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static List<ItemStack> getInventories(EntityPlayer player) {
        ArrayList<ItemStack> inventories = new ArrayList<ItemStack>();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ILittleIngredientInventory)) continue;
            inventories.add(stack);
        }
        return inventories;
    }

    public static boolean isBlockValid(IBlockState state) {
        Block block = state.func_177230_c();
        if (ChiselsAndBitsManager.isChiselsAndBitsStructure(state)) {
            return true;
        }
        if (ColoredLightsManager.isBlockFromColoredBlocks(block)) {
            return true;
        }
        if (block.hasTileEntity(state) || block instanceof BlockSlab) {
            return false;
        }
        return state.func_185915_l() || state.func_185917_h() || state.func_185913_b() || block instanceof BlockGlass || block instanceof BlockStainedGlass || block instanceof BlockBreakable;
    }
}

