/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.cache;

import com.creativemd.creativecore.client.rendering.model.BufferBuilderUtils;
import com.creativemd.littletiles.client.render.cache.BlockRenderCache;
import com.creativemd.littletiles.client.render.cache.BufferLink;
import com.creativemd.littletiles.client.render.cache.IRenderDataCache;
import com.creativemd.littletiles.client.render.world.TileEntityRenderManager;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;

public class ChunkBlockLayerCache {
    private final int layer;
    private int totalSize;
    private List<BlockRenderCache> caches = new ArrayList<BlockRenderCache>();
    private int expanded = 0;

    public ChunkBlockLayerCache(int layer) {
        this.layer = layer;
    }

    public int expanded() {
        return this.expanded;
    }

    public void reset() {
        this.caches = new ArrayList<BlockRenderCache>();
        this.totalSize = 0;
        this.expanded = 0;
    }

    public void fillBuilder(BufferBuilder builder) {
        for (BlockRenderCache cache : this.caches) {
            cache.fill(builder);
        }
        this.totalSize = BufferBuilderUtils.getBufferSizeByte((BufferBuilder)builder);
    }

    public void fillBuffer(ByteBuffer buffer) {
        for (BlockRenderCache cache : this.caches) {
            cache.fill(buffer);
        }
        this.totalSize = buffer.position();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TileEntityRenderManager manager, IRenderDataCache data) {
        TileEntityRenderManager tileEntityRenderManager = manager;
        synchronized (tileEntityRenderManager) {
            if (data == null) {
                return;
            }
            ByteBuffer buffer = data.byteBuffer();
            if (buffer == null) {
                return;
            }
            this.expanded += data.length();
            this.caches.add(new BlockRenderCache(manager, this.layer, data, buffer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard() {
        for (BlockRenderCache cache : this.caches) {
            TileEntityRenderManager tileEntityRenderManager = cache.manager;
            synchronized (tileEntityRenderManager) {
                if (cache.manager.getBufferCache() == null) {
                    continue;
                }
                cache.manager.getBufferCache().setEmptyIfEqual(cache.link, this.layer);
            }
        }
        this.reset();
    }

    public int totalSize() {
        return this.totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(ByteBuffer buffer) {
        for (BlockRenderCache cache : this.caches) {
            TileEntityRenderManager tileEntityRenderManager = cache.manager;
            synchronized (tileEntityRenderManager) {
                try {
                    BufferLink link = cache.link;
                    if (buffer.capacity() >= link.index + link.length) {
                        ByteBuffer newBuffer = ByteBuffer.allocateDirect(link.length);
                        buffer.position(link.index);
                        int end = link.index + link.length;
                        while (buffer.position() < end) {
                            newBuffer.put(buffer.get());
                        }
                        link.downloaded(newBuffer);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploaded() {
        for (BlockRenderCache cache : this.caches) {
            TileEntityRenderManager tileEntityRenderManager = cache.manager;
            synchronized (tileEntityRenderManager) {
                if (cache.manager.getBufferCache() == null) {
                    continue;
                }
                cache.link.uploaded();
            }
        }
        this.expanded = 0;
    }

    public boolean isEmpty() {
        return this.caches.isEmpty();
    }
}

