/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui.controls;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.utils.math.SmoothValue;
import com.creativemd.creativecore.common.utils.mc.TickUtils;
import com.creativemd.littletiles.client.gui.controls.IAnimationControl;
import com.creativemd.littletiles.client.world.LittleAnimationHandlerClient;
import com.creativemd.littletiles.common.entity.AnimationPreview;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.lang.reflect.Field;
import javax.vecmath.Vector3d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.util.glu.Project;

public class GuiAnimationViewer
extends GuiControl
implements IAnimationControl {
    public EntityAnimation animation;
    public LittleGridContext context;
    public LittleVec min;
    public SmoothValue rotX = new SmoothValue(200L);
    public SmoothValue rotY = new SmoothValue(200L);
    public SmoothValue rotZ = new SmoothValue(200L);
    public SmoothValue distance = new SmoothValue(200L);
    public boolean grabbed = false;
    public int grabX;
    public int grabY;
    private static final Field lightmapTextureField = ReflectionHelper.findField(EntityRenderer.class, (String[])new String[]{"lightmapTexture", "field_78513_d"});
    private static final Field lightmapColorsField = ReflectionHelper.findField(EntityRenderer.class, (String[])new String[]{"lightmapColors", "field_78504_Q"});
    private static final Field lightmapUpdateNeededField = ReflectionHelper.findField(EntityRenderer.class, (String[])new String[]{"lightmapUpdateNeeded", "field_78536_aa"});

    public GuiAnimationViewer(String name, int x, int y, int width, int height) {
        super(name, x, y, width, height);
        this.marginWidth = 0;
    }

    public boolean hasMouseOverEffect() {
        return false;
    }

    public boolean canOverlap() {
        return false;
    }

    public void mouseMove(int x, int y, int button) {
        super.mouseMove(x, y, button);
        if (this.grabbed) {
            this.rotY.set(this.rotY.aimed() + (double)x - (double)this.grabX);
            this.rotX.set(this.rotX.aimed() + (double)y - (double)this.grabY);
            this.grabX = x;
            this.grabY = y;
        }
    }

    public boolean mousePressed(int x, int y, int button) {
        if (button == 0) {
            this.grabbed = true;
            this.grabX = x;
            this.grabY = y;
            return true;
        }
        return false;
    }

    public void mouseReleased(int x, int y, int button) {
        if (button == 0) {
            this.grabbed = false;
        }
    }

    public boolean mouseScrolled(int x, int y, int scrolled) {
        this.distance.set(Math.max(this.distance.aimed() + (double)(scrolled * -(GuiScreen.func_146271_m() ? 5 : 1)), 0.0));
        return true;
    }

    public static void makeLightBright() {
        try {
            EntityRenderer renderer = Minecraft.func_71410_x().field_71460_t;
            int[] lightmapColors = (int[])lightmapColorsField.get(renderer);
            for (int i = 0; i < 256; ++i) {
                lightmapColors[i] = -1;
            }
            ((DynamicTexture)lightmapTextureField.get(renderer)).func_110564_a();
            lightmapUpdateNeededField.setBoolean(renderer, true);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        if (this.animation == null) {
            return;
        }
        GuiAnimationViewer.makeLightBright();
        this.rotX.tick();
        this.rotY.tick();
        this.rotZ.tick();
        this.distance.tick();
        GlStateManager.func_179097_i();
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179137_b((double)((double)width / 2.0), (double)((double)height / 2.0), (double)0.0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int x = this.getPixelOffsetX();
        int y = this.getPixelOffsetY() - 1;
        int scale = this.getGuiScale();
        GlStateManager.func_179083_b((int)(x * scale), (int)(y * scale), (int)(width * scale), (int)(height * scale));
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        Project.gluPerspective((float)90.0f, (float)((float)width / (float)height), (float)0.05f, (float)256.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-this.distance.current()));
        GlStateManager.func_179091_B();
        GlStateManager.func_179126_j();
        Vector3d rotationCenter = new Vector3d(this.animation.center.rotationCenter);
        rotationCenter.y -= 75.0;
        GlStateManager.func_179114_b((float)((float)this.rotX.current()), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)this.rotY.current()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)this.rotZ.current()), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(-this.min.getPosX(this.context)), (double)(-this.min.getPosY(this.context)), (double)(-this.min.getPosZ(this.context)));
        GlStateManager.func_179137_b((double)(-rotationCenter.x), (double)(-rotationCenter.y), (double)(-rotationCenter.z));
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)TileEntityRendererDispatcher.field_147554_b, (double)TileEntityRendererDispatcher.field_147555_c, (double)TileEntityRendererDispatcher.field_147552_d);
        GlStateManager.func_179109_b((float)0.0f, (float)-75.0f, (float)0.0f);
        LittleAnimationHandlerClient.render.doRender(this.animation, 0.0, 0.0, 0.0, 0.0f, TickUtils.getPartialTickTime());
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179140_f();
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        GlStateManager.func_179097_i();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179083_b((int)0, (int)0, (int)GuiControl.mc.field_71443_c, (int)GuiControl.mc.field_71440_d);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GuiAnimationViewer.mc.field_71460_t.func_78478_c();
        GlStateManager.func_179097_i();
    }

    @Override
    public void onLoaded(AnimationPreview animationPreview) {
        this.animation = animationPreview.animation;
        this.distance.setStart(animationPreview.context.toVanillaGrid(animationPreview.entireBox.getLongestSide()) / 2.0 + 2.0);
        this.context = animationPreview.context;
        this.min = animationPreview.entireBox.getMinVec();
    }
}

