/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui;

import com.creativemd.creativecore.client.avatar.AvatarItemStack;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.client.style.ColoredDisplayStyle;
import com.creativemd.creativecore.common.gui.client.style.DisplayStyle;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.container.SlotControl;
import com.creativemd.creativecore.common.gui.controls.container.SlotControlNoSync;
import com.creativemd.creativecore.common.gui.controls.container.client.GuiSlotControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiAvatarLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiProgressBar;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.container.SlotChangeEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.littletiles.common.recipe.BlankOMaticRecipeRegistry;
import com.creativemd.littletiles.common.structure.type.premade.LittleBlankOMatic;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;

public class SubGuiBlankOMatic
extends SubGui {
    private static final DisplayStyle SELECTED_DISPLAY = new ColoredDisplayStyle(-256);
    public LittleBlankOMatic whitener;

    public SubGuiBlankOMatic(LittleBlankOMatic whitener) {
        this.whitener = whitener;
    }

    public void createControls() {
        this.controls.add(new GuiVariantSelector("variant", 30, 8, 100, 100));
        this.controls.add(new GuiLabel("cost", 132, 30));
        GuiAvatarLabel label = new GuiAvatarLabel("", 148, 40, 0, null){

            public boolean mousePressed(int x, int y, int button) {
                return false;
            }
        };
        label.name = "avatar";
        label.height = 60;
        label.avatarSize = 32;
        this.controls.add(label);
        this.controls.add(new GuiButton("craft", 135, 10){

            public void onClicked(int x, int y, int button) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("craft", true);
                nbt.func_74768_a("amount", GuiScreen.func_146272_n() ? 2 : (GuiScreen.func_146271_m() ? 1 : 0));
                GuiVariantSelector selector = (GuiVariantSelector)SubGuiBlankOMatic.this.get("variant");
                nbt.func_74768_a("variant", selector.selected);
                SubGuiBlankOMatic.this.sendPacketToServer(nbt);
            }
        });
        this.controls.add(new GuiProgressBar("volume", 8, 60, 80, 6, (double)BlankOMaticRecipeRegistry.bleachTotalVolume, (double)this.whitener.whiteColor));
        this.updateVariants();
    }

    public void receiveContainerPacket(NBTTagCompound nbt) {
        GuiProgressBar volume = (GuiProgressBar)this.get("volume");
        volume.pos = nbt.func_74762_e("volume");
    }

    @CustomEventSubscribe
    public void changed(GuiControlChangedEvent event) {
        if (event.source.is(new String[]{"variant"})) {
            this.updateLabel();
        }
    }

    public void updateLabel() {
        GuiVariantSelector selector = (GuiVariantSelector)this.get("variant");
        IBlockState state = selector.getSeleted();
        ItemStack stack = state != null ? new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)) : ItemStack.field_190927_a;
        GuiAvatarLabel label = (GuiAvatarLabel)this.get("avatar");
        label.avatar = new AvatarItemStack(stack);
        GuiLabel cost = (GuiLabel)this.get("cost");
        BlankOMaticRecipeRegistry.BleachRecipe recipe = selector.getSelectedRecipe();
        cost.setCaption(recipe != null ? "cost: " + recipe.needed : "");
    }

    @CustomEventSubscribe
    public void slotChanged(SlotChangeEvent event) {
        this.updateVariants();
    }

    public void updateVariants() {
        GuiVariantSelector selector = (GuiVariantSelector)this.get("variant");
        selector.setRecipes(BlankOMaticRecipeRegistry.getRecipe(this.whitener.inventory.func_70301_a(0)));
        this.updateLabel();
    }

    public static class GuiSlotControlSelect
    extends GuiSlotControl {
        public final GuiVariantSelector selector;
        public final int index;
        public boolean selected = false;

        public GuiSlotControlSelect(GuiVariantSelector selector, int col, int row, int index, InventoryBasic basic) {
            super(col * 18, row * 18, (SlotControl)new SlotControlNoSync(new Slot((IInventory)basic, index, col * 18, row * 18)));
            this.selector = selector;
            this.index = index;
        }

        public DisplayStyle getBorderDisplay(DisplayStyle display) {
            if (this.selected) {
                return SELECTED_DISPLAY;
            }
            return super.getBorderDisplay(display);
        }

        public boolean mousePressed(int posX, int posY, int button) {
            this.selector.select(this.index);
            GuiSlotControlSelect.playSound((SoundEvent)SoundEvents.field_187909_gi);
            return super.mousePressed(posX, posY, button);
        }
    }

    public static class GuiVariantSelector
    extends GuiParent {
        public List<Pair<BlankOMaticRecipeRegistry.BleachRecipe, IBlockState>> states;
        private int selected = 0;

        public GuiVariantSelector(String name, int x, int y, int width, int height) {
            super(name, x, y, width, height);
        }

        public boolean hasBackground() {
            return false;
        }

        public boolean hasBorder() {
            return false;
        }

        public BlankOMaticRecipeRegistry.BleachRecipe getSelectedRecipe() {
            if (this.selected >= 0 && this.selected < this.states.size()) {
                return (BlankOMaticRecipeRegistry.BleachRecipe)this.states.get((int)this.selected).key;
            }
            return null;
        }

        public IBlockState getSeleted() {
            if (this.selected >= 0 && this.selected < this.states.size()) {
                return (IBlockState)this.states.get((int)this.selected).value;
            }
            return null;
        }

        public void select(int index) {
            this.selected = index;
            for (int i = 0; i < this.controls.size(); ++i) {
                GuiSlotControlSelect slot = (GuiSlotControlSelect)((Object)this.controls.get(i));
                slot.selected = index == i;
            }
            this.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
        }

        public void setRecipes(List<BlankOMaticRecipeRegistry.BleachRecipe> recipes) {
            ArrayList<Pair<BlankOMaticRecipeRegistry.BleachRecipe, IBlockState>> states = new ArrayList<Pair<BlankOMaticRecipeRegistry.BleachRecipe, IBlockState>>();
            for (int i = 0; i < recipes.size(); ++i) {
                BlankOMaticRecipeRegistry.BleachRecipe recipe = recipes.get(i);
                for (int j = 0; j < recipe.results.length; ++j) {
                    states.add((Pair<BlankOMaticRecipeRegistry.BleachRecipe, IBlockState>)new Pair((Object)recipe, (Object)recipe.results[j]));
                }
            }
            this.controls.clear();
            this.states = states;
            InventoryBasic basic = new InventoryBasic("", false, states.size());
            for (int i = 0; i < states.size(); ++i) {
                IBlockState state = (IBlockState)((Pair)states.get((int)i)).value;
                int index = i;
                int col = i % 4;
                int row = i / 4;
                basic.func_70299_a(i, new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)));
                this.addControl(new GuiSlotControlSelect(this, col, row, index, basic).setCustomTooltip(new String[]{"cost: " + ((BlankOMaticRecipeRegistry.BleachRecipe)((Pair)states.get((int)i)).key).needed}));
            }
            if (this.selected >= states.size()) {
                this.select(0);
            } else {
                this.select(this.selected);
            }
        }
    }
}

