/*
 * Decompiled with CFR 0.152.
 */
package kpan.nutrition_gtceu.asm.core.adapters;

import kpan.nutrition_gtceu.asm.core.AsmTypes;
import kpan.nutrition_gtceu.asm.core.AsmUtil;
import kpan.nutrition_gtceu.asm.core.MyAsmNameRemapper;
import kpan.nutrition_gtceu.asm.core.adapters.ReplaceMethodAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class ReplaceRefMethodAdapter
extends ReplaceMethodAdapter {
    private final String runtimeClassForRefMethodParam;
    private final String originalName;
    private final String refClass;
    private final String runtimeReturnType;
    private final String[] runtimeParams;

    public ReplaceRefMethodAdapter(ClassVisitor cv, String refClass, MyAsmNameRemapper.MethodRemap method) {
        super(cv, method);
        this.originalName = method.mcpMethodName;
        this.runtimeClassForRefMethodParam = MyAsmNameRemapper.runtimeClass(method.deobfOwner);
        this.refClass = refClass;
        AsmTypes.MethodDesc md = AsmTypes.MethodDesc.fromMethodDesc(AsmUtil.runtimeDesc(method.deobfMethodDesc));
        this.runtimeReturnType = md.returnDesc;
        this.runtimeParams = md.paramsDesc;
    }

    public ReplaceRefMethodAdapter(ClassVisitor cv, String refClass, String runtimeClassForRefMethodParam, String runtimeMethodName, String runtimeDesc) {
        super(cv, runtimeMethodName, runtimeDesc);
        this.originalName = runtimeMethodName;
        this.runtimeClassForRefMethodParam = runtimeClassForRefMethodParam;
        this.refClass = refClass;
        AsmTypes.MethodDesc md = AsmTypes.MethodDesc.fromMethodDesc(runtimeDesc);
        this.runtimeReturnType = md.returnDesc;
        this.runtimeParams = md.paramsDesc;
    }

    @Override
    protected void methodBody(MethodVisitor mv) {
        boolean is_static = (this.access & 8) != 0;
        int offset = 0;
        if (!is_static) {
            mv.visitVarInsn(25, 0);
            offset = 1;
        }
        AsmUtil.loadLocals(mv, this.runtimeParams, offset);
        if (is_static) {
            mv.visitMethodInsn(184, this.refClass, this.originalName, this.runtimeDesc, false);
        } else {
            mv.visitMethodInsn(184, this.refClass, this.originalName, AsmUtil.toMethodDesc(this.runtimeReturnType, this.runtimeClassForRefMethodParam, this.runtimeParams), false);
        }
        mv.visitInsn(AsmUtil.toReturnOpcode(this.runtimeReturnType));
    }
}

