/*
 * Decompiled with CFR 0.152.
 */
package kpan.nutrition_gtceu.asm.core.adapters;

import com.google.common.collect.HashBiMap;
import javax.annotation.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;

public class MyMethodVisitor
extends MethodVisitor {
    private final String nameForDebug;
    private int success = 0;
    private int successExpectedMinInclusive;
    private int successExpectedMaxInclusive;
    protected final HashBiMap<Label, Integer> labels = HashBiMap.create();

    public MyMethodVisitor(MethodVisitor mv, String nameForDebug) {
        this(mv, nameForDebug, 1);
    }

    public MyMethodVisitor(MethodVisitor mv, String nameForDebug, int successExpected) {
        this(mv, nameForDebug, successExpected, successExpected);
    }

    public MyMethodVisitor(MethodVisitor mv, String nameForDebug, int successExpectedMinInclusive, int successExpectedMaxInclusive) {
        super(327680, mv);
        this.nameForDebug = nameForDebug;
        this.successExpectedMinInclusive = Math.max(successExpectedMinInclusive, 0);
        this.successExpectedMaxInclusive = Math.max(successExpectedMaxInclusive, 0);
    }

    public MyMethodVisitor setSuccessExpected(int successExpected) {
        this.setSuccessExpectedMin(successExpected);
        this.setSuccessExpectedMax(successExpected);
        return this;
    }

    public MyMethodVisitor setSuccessExpectedMin(int minInclusive) {
        this.successExpectedMinInclusive = Math.max(minInclusive, 0);
        return this;
    }

    public MyMethodVisitor setSuccessExpectedMax(int maxInclusive) {
        this.successExpectedMaxInclusive = Math.max(maxInclusive, 0);
        return this;
    }

    protected void success() {
        ++this.success;
    }

    public int getSuccess() {
        return this.success;
    }

    @Nullable
    public Label tryGetLabel(int index) {
        return (Label)this.labels.inverse().get((Object)index);
    }

    public Label getLabel(int index) {
        Label label = this.tryGetLabel(index);
        if (label == null) {
            throw new RuntimeException("Label\uff1aL" + index + " is not found.");
        }
        return label;
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.updateLabels(label);
        super.visitJumpInsn(opcode, label);
    }

    public void visitLabel(Label label) {
        this.updateLabels(label);
        super.visitLabel(label);
    }

    public void visitLineNumber(int line, Label start) {
        this.updateLabels(start);
        super.visitLineNumber(line, start);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.updateLabels(start);
        this.updateLabels(end);
        super.visitLocalVariable(name, desc, signature, start, end, index);
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
        for (int i = 0; i < start.length; ++i) {
            this.updateLabels(start[i]);
            this.updateLabels(end[i]);
        }
        return super.visitLocalVariableAnnotation(typeRef, typePath, start, end, index, desc, visible);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        for (Label label : labels) {
            this.updateLabels(label);
        }
        this.updateLabels(dflt);
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        for (Label label : labels) {
            this.updateLabels(label);
        }
        this.updateLabels(dflt);
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.updateLabels(start);
        this.updateLabels(end);
        this.updateLabels(handler);
        super.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.success < this.successExpectedMinInclusive || this.success > this.successExpectedMaxInclusive) {
            if (this.successExpectedMinInclusive == this.successExpectedMaxInclusive) {
                throw new RuntimeException("method transform failed:" + this.nameForDebug + "\nexpected:" + this.successExpectedMinInclusive + "\nactual:" + this.success);
            }
            if (this.successExpectedMaxInclusive == Integer.MAX_VALUE) {
                throw new RuntimeException("method transform failed:" + this.nameForDebug + "\nexpected: " + this.successExpectedMinInclusive + "~\nactual:" + this.success);
            }
            throw new RuntimeException("method transform failed:" + this.nameForDebug + "\nexpected: " + this.successExpectedMinInclusive + "~" + this.successExpectedMaxInclusive + "\nactual:" + this.success);
        }
    }

    protected void updateLabels(Label label) {
        if (!this.labels.containsKey((Object)label)) {
            this.labels.put((Object)label, (Object)this.labels.size());
        }
    }
}

