/*
 * Decompiled with CFR 0.152.
 */
package kpan.nutrition_gtceu.asm.core.adapters;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javax.annotation.Nullable;
import kpan.nutrition_gtceu.asm.core.AsmUtil;
import kpan.nutrition_gtceu.asm.core.MyAsmNameRemapper;
import kpan.nutrition_gtceu.asm.core.adapters.MyMethodVisitor;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class Instructions
implements List<Instr> {
    private final List<Instr> instructions;

    public Instructions() {
        this(Lists.newArrayList());
    }

    public Instructions(List<Instr> instructions) {
        this.instructions = instructions;
    }

    public Instructions addInstr(Instr instr) {
        this.add(instr);
        return this;
    }

    public Instructions fieldInsn(OpcodeField opcode, String runtimeOwner, String runtimeName, String runtimeDesc) {
        return this.addInstr(Instr.fieldInsn(opcode, runtimeOwner, runtimeName, runtimeDesc));
    }

    public Instructions fieldInsn(OpcodeField opcode, MyAsmNameRemapper.FieldRemap field) {
        return this.addInstr(Instr.fieldInsn(opcode, field));
    }

    public Instructions getField(MyAsmNameRemapper.FieldRemap field) {
        return this.fieldInsn(OpcodeField.GET, field);
    }

    public Instructions getField(String runtimeOwner, String runtimeName, String runtimeDesc) {
        return this.fieldInsn(OpcodeField.GET, runtimeOwner, runtimeName, runtimeDesc);
    }

    public Instructions putField(MyAsmNameRemapper.FieldRemap field) {
        return this.fieldInsn(OpcodeField.PUT, field);
    }

    public Instructions putField(String runtimeOwner, String runtimeName, String runtimeDesc) {
        return this.fieldInsn(OpcodeField.PUT, runtimeOwner, runtimeName, runtimeDesc);
    }

    public Instructions getStatic(MyAsmNameRemapper.FieldRemap field) {
        return this.fieldInsn(OpcodeField.GETSTATIC, field);
    }

    public Instructions getStatic(String runtimeOwner, String runtimeName, String runtimeDesc) {
        return this.fieldInsn(OpcodeField.GETSTATIC, runtimeOwner, runtimeName, runtimeDesc);
    }

    public Instructions putStatic(MyAsmNameRemapper.FieldRemap field) {
        return this.fieldInsn(OpcodeField.PUTSTATIC, field);
    }

    public Instructions putStatic(String runtimeOwner, String runtimeName, String runtimeDesc) {
        return this.fieldInsn(OpcodeField.PUTSTATIC, runtimeOwner, runtimeName, runtimeDesc);
    }

    public Instructions iincInsn(int var, int increment) {
        return this.addInstr(Instr.iincInsn(var, increment));
    }

    public Instructions intInsn(OpcodeInt opcode, int operand) {
        return this.addInstr(Instr.intInsn(opcode, operand));
    }

    public Instructions newArray(NewArrayType arrayType) {
        return this.intInsn(OpcodeInt.NEWARRAY, arrayType.atype);
    }

    public Instructions insn(int opcode) {
        return this.addInstr(Instr.insn(opcode));
    }

    public Instructions jumpInsn(OpcodeJump opcode, Label label) {
        return this.addInstr(Instr.jumpInsn(opcode, label));
    }

    public Instructions jumpInsn(OpcodeJump opcode, int labelIndex) {
        return this.addInstr(Instr.jumpInsn(opcode, labelIndex));
    }

    public Instructions jumpRep() {
        return this.addInstr(Instr.jumpRep());
    }

    public Instructions label(Label label) {
        return this.addInstr(Instr.label(label));
    }

    public Instructions label(int labelIndex) {
        return this.addInstr(Instr.label(labelIndex));
    }

    public Instructions labelRep() {
        return this.addInstr(Instr.labelRep());
    }

    public Instructions ldcInsn(Object cst) {
        return this.addInstr(Instr.ldcInsn(cst));
    }

    public Instructions ldcRep() {
        return this.addInstr(Instr.ldcRep());
    }

    public Instructions typeInsn(int opcode, String type) {
        return this.addInstr(Instr.typeInsn(opcode, type));
    }

    public Instructions methodInsn(OpcodeMethod opcode, MyAsmNameRemapper.MethodRemap method) {
        return this.addInstr(Instr.methodInsn(opcode, method));
    }

    public Instructions methodInsn(OpcodeMethod opcode, String runtimeOwner, String runtimeName, String runtimeMethodDesc) {
        return this.addInstr(Instr.methodInsn(opcode, runtimeOwner, runtimeName, runtimeMethodDesc));
    }

    public Instructions invokeVirtual(MyAsmNameRemapper.MethodRemap method) {
        return this.methodInsn(OpcodeMethod.VIRTUAL, method);
    }

    public Instructions invokeVirtual(String runtimeOwner, String runtimeName, String runtimeMethodDesc) {
        return this.methodInsn(OpcodeMethod.VIRTUAL, runtimeOwner, runtimeName, runtimeMethodDesc);
    }

    public Instructions invokeStatic(MyAsmNameRemapper.MethodRemap method) {
        return this.methodInsn(OpcodeMethod.STATIC, method);
    }

    public Instructions invokeStatic(String runtimeOwner, String runtimeName, String runtimeMethodDesc) {
        return this.methodInsn(OpcodeMethod.STATIC, runtimeOwner, runtimeName, runtimeMethodDesc);
    }

    public Instructions invokeInterface(MyAsmNameRemapper.MethodRemap method) {
        return this.methodInsn(OpcodeMethod.INTERFACE, method);
    }

    public Instructions invokeInterface(String runtimeOwner, String runtimeName, String runtimeMethodDesc) {
        return this.methodInsn(OpcodeMethod.INTERFACE, runtimeOwner, runtimeName, runtimeMethodDesc);
    }

    public Instructions invokespecial(MyAsmNameRemapper.MethodRemap method) {
        return this.methodInsn(OpcodeMethod.SPECIAL, method);
    }

    public Instructions invokespecial(String runtimeOwner, String runtimeName, String runtimeMethodDesc) {
        return this.methodInsn(OpcodeMethod.SPECIAL, runtimeOwner, runtimeName, runtimeMethodDesc);
    }

    public Instructions methodRep(OpcodeMethod opcode, String runtimeOwner, String runtimeName) {
        return this.addInstr(new Instr.InvokeRep(opcode, runtimeOwner, runtimeName));
    }

    public Instructions varInsn(OpcodeVar opcode, int varIndex) {
        return this.addInstr(Instr.varInsn(opcode, varIndex));
    }

    public Instructions iload(int varIndex) {
        return this.varInsn(OpcodeVar.ILOAD, varIndex);
    }

    public Instructions lload(int varIndex) {
        return this.varInsn(OpcodeVar.LLOAD, varIndex);
    }

    public Instructions fload(int varIndex) {
        return this.varInsn(OpcodeVar.FLOAD, varIndex);
    }

    public Instructions dload(int varIndex) {
        return this.varInsn(OpcodeVar.DLOAD, varIndex);
    }

    public Instructions aload(int varIndex) {
        return this.varInsn(OpcodeVar.ALOAD, varIndex);
    }

    public Instructions istore(int varIndex) {
        return this.varInsn(OpcodeVar.ISTORE, varIndex);
    }

    public Instructions lstore(int varIndex) {
        return this.varInsn(OpcodeVar.LSTORE, varIndex);
    }

    public Instructions fstore(int varIndex) {
        return this.varInsn(OpcodeVar.FSTORE, varIndex);
    }

    public Instructions dstore(int varIndex) {
        return this.varInsn(OpcodeVar.DSTORE, varIndex);
    }

    public Instructions astore(int varIndex) {
        return this.varInsn(OpcodeVar.ASTORE, varIndex);
    }

    public Instructions rep() {
        return this.addInstr(Instr.REP);
    }

    public static Instructions create(Instr ... instructions) {
        return new Instructions(Lists.newArrayList((Object[])instructions));
    }

    @Override
    public int size() {
        return this.instructions.size();
    }

    @Override
    public boolean isEmpty() {
        return this.instructions.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.instructions.contains(o);
    }

    @Override
    public Iterator<Instr> iterator() {
        return this.instructions.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.instructions.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.instructions.toArray(a);
    }

    @Override
    public boolean add(Instr e) {
        return this.instructions.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.instructions.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.instructions.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Instr> c) {
        return this.instructions.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Instr> c) {
        return this.instructions.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.instructions.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.instructions.retainAll(c);
    }

    @Override
    public void clear() {
        this.instructions.clear();
    }

    @Override
    public Instr get(int index) {
        return this.instructions.get(index);
    }

    @Override
    public Instr set(int index, Instr element) {
        return this.instructions.set(index, element);
    }

    @Override
    public void add(int index, Instr element) {
        this.instructions.add(index, element);
    }

    @Override
    public Instr remove(int index) {
        return this.instructions.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.instructions.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.instructions.lastIndexOf(o);
    }

    @Override
    public ListIterator<Instr> listIterator() {
        return this.instructions.listIterator();
    }

    @Override
    public ListIterator<Instr> listIterator(int index) {
        return this.instructions.listIterator(index);
    }

    @Override
    public List<Instr> subList(int fromIndex, int toIndex) {
        return this.instructions.subList(fromIndex, toIndex);
    }

    public static class Instr {
        public static final Instr REP = new Instr(0, null, new Object[0]){

            @Override
            public void visit(MethodVisitor mv, MyMethodVisitor adapter) {
            }

            @Override
            protected boolean isRep() {
                return true;
            }

            @Override
            protected boolean repEquals(Instr other) {
                return true;
            }
        };
        private static final Instr LDC_REP = new Instr(0, VisitType.LDC, new Object[0]){

            @Override
            public void visit(MethodVisitor mv, MyMethodVisitor adapter) {
            }

            @Override
            protected boolean isRep() {
                return true;
            }

            @Override
            protected boolean repEquals(Instr other) {
                return other.type == VisitType.LDC;
            }
        };
        private static final Instr LABEL_REP = new Instr(0, VisitType.LABEL, new Object[0]){

            @Override
            public void visit(MethodVisitor mv, MyMethodVisitor adapter) {
            }

            @Override
            protected boolean isRep() {
                return true;
            }

            @Override
            protected boolean repEquals(Instr other) {
                return other.type == VisitType.LABEL;
            }
        };
        private static final Instr JUMP_REP = new Instr(0, VisitType.JUMP, new Object[0]){

            @Override
            public void visit(MethodVisitor mv, MyMethodVisitor adapter) {
            }

            @Override
            protected boolean isRep() {
                return true;
            }

            @Override
            protected boolean repEquals(Instr other) {
                return other.type == VisitType.JUMP;
            }
        };
        private final int opcode;
        private final Object[] params;
        private final VisitType type;

        public static Instr dynamicInsn(String runtimeName, String runtimeDesc, Handle bsm, Object ... bsmArgs) {
            return new Instr(186, VisitType.DYNAMIC, runtimeName, runtimeDesc.replace('.', '/'), bsm, bsmArgs);
        }

        public static Instr fieldInsn(OpcodeField opcode, MyAsmNameRemapper.FieldRemap field) {
            return Instr.fieldInsn(opcode.opcode, field);
        }

        public static Instr fieldInsn(OpcodeField opcode, String runtimeOwner, String runtimeName, String runtimeDesc) {
            return Instr.fieldInsn(opcode.opcode, runtimeOwner, runtimeName, runtimeDesc);
        }

        public static Instr fieldInsn(int opcode, MyAsmNameRemapper.FieldRemap field) {
            return new Instr(opcode, VisitType.FIELD, field.toRuntime());
        }

        public static Instr fieldInsn(int opcode, String runtimeOwner, String runtimeName, String runtimeDesc) {
            return new Instr(opcode, VisitType.FIELD, runtimeOwner.replace('.', '/'), runtimeName, AsmUtil.toDesc(runtimeDesc));
        }

        public static Instr iincInsn(int var, int increment) {
            return new Instr(132, VisitType.IINC, var, increment);
        }

        public static Instr intInsn(OpcodeInt opcode, int operand) {
            return Instr.intInsn(opcode.opcode, operand);
        }

        public static Instr intInsn(int opcode, int operand) {
            return new Instr(opcode, VisitType.INT, operand);
        }

        public static Instr insn(int opcode) {
            return new Instr(opcode, VisitType.INSN, new Object[0]);
        }

        public static Instr jumpInsn(OpcodeJump opcode, Label label) {
            return Instr.jumpInsn(opcode.opcode, label);
        }

        public static Instr jumpInsn(OpcodeJump opcode, int labelIndex) {
            return Instr.jumpInsn(opcode.opcode, labelIndex);
        }

        public static Instr jumpInsn(int opcode, Label label) {
            return new Instr(opcode, VisitType.JUMP, label);
        }

        public static Instr jumpInsn(int opcode, int labelIndex) {
            return new Instr(opcode, VisitType.JUMP, labelIndex);
        }

        public static Instr jumpRep() {
            return JUMP_REP;
        }

        public static Instr label(Label label) {
            return new Instr(0, VisitType.LABEL, label);
        }

        public static Instr label(int labelIndex) {
            return new Instr(0, VisitType.LABEL, labelIndex);
        }

        public static Instr labelRep() {
            return LABEL_REP;
        }

        public static Instr ldcInsn(Object cst) {
            return new Instr(0, VisitType.LDC, cst);
        }

        public static Instr ldcRep() {
            return LDC_REP;
        }

        public static Instr typeInsn(int opcode, String type) {
            return new Instr(opcode, VisitType.TYPE, MyAsmNameRemapper.runtimeClass(type));
        }

        public static Instr methodInsn(OpcodeMethod opcode, MyAsmNameRemapper.MethodRemap method) {
            if (opcode == OpcodeMethod.INTERFACE) {
                return Instr.methodInsn(opcode.opcode, method, true);
            }
            return Instr.methodInsn(opcode.opcode, method);
        }

        public static Instr methodInsn(OpcodeMethod opcode, String runtimeOwner, String runtimeName, String runtimeMethodDesc) {
            if (opcode == OpcodeMethod.INTERFACE) {
                return Instr.methodInsn(opcode.opcode, runtimeOwner, runtimeName, runtimeMethodDesc, true);
            }
            return Instr.methodInsn(opcode.opcode, runtimeOwner, runtimeName, runtimeMethodDesc);
        }

        public static Instr methodInsn(int opcode, MyAsmNameRemapper.MethodRemap method) {
            return Instr.methodInsn(opcode, method, false);
        }

        public static Instr methodInsn(int opcode, String runtimeOwner, String runtimeName, String runtimeMethodDesc) {
            return Instr.methodInsn(opcode, runtimeOwner, runtimeName, runtimeMethodDesc, false);
        }

        public static Instr methodInsn(int opcode, MyAsmNameRemapper.MethodRemap method, boolean interfaceCall) {
            Object[] array = new Object[4];
            System.arraycopy(method.toRuntime(), 0, array, 0, 3);
            array[3] = interfaceCall;
            return new Instr(opcode, VisitType.METHOD, array);
        }

        public static Instr methodInsn(int opcode, String runtimeOwner, String runtimeName, String runtimeMethodDesc, boolean interfaceCall) {
            return new Instr(opcode, VisitType.METHOD, runtimeOwner.replace('.', '/'), runtimeName, runtimeMethodDesc.replace('.', '/'), interfaceCall);
        }

        public static Instr varInsn(OpcodeVar opcode, int varIndex) {
            return Instr.varInsn(opcode.opcode, varIndex);
        }

        public static Instr varInsn(int opcode, int varIndex) {
            return new Instr(opcode, VisitType.VAR, varIndex);
        }

        Instr(int opcode, VisitType type, Object ... params) {
            this.opcode = opcode;
            this.type = type;
            this.params = params;
        }

        public void visit(@Nullable MethodVisitor mv, @Nullable MyMethodVisitor adapter) {
            if (mv == null) {
                return;
            }
            switch (this.type) {
                case DYNAMIC: {
                    mv.visitInvokeDynamicInsn((String)this.params[0], (String)this.params[1], (Handle)this.params[2], (Object[])this.params[3]);
                    break;
                }
                case FIELD: {
                    mv.visitFieldInsn(this.opcode, (String)this.params[0], (String)this.params[1], (String)this.params[2]);
                    break;
                }
                case IINC: {
                    mv.visitIincInsn(((Integer)this.params[0]).intValue(), ((Integer)this.params[1]).intValue());
                    break;
                }
                case INT: {
                    mv.visitIntInsn(this.opcode, ((Integer)this.params[0]).intValue());
                    break;
                }
                case INSN: {
                    mv.visitInsn(this.opcode);
                    break;
                }
                case JUMP: {
                    if (this.params[0] instanceof Label) {
                        mv.visitJumpInsn(this.opcode, (Label)this.params[0]);
                        break;
                    }
                    if (adapter == null) {
                        throw new IllegalArgumentException("the adapter must not be null to solve the label");
                    }
                    mv.visitJumpInsn(this.opcode, adapter.getLabel((Integer)this.params[0]));
                    break;
                }
                case LABEL: {
                    if (this.params[0] instanceof Label) {
                        mv.visitLabel((Label)this.params[0]);
                        break;
                    }
                    if (adapter == null) {
                        throw new IllegalArgumentException("the adapter must not be null to solve the label");
                    }
                    mv.visitLabel(adapter.getLabel((Integer)this.params[0]));
                    break;
                }
                case LDC: {
                    mv.visitLdcInsn(this.params[0]);
                    break;
                }
                case METHOD: {
                    mv.visitMethodInsn(this.opcode, (String)this.params[0], (String)this.params[1], (String)this.params[2], ((Boolean)this.params[3]).booleanValue());
                    break;
                }
                case TYPE: {
                    mv.visitTypeInsn(this.opcode, (String)this.params[0]);
                    break;
                }
                case VAR: {
                    mv.visitVarInsn(this.opcode, ((Integer)this.params[0]).intValue());
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid Type:" + (Object)((Object)this.type));
                }
            }
        }

        public void solveLabel(MyMethodVisitor adapter) {
            Label label;
            if (this.isRep()) {
                return;
            }
            if (this.type == VisitType.JUMP && this.params[0] instanceof Integer && (label = adapter.tryGetLabel((Integer)this.params[0])) != null) {
                this.params[0] = label;
            }
            if (this.type == VisitType.LABEL && this.params[0] instanceof Integer && (label = adapter.tryGetLabel((Integer)this.params[0])) != null) {
                this.params[0] = label;
            }
        }

        protected boolean isRep() {
            return false;
        }

        protected boolean repEquals(Instr other) {
            return false;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Instr) {
                Instr other = (Instr)obj;
                return Instr.equals(this, other);
            }
            return false;
        }

        private static boolean equals(Instr a, Instr b) {
            if (a == REP || b == REP) {
                return true;
            }
            if (a.isRep()) {
                return a.repEquals(b);
            }
            if (b.isRep()) {
                return b.repEquals(a);
            }
            if (a.type != b.type) {
                return false;
            }
            if (a.opcode != b.opcode) {
                return false;
            }
            return Arrays.equals(a.params, b.params);
        }

        public String toString() {
            return (Object)((Object)this.type) + "(" + StringUtils.join((Object[])this.params, (String)",") + ")";
        }

        private static enum VisitType {
            DYNAMIC,
            FIELD,
            IINC,
            INT,
            INSN,
            JUMP,
            LABEL,
            LDC,
            METHOD,
            TYPE,
            VAR;

        }

        public static class InvokeRep
        extends Instr {
            private final OpcodeMethod opcode;
            private final String runtimeOwner;
            private final String runtimeMethodName;

            public InvokeRep(OpcodeMethod opcode, String runtimeOwner, String runtimeMethodName) {
                super(opcode.opcode, VisitType.METHOD, new Object[0]);
                this.opcode = opcode;
                this.runtimeOwner = runtimeOwner.replace('.', '/');
                this.runtimeMethodName = runtimeMethodName;
            }

            @Override
            public void visit(MethodVisitor mv, MyMethodVisitor adapter) {
            }

            @Override
            protected boolean isRep() {
                return true;
            }

            @Override
            protected boolean repEquals(Instr other) {
                if (other.type != VisitType.METHOD) {
                    return false;
                }
                if (this.opcode.opcode != other.opcode) {
                    return false;
                }
                if (!this.runtimeOwner.equals(other.params[0])) {
                    return false;
                }
                return this.runtimeMethodName.equals(other.params[1]);
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                InvokeRep other = (InvokeRep)o;
                return this.opcode == other.opcode && this.runtimeOwner.equals(other.runtimeOwner) && this.runtimeMethodName.equals(other.runtimeMethodName);
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.opcode, this.runtimeOwner, this.runtimeMethodName});
            }
        }
    }

    public static enum OpcodeField {
        GET(180),
        PUT(181),
        GETSTATIC(178),
        PUTSTATIC(179);

        public final int opcode;

        private OpcodeField(int opcode) {
            this.opcode = opcode;
        }
    }

    public static enum OpcodeInt {
        BIPUSH(16),
        SIPUSH(17),
        NEWARRAY(188);

        public final int opcode;

        private OpcodeInt(int opcode) {
            this.opcode = opcode;
        }
    }

    public static enum NewArrayType {
        T_BOOLEAN(4),
        T_CHAR(5),
        T_FLOAT(6),
        T_DOUBLE(7),
        T_BYTE(8),
        T_SHORT(9),
        T_INT(10),
        T_LONG(11);

        public final int atype;

        private NewArrayType(int atype) {
            this.atype = atype;
        }
    }

    public static enum OpcodeJump {
        IFEQ(153),
        IFNE(154),
        IFLT(155),
        IFGE(156),
        IFGT(157),
        IFLE(158),
        IF_ICMPEQ(159),
        IF_ICMPNE(160),
        IF_ICMPLT(161),
        IF_ICMPGE(162),
        IF_ICMPGT(163),
        IF_ICMPLE(164),
        IF_ACMPEQ(165),
        IF_ACMPNE(166),
        GOTO(167),
        JSR(168),
        IFNULL(198),
        IFNONNULL(199);

        public final int opcode;

        private OpcodeJump(int opcode) {
            this.opcode = opcode;
        }
    }

    public static enum OpcodeMethod {
        VIRTUAL(182),
        SPECIAL(183),
        STATIC(184),
        INTERFACE(185);

        public final int opcode;

        private OpcodeMethod(int opcode) {
            this.opcode = opcode;
        }
    }

    public static enum OpcodeVar {
        ILOAD(21),
        LLOAD(22),
        FLOAD(23),
        DLOAD(24),
        ALOAD(25),
        ISTORE(54),
        LSTORE(55),
        FSTORE(56),
        DSTORE(57),
        ASTORE(58);

        public final int opcode;

        private OpcodeVar(int opcode) {
            this.opcode = opcode;
        }
    }
}

