/*
 * Decompiled with CFR 0.152.
 */
package kpan.nutrition_gtceu.asm.core;

import java.lang.reflect.Method;
import javax.annotation.Nullable;
import kpan.nutrition_gtceu.asm.core.MyAsmNameRemapper;
import kpan.nutrition_gtceu.asm.core.MyTextifier;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.TraceMethodVisitor;

public class AsmUtil {
    public static final int ASM_VER = 327680;

    public static boolean isDeobfEnvironment() {
        return FMLLaunchHandler.isDeobfuscatedEnvironment();
    }

    public static boolean isOptifineLoaded() {
        try {
            Class.forName("optifine.Patcher");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static String obfDesc(String deobfDesc) {
        StringBuilder sb = new StringBuilder(deobfDesc.length());
        boolean object = false;
        StringBuilder sb_object = new StringBuilder();
        for (int i = 0; i < deobfDesc.length(); ++i) {
            char c = deobfDesc.charAt(i);
            if (object) {
                if (c == ';') {
                    String name = MyAsmNameRemapper.getClassObfName(sb_object.toString());
                    sb.append('L');
                    sb.append(name);
                    sb.append(';');
                    object = false;
                    sb_object.setLength(0);
                    continue;
                }
                sb_object.append(c);
                continue;
            }
            if (c == 'L') {
                object = true;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String deobfDesc(String obfDesc) {
        StringBuilder sb = new StringBuilder(obfDesc.length());
        boolean object = false;
        StringBuilder sb_object = new StringBuilder();
        for (int i = 0; i < obfDesc.length(); ++i) {
            char c = obfDesc.charAt(i);
            if (object) {
                if (c == ';') {
                    String name = MyAsmNameRemapper.getClassDeobfName(sb_object.toString());
                    sb.append('L');
                    sb.append(name);
                    sb.append(';');
                    object = false;
                    sb_object.setLength(0);
                    continue;
                }
                sb_object.append(c);
                continue;
            }
            if (c == 'L') {
                object = true;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toMethodDesc(Object returnType, Object ... rawDesc) {
        StringBuilder sb = new StringBuilder("(");
        for (Object o : rawDesc) {
            sb.append(AsmUtil.toDesc(o));
        }
        sb.append(')');
        sb.append(AsmUtil.toDesc(returnType));
        return sb.toString();
    }

    public static String toDesc(Object raw) {
        if (raw instanceof Class) {
            Class clazz = (Class)raw;
            return Type.getDescriptor((Class)clazz);
        }
        if (raw instanceof String) {
            int arr_dim;
            String desc = (String)raw;
            for (arr_dim = 0; arr_dim < desc.length() - 1 && desc.charAt(arr_dim) == '['; ++arr_dim) {
            }
            String arr_str = arr_dim > 0 ? StringUtils.repeat((char)'[', (int)arr_dim) : "";
            desc = desc.substring(arr_dim);
            if (desc.equals("V") || desc.equals("Z") || desc.equals("C") || desc.equals("B") || desc.equals("S") || desc.equals("I") || desc.equals("J") || desc.equals("F") || desc.equals("D")) {
                return arr_str + desc;
            }
            desc = (desc = desc.replace('.', '/')).matches("L.+;") ? desc : "L" + desc + ";";
            return arr_str + desc;
        }
        if (raw instanceof Object[]) {
            StringBuilder sb = new StringBuilder();
            for (Object o : (Object[])raw) {
                sb.append(AsmUtil.toDesc(o));
            }
            return sb.toString();
        }
        if (raw instanceof Method) {
            return Type.getMethodDescriptor((Method)((Method)raw));
        }
        throw new IllegalArgumentException();
    }

    public static MethodVisitor traceMethod(MethodVisitor mv, @Nullable String methodName) {
        MyTextifier p = new MyTextifier(methodName);
        return new TraceMethodVisitor(mv, (Printer)p);
    }

    public static String runtimeDesc(String deobfDesc) {
        if (AsmUtil.isDeobfEnvironment()) {
            return deobfDesc;
        }
        return AsmUtil.obfDesc(deobfDesc);
    }

    public static String composeRuntimeMethodDesc(Object deobfReturnType, Object ... deobfParams) {
        return AsmUtil.runtimeDesc(AsmUtil.toMethodDesc(deobfReturnType, deobfParams));
    }

    public static String runtimeMethodGenerics(String deobfGenerics) {
        throw new NotImplementedException("TODO");
    }

    public static String[] runtimeExceptions(String[] deobfExceptions) {
        throw new NotImplementedException("TODO");
    }

    public static int toLoadOpcode(String desc) {
        switch (desc) {
            case "Z": 
            case "C": 
            case "B": 
            case "S": 
            case "I": {
                return 21;
            }
            case "J": {
                return 22;
            }
            case "F": {
                return 23;
            }
            case "D": {
                return 24;
            }
        }
        return 25;
    }

    public static int loadLocals(MethodVisitor mv, String[] descs, int offset) {
        for (String desc : descs) {
            int opcode = AsmUtil.toLoadOpcode(desc);
            mv.visitVarInsn(opcode, offset);
            if (opcode == 22 || opcode == Opcodes.DOUBLE) {
                offset += 2;
                continue;
            }
            ++offset;
        }
        return offset;
    }

    public static int toReturnOpcode(String type) {
        switch (type) {
            case "V": {
                return 177;
            }
            case "Z": 
            case "C": 
            case "B": 
            case "S": 
            case "I": {
                return 172;
            }
            case "J": {
                return 173;
            }
            case "F": {
                return 174;
            }
            case "D": {
                return 175;
            }
        }
        return 176;
    }
}

