/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.config.element;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Module;
import com.gitlab.cdagaming.craftpresence.core.config.element.Button;
import craftpresence.external.com.jagrosh.discordipc.entities.ActivityType;
import craftpresence.external.com.jagrosh.discordipc.entities.PartyPrivacy;
import io.github.cdagaming.unicore.impl.HashMapBuilder;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class PresenceData
extends Module
implements Serializable {
    private static final long serialVersionUID = -7560029890988753870L;
    private static final PresenceData DEFAULT = new PresenceData();
    public boolean enabled = true;
    public boolean useAsMain = false;
    public boolean isInstance = false;
    public int activityType = ActivityType.Playing.ordinal();
    public int partyPrivacy = PartyPrivacy.Public.ordinal();
    public String details = "";
    public String gameState = "";
    public String largeImageKey = "";
    public String largeImageText = "";
    public String smallImageKey = "";
    public String smallImageText = "";
    public String startTimestamp = "";
    public String endTimestamp = "";
    public Map<String, Button> buttons = new HashMapBuilder().put((Object)"default", (Object)new Button(Constants.TRANSLATOR.translate("craftpresence.defaults.display.button.label", new Object[0]), Constants.TRANSLATOR.translate("craftpresence.defaults.display.button.url", new Object[0]))).build();

    public PresenceData(PresenceData other) {
        this.transferFrom(other);
    }

    public PresenceData() {
    }

    @Override
    public PresenceData getDefaults() {
        return new PresenceData(DEFAULT);
    }

    @Override
    public void transferFrom(Module target) {
        if (target instanceof PresenceData) {
            PresenceData data = (PresenceData)target;
            if (!this.equals(target)) {
                this.enabled = data.enabled;
                this.useAsMain = data.useAsMain;
                this.isInstance = data.isInstance;
                this.activityType = data.activityType;
                this.partyPrivacy = data.partyPrivacy;
                this.setDetails(data.details);
                this.setGameState(data.gameState);
                this.setLargeImage(data.largeImageKey, data.largeImageText);
                this.setSmallImage(data.smallImageKey, data.smallImageText);
                this.setTimes(data.startTimestamp, data.endTimestamp);
                this.buttons.clear();
                for (Map.Entry<String, Button> entry : data.buttons.entrySet()) {
                    this.addButton(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    @Override
    public Object getProperty(String name) {
        Object object;
        switch (name) {
            case "enabled": {
                object = this.enabled;
                break;
            }
            case "useAsMain": {
                object = this.useAsMain;
                break;
            }
            case "isInstance": {
                object = this.isInstance;
                break;
            }
            case "activityType": {
                object = this.activityType;
                break;
            }
            case "partyPrivacy": {
                object = this.partyPrivacy;
                break;
            }
            case "details": {
                object = this.details;
                break;
            }
            case "gameState": {
                object = this.gameState;
                break;
            }
            case "largeImageKey": {
                object = this.largeImageKey;
                break;
            }
            case "largeImageText": {
                object = this.largeImageText;
                break;
            }
            case "smallImageKey": {
                object = this.smallImageKey;
                break;
            }
            case "smallImageText": {
                object = this.smallImageText;
                break;
            }
            case "startTimestamp": {
                object = this.startTimestamp;
                break;
            }
            case "endTimestamp": {
                object = this.endTimestamp;
                break;
            }
            case "buttons": {
                object = this.buttons;
                break;
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    @Override
    public void setProperty(String name, Object value) {
        try {
            switch (name) {
                case "enabled": {
                    this.enabled = (Boolean)value;
                    break;
                }
                case "useAsMain": {
                    this.useAsMain = (Boolean)value;
                    break;
                }
                case "isInstance": {
                    this.isInstance = (Boolean)value;
                    break;
                }
                case "activityType": {
                    this.activityType = (Integer)value;
                    break;
                }
                case "partyPrivacy": {
                    this.partyPrivacy = (Integer)value;
                    break;
                }
                case "details": {
                    this.details = (String)value;
                    break;
                }
                case "gameState": {
                    this.gameState = (String)value;
                    break;
                }
                case "largeImageKey": {
                    this.largeImageKey = (String)value;
                    break;
                }
                case "largeImageText": {
                    this.largeImageText = (String)value;
                    break;
                }
                case "smallImageKey": {
                    this.smallImageKey = (String)value;
                    break;
                }
                case "smallImageText": {
                    this.smallImageText = (String)value;
                    break;
                }
                case "startTimestamp": {
                    this.startTimestamp = (String)value;
                    break;
                }
                case "endTimestamp": {
                    this.endTimestamp = (String)value;
                    break;
                }
                case "buttons": {
                    this.buttons = (Map)value;
                    break;
                }
            }
        }
        catch (Throwable ex) {
            this.printException(ex);
        }
    }

    @Override
    public PresenceData copy() {
        return new PresenceData(this);
    }

    public PresenceData setDetails(String details) {
        this.details = details;
        return this;
    }

    public PresenceData setGameState(String gameState) {
        this.gameState = gameState;
        return this;
    }

    public PresenceData setLargeImage(String imageKey, String imageText) {
        this.largeImageKey = imageKey;
        this.largeImageText = imageText;
        return this;
    }

    public PresenceData setSmallImage(String imageKey, String imageText) {
        this.smallImageKey = imageKey;
        this.smallImageText = imageText;
        return this;
    }

    public PresenceData setTimes(String startTimestamp, String endTimestamp) {
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        return this;
    }

    public PresenceData setStartTime(String timestamp) {
        return this.setTimes(timestamp, this.endTimestamp);
    }

    public PresenceData setEndTime(String timestamp) {
        return this.setTimes(this.startTimestamp, timestamp);
    }

    public PresenceData addButton(String name, Button button) {
        this.buttons.put(name, new Button(button));
        return this;
    }

    public PresenceData removeButton(String name) {
        this.buttons.remove(name);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PresenceData)) {
            return false;
        }
        PresenceData other = (PresenceData)obj;
        return Objects.equals(other.enabled, this.enabled) && Objects.equals(other.useAsMain, this.useAsMain) && Objects.equals(other.isInstance, this.isInstance) && Objects.equals(other.activityType, this.activityType) && Objects.equals(other.partyPrivacy, this.partyPrivacy) && Objects.equals(other.details, this.details) && Objects.equals(other.gameState, this.gameState) && Objects.equals(other.largeImageKey, this.largeImageKey) && Objects.equals(other.largeImageText, this.largeImageText) && Objects.equals(other.smallImageKey, this.smallImageKey) && Objects.equals(other.startTimestamp, this.startTimestamp) && Objects.equals(other.endTimestamp, this.endTimestamp) && Objects.equals(other.buttons, this.buttons);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.useAsMain, this.isInstance, this.activityType, this.partyPrivacy, this.details, this.gameState, this.largeImageKey, this.largeImageText, this.smallImageKey, this.smallImageText, this.startTimestamp, this.endTimestamp, this.buttons);
    }
}

