/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shetiphian.core.common.Function;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.block.BlockVault;
import shetiphian.multistorage.common.tileentity.IVaultWall;
import shetiphian.multistorage.common.tileentity.TileEntityVaultDoor;

public class TileEntityVaultBase
extends TileEntityBase
implements IVaultWall {
    private List<BlockPos> doorList = new ArrayList<BlockPos>();
    private EnumDyeColor color = EnumDyeColor.WHITE;

    protected NBTTagCompound toNBT(BlockPos pos) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("xCoord", pos.func_177958_n());
        tag.func_74768_a("yCoord", pos.func_177956_o());
        tag.func_74768_a("zCoord", pos.func_177952_p());
        return tag;
    }

    protected BlockPos fromNBT(NBTTagCompound tag) {
        return new BlockPos(tag.func_74762_e("xCoord"), tag.func_74762_e("yCoord"), tag.func_74762_e("zCoord"));
    }

    protected void buildNBT(NBTTagCompound nbtTag) {
        NBTTagList nbtDoorList = new NBTTagList();
        for (BlockPos pos : this.doorList) {
            nbtDoorList.func_74742_a((NBTBase)this.toNBT(pos));
        }
        nbtTag.func_74782_a("doors", (NBTBase)nbtDoorList);
        nbtTag.func_74778_a("color", this.color.func_176610_l());
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.doorList.clear();
        NBTTagList nbtDoorList = nbtTag.func_150295_c("doors", 10);
        for (int entry = 0; entry < nbtDoorList.func_74745_c(); ++entry) {
            this.doorList.add(this.fromNBT(nbtDoorList.func_150305_b(entry)));
        }
        if (nbtTag.func_74764_b("color")) {
            for (EnumDyeColor dyeColor : EnumDyeColor.values()) {
                if (!dyeColor.func_176610_l().equalsIgnoreCase(nbtTag.func_74779_i("color"))) continue;
                this.color = dyeColor;
            }
        }
    }

    List<BlockPos> getDoorList() {
        return this.doorList;
    }

    void setDoorList(List<BlockPos> doorList) {
        this.doorList = doorList;
    }

    @Override
    public IBlockState getActualState(IBlockState state) {
        return state.func_177226_a(BlockVault.COLOR, (Comparable)this.color);
    }

    @Override
    public void wallPoured(BlockVault.EnumType type, ItemStack base, EnumDyeColor color) {
        if (color != null) {
            this.recolor(EnumFacing.UP, color);
        }
        if (base.func_77952_i() > 20) {
            for (EnumFacing facing : EnumFacing.values()) {
                BlockPos sPos = this.func_174877_v().func_177972_a(facing);
                IBlockState sState = this.func_145831_w().func_180495_p(sPos);
                Block sBlock = sState.func_177230_c();
                sState = sBlock.func_176221_a(sState, (IBlockAccess)this.func_145831_w(), sPos);
                if (!(sBlock instanceof BlockVault)) continue;
                BlockVault.EnumType baseType = BlockVault.getEnumType(sState);
                if (baseType.getValue() == 14) {
                    Function.setBlock((World)this.func_145831_w(), (BlockPos)sPos, (IBlockState)Values.blockVault.func_176203_a((int)BlockVault.EnumType.byValue(baseType.getBaseValue()).getValue()), (boolean)true);
                }
                if (color == null) continue;
                sBlock.recolorBlock(this.func_145831_w(), sPos, EnumFacing.UP, color);
            }
        }
    }

    @Override
    public void verifyDoors() {
        if (!this.doorList.isEmpty()) {
            ArrayList<BlockPos> removeList = new ArrayList<BlockPos>();
            for (BlockPos pos : this.doorList) {
                if (this.func_145831_w().func_175625_s(pos) instanceof TileEntityVaultDoor) continue;
                removeList.add(pos);
            }
            this.doorList.removeAll(removeList);
        }
    }

    @Override
    public boolean isActive() {
        return !this.doorList.isEmpty();
    }

    @Override
    public boolean containsDoor(BlockPos pos) {
        return this.doorList.contains(pos);
    }

    @Override
    public void addDoor(BlockPos pos) {
        if (!this.containsDoor(pos)) {
            this.doorList.add(pos);
        }
    }

    @Override
    public void removeDoor(BlockPos pos) {
        if (this.containsDoor(pos)) {
            this.doorList.remove(pos);
        }
    }

    @Override
    public boolean recolor(EnumFacing side, EnumDyeColor color) {
        if (color != this.color) {
            this.color = color;
            Function.syncTile((TileEntity)this);
            return true;
        }
        return false;
    }

    public boolean isMultiVaultUse() {
        return this.doorList.size() > 1;
    }

    public boolean canPlayerEdit(EntityPlayer player) {
        for (BlockPos doorPos : this.doorList) {
            TileEntity tile = this.func_145831_w().func_175625_s(doorPos);
            if (!(tile instanceof TileEntityVaultDoor) || ((TileEntityVaultDoor)tile).vaultAccess.canEditVault(player)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> getExtraHudInfo(List<String> info, boolean isWaila) {
        return info;
    }
}

