/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.tileentity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.multistorage.common.block.BlockStorageType;
import shetiphian.multistorage.common.inventory.ContainerStacking;
import shetiphian.multistorage.common.inventory.InventoryStackingChestBase;
import shetiphian.multistorage.common.inventory.InventoryStackingChestMulti;
import shetiphian.multistorage.common.tileentity.TileEntityStorageBase;

public class TileEntityStackingChest
extends TileEntityStorageBase
implements ITickable {
    public float lidAngle;
    public float prevLidAngle;
    private int numPlayersUsing;
    private int ticksSinceSync;

    public void func_73660_a() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (!this.func_145831_w().field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + x + y + z) % 200 == 0) {
            this.numPlayersUsing = 0;
            for (EntityPlayer player : this.func_145831_w().func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
                IInventory[] chests;
                IInventory iinventory;
                if (!(player.field_71070_bA instanceof ContainerStacking) || !((iinventory = ((ContainerStacking)player.field_71070_bA).getChestInventory()) instanceof InventoryStackingChestMulti) || (chests = ((InventoryStackingChestMulti)iinventory).getChests())[0] != this.getChest() && chests[1] != this.getChest() && chests[2] != this.getChest()) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f && this.playSound()) {
            this.func_145831_w().func_184148_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float oldAngle = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && oldAngle >= 0.5f && this.playSound()) {
                this.func_145831_w().func_184148_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    private boolean playSound() {
        BlockStorageType.EnumType type = BlockStorageType.getEnumType(this.func_145831_w().func_180495_p(this.func_174877_v()));
        return type == BlockStorageType.EnumType.STACKABLE_SINGLE || type == BlockStorageType.EnumType.STACKABLE_BOTTOM || type == BlockStorageType.EnumType.DENSE_STACKABLE_SINGLE || type == BlockStorageType.EnumType.DENSE_STACKABLE_BOTTOM;
    }

    public boolean func_145842_c(int id, int value) {
        if (id == 1) {
            this.numPlayersUsing = value;
            return true;
        }
        return super.func_145842_c(id, value);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new InvWrapper(this.getMultiBlockInventory());
        }
        return super.getCapability(capability, side);
    }

    @Override
    public int getChestSize() {
        return 27;
    }

    @Override
    protected String getInvName() {
        return "inv.stacking.chest";
    }

    @Override
    public void onContainerOpen(EntityPlayer player) {
        super.onContainerOpen(player);
        if (!player.func_175149_v()) {
            this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
        }
    }

    @Override
    public void onContainerClosed(EntityPlayer player) {
        super.onContainerClosed(player);
        if (!player.func_175149_v()) {
            this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
        }
    }

    private IInventory getMultiBlockInventory() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        BlockStorageType.EnumType type = BlockStorageType.getEnumType(state);
        if (type != BlockStorageType.EnumType.STACKABLE_SINGLE && type != BlockStorageType.EnumType.DENSE_STACKABLE_SINGLE) {
            IInventory[] inventories = new IInventory[3];
            if (type == BlockStorageType.EnumType.STACKABLE_MIDDLE || type == BlockStorageType.EnumType.DENSE_STACKABLE_MIDDLE) {
                inventories[0] = this.getInventory(this.func_174877_v().func_177984_a());
                inventories[1] = this.inventory;
                inventories[2] = this.getInventory(this.func_174877_v().func_177977_b());
            } else if (type == BlockStorageType.EnumType.STACKABLE_TOP || type == BlockStorageType.EnumType.DENSE_STACKABLE_TOP) {
                type = BlockStorageType.getEnumType(this.func_145831_w().func_180495_p(this.func_174877_v().func_177977_b()));
                inventories[0] = this.inventory;
                inventories[1] = this.getInventory(this.func_174877_v().func_177977_b());
                inventories[2] = type == BlockStorageType.EnumType.STACKABLE_MIDDLE || type == BlockStorageType.EnumType.DENSE_STACKABLE_MIDDLE ? this.getInventory(this.func_174877_v().func_177979_c(2)) : null;
            } else if (type == BlockStorageType.EnumType.STACKABLE_BOTTOM || type == BlockStorageType.EnumType.DENSE_STACKABLE_BOTTOM) {
                type = BlockStorageType.getEnumType(this.func_145831_w().func_180495_p(this.func_174877_v().func_177984_a()));
                inventories[0] = type == BlockStorageType.EnumType.STACKABLE_MIDDLE || type == BlockStorageType.EnumType.DENSE_STACKABLE_MIDDLE ? this.getInventory(this.func_174877_v().func_177981_b(2)) : null;
                inventories[1] = this.getInventory(this.func_174877_v().func_177984_a());
                inventories[2] = this.inventory;
            }
            return new InventoryStackingChestMulti(inventories[0], inventories[1], inventories[2]);
        }
        return new InventoryStackingChestBase((IInventory)this.inventory);
    }

    private IInventory getInventory(BlockPos pos) {
        TileEntity tile = this.func_145831_w().func_175625_s(pos);
        return tile instanceof TileEntityStackingChest ? ((TileEntityStackingChest)tile).inventory : null;
    }

    public static IInventory getMultiBlockInventory(TileEntity top, TileEntity middle, TileEntity bottom) {
        return new InventoryStackingChestMulti(TileEntityStackingChest.getInventory(top), TileEntityStackingChest.getInventory(middle), TileEntityStackingChest.getInventory(bottom));
    }

    private static IInventory getInventory(TileEntity tile) {
        return tile instanceof TileEntityStackingChest ? ((TileEntityStackingChest)tile).inventory : null;
    }
}

