/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.misc;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.block.BlockVault;
import shetiphian.multistorage.common.item.ItemBlockVault;
import shetiphian.multistorage.common.tileentity.IVaultWall;

public class FluidConcrete
extends Fluid {
    public static final ResourceLocation resource = new ResourceLocation("multistorage:fluids/concrete");
    private EnumDyeColor dyeColor;

    public FluidConcrete(EnumDyeColor dyeColor) {
        super(dyeColor == null ? "multistorage:concrete" : "concrete_" + dyeColor.func_176610_l(), resource, resource);
        this.setUnlocalizedName("multistorage.concrete");
        this.dyeColor = dyeColor;
        this.setDensity(2400);
        this.setViscosity(4000);
    }

    public int getColor() {
        return this.dyeColor == null ? -1 : this.dyeColor.field_193351_w & 0xFFFFFF | 0xFF000000;
    }

    public String getLocalizedName(FluidStack stack) {
        String name = Localization.get((String)this.getUnlocalizedName());
        name = this.dyeColor != null ? name + " (" + Localization.get((String)this.dyeColor.func_176610_l()) + ")" : name + " (deprecated, gone in 1.13)";
        return name;
    }

    public static boolean pourWall(World world, BlockPos pos, EntityPlayer player, FluidStack fluidStack) {
        EnumDyeColor color = null;
        if (fluidStack != null) {
            color = EnumDyeColor.func_176764_b((int)RGB16Helper.getSimpleColor((short)RGB16Helper.getIndexFor((int)fluidStack.getFluid().getColor(fluidStack))));
        }
        return FluidConcrete.pourWall(world, pos, player, color);
    }

    public static boolean pourWall(World world, BlockPos pos, EntityPlayer player, EnumDyeColor color) {
        if (Values.blockVault == null) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == null) {
            return false;
        }
        BlockVault.EnumType setType = null;
        ItemStack blockItem = null;
        if (block instanceof BlockVault) {
            BlockVault.EnumType baseType = BlockVault.getEnumType(state = state.func_185899_b((IBlockAccess)world, pos));
            if (baseType.getValue() == 14) {
                setType = BlockVault.EnumType.byValue(baseType.getBaseValue());
                blockItem = new ItemStack(block, 1, baseType.getBaseValue() + 20);
            }
        } else {
            blockItem = block.getPickBlock(state, Function.rayTrace((EntityPlayer)player, (double)5.0, (float)0.0f), world, pos, player);
            setType = FluidConcrete.getTypeFromStack(blockItem);
        }
        if (setType == null) {
            return false;
        }
        Function.setBlock((World)world, (BlockPos)pos, (IBlockState)Values.blockVault.func_176203_a((int)setType.getValue()), (boolean)true);
        TileEntity wallTile = world.func_175625_s(pos);
        if (wallTile instanceof IVaultWall) {
            ((IVaultWall)wallTile).wallPoured(setType, blockItem, color);
            Function.syncTile((TileEntity)wallTile);
        }
        world.func_184133_a(player, pos, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    public static BlockVault.EnumType getTypeFromStack(ItemStack stack) {
        if (stack != null) {
            int meta;
            if (stack.func_77973_b() instanceof ItemBlockVault && (meta = stack.func_77952_i()) >= 1 && meta <= 33) {
                return BlockVault.EnumType.byValue(meta < 20 ? meta : meta - 20);
            }
            for (BlockVault.EnumType type : BlockVault.EnumType.values()) {
                ArrayList<Object> baseItems;
                if (type.getValue() < 1 || type.getValue() > 13 || (baseItems = Values.wallBaseItems.get((Object)type)) == null) continue;
                for (Object object : baseItems) {
                    if (!(object instanceof String ? OreDictionary.containsMatch((boolean)false, (NonNullList)OreDictionary.getOres((String)((String)object)), (ItemStack[])new ItemStack[]{stack}) : object instanceof ItemStack && Function.areItemStacksEqual((ItemStack)stack, (ItemStack)((ItemStack)object), (boolean)true))) continue;
                    return type;
                }
            }
        }
        return null;
    }
}

