/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.item;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import shetiphian.core.common.Function;
import shetiphian.core.common.item.ItemBlockMulti;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.block.BlockStorageType;
import shetiphian.multistorage.common.tileentity.TileEntityChameleon;
import shetiphian.multistorage.common.tileentity.TileEntityJunkbox;
import shetiphian.multistorage.common.tileentity.TileEntityJunkboxDense;
import shetiphian.multistorage.common.tileentity.TileEntityQueue;
import shetiphian.multistorage.common.tileentity.TileEntityStackingChest;
import shetiphian.multistorage.common.tileentity.TileEntityStorageBase;
import shetiphian.multistorage.modintegration.terraqueous.Terraqueous_Base;

public class ItemBlockStorageType
extends ItemBlockMulti {
    public ItemBlockStorageType(Block block) {
        super(block, "Block" + (block.func_149739_a().toLowerCase().contains("cloud") ? "Cloud" : "Stone") + "Storage", Values.nameMapper);
    }

    public void getSubItems(NonNullList<ItemStack> list) {
        for (int meta = 0; meta < 9; ++meta) {
            list.add((Object)new ItemStack((Item)this, 1, meta));
        }
    }

    public boolean func_179222_a(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        int damage = stack.func_77952_i();
        return damage == 0 || this.canStackChests(damage, world, pos, side, player).canStack() || super.func_179222_a(world, pos, side, player, stack);
    }

    private UpgradeAction canStackChests(int damage, World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        TileEntityJunkbox junkbox;
        if (damage != 5 && damage != 6 || !(player instanceof FakePlayer) && side.func_176740_k() != EnumFacing.Axis.Y || world.func_180495_p(pos).func_177230_c() != this.func_179223_d()) {
            return UpgradeAction.NONE;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityJunkbox && !(junkbox = (TileEntityJunkbox)tile).isDouble() && (player instanceof FakePlayer || side == EnumFacing.DOWN && junkbox.isTop() || side == EnumFacing.UP && !junkbox.isTop())) {
            return damage == 5 ? UpgradeAction.DOUBLE : (junkbox instanceof TileEntityJunkboxDense ? UpgradeAction.DOUBLE_REFUND : UpgradeAction.DOUBLE_DENSE);
        }
        return UpgradeAction.NONE;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190916_E() == 0) {
            return EnumActionResult.PASS;
        }
        int damage = stack.func_77952_i();
        if (damage == 0) {
            if (player.func_175151_a(pos, facing, stack) && Terraqueous_Base.INSTANCE.canPlaceAt(world, pos, this.nameId.toLowerCase().contains("cloud")) && this.upgradeChest(world, pos, player, stack, UpgradeAction.DENSE_ONLY)) {
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        UpgradeAction upgradeAction = this.canStackChests(damage, world, pos, facing, player);
        if (upgradeAction.canStack()) {
            this.upgradeChest(world, pos, player, stack, upgradeAction);
            return EnumActionResult.SUCCESS;
        }
        if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (!player.func_175151_a(pos, facing, stack) || !Terraqueous_Base.INSTANCE.canPlaceAt(world, pos, this.nameId.toLowerCase().contains("cloud"))) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (!stack.func_190926_b() && player.func_175151_a(pos, facing, stack) && world.func_190527_a(this.field_150939_a, pos, false, facing, null) && Terraqueous_Base.INSTANCE.canPlaceAt(world, pos, this.nameId.toLowerCase().contains("cloud"))) {
            int metadata = this.func_77647_b(stack.func_77960_j());
            IBlockState state = this.field_150939_a.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, metadata, (EntityLivingBase)player, hand);
            if (this.placeBlockAt(stack, player, world, pos, facing, hitX, hitY, hitZ, state)) {
                SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), world, pos, (Entity)player);
                world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        UpgradeAction upgradeAction;
        if (player instanceof FakePlayer && (upgradeAction = this.canStackChests(stack.func_77952_i(), world, pos, side, player)).canStack()) {
            this.upgradeChest(world, pos, player, stack, upgradeAction);
            return false;
        }
        if (!Function.setBlock((World)world, (BlockPos)pos, (IBlockState)newState, (boolean)false)) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityStackingChest) {
            BlockStorageType.STACKING.onBlockPlaced(stack, player, world, pos, side, hitX, hitY, hitZ);
        } else if (tile instanceof TileEntityChameleon) {
            BlockStorageType.CHAMELEON.onBlockPlaced(stack, player, world, pos, side, hitX, hitY, hitZ);
            ((TileEntityChameleon)tile).setClonedPos(pos.func_177972_a(side.func_176734_d()));
        } else if (tile instanceof TileEntityJunkbox) {
            BlockStorageType.JUNKBOX.onBlockPlaced(stack, player, world, pos, side, hitX, hitY, hitZ);
        } else if (tile instanceof TileEntityQueue) {
            BlockStorageType.QUEUE.onBlockPlaced(stack, player, world, pos, side, hitX, hitY, hitZ);
        } else {
            Function.removeBlock((World)world, (BlockPos)pos, (boolean)false);
            return false;
        }
        return true;
    }

    private boolean upgradeChest(World world, BlockPos pos, EntityPlayer player, ItemStack stack, UpgradeAction action) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this.func_179223_d()) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityStorageBase)) {
            return false;
        }
        if (action.makeDense()) {
            BlockStorageType.EnumType type = BlockStorageType.getEnumType(state);
            if (!type.isDense()) {
                IBlockState uState = state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)BlockStorageType.EnumType.byValue(type.getValue() + 8)));
                NBTTagCompound nbtTag = tile.serializeNBT();
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)uState, (boolean)true);
                tile = world.func_175625_s(pos);
                if (!(tile instanceof TileEntityStorageBase)) {
                    Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state, (boolean)true);
                    tile = world.func_175625_s(pos);
                    if (tile instanceof TileEntityStorageBase) {
                        tile.deserializeNBT(nbtTag);
                        Function.syncTile((TileEntity)tile);
                    }
                    return false;
                }
                tile.deserializeNBT(nbtTag);
            } else {
                return false;
            }
        }
        if (action.makeDouble()) {
            ((TileEntityJunkbox)tile).setDouble();
        }
        Function.syncTile((TileEntity)tile);
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
            if (action.doRefund()) {
                Function.giveItem((EntityPlayer)player, (ItemStack)new ItemStack(stack.func_77973_b(), 1, 0));
            }
        }
        SoundType soundtype = state.func_177230_c().func_185467_w();
        world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        return true;
    }

    protected void addToNameMap() {
        String type = this.nameId.toLowerCase().contains("cloud") ? "cloud" : "stone";
        this.add(0, "", type + "_upgrade", "upgrade");
        this.add(1, "", type + "_stacking", "stacking");
        this.add(2, "", type + "_stacking_dense", "stacking.dense");
        this.add(3, "", type + "_chameleon", "chameleon");
        this.add(4, "", type + "_chameleon_dense", "chameleon.dense");
        this.add(5, "", type + "_junkbox", "junkbox");
        this.add(6, "", type + "_junkbox_dense", "junkbox.dense");
        this.add(7, "", type + "_queue", "queue");
        this.add(8, "", type + "_queue_dense", "queue.dense");
    }

    private static enum UpgradeAction {
        NONE,
        DOUBLE,
        DOUBLE_REFUND,
        DOUBLE_DENSE,
        DENSE_ONLY;


        private boolean canStack() {
            return this != NONE;
        }

        private boolean makeDense() {
            return this == DOUBLE_DENSE || this == DENSE_ONLY;
        }

        private boolean makeDouble() {
            return this != NONE && this != DENSE_ONLY;
        }

        private boolean doRefund() {
            return this == DOUBLE_REFUND;
        }
    }
}

