/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.block;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.UUID;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.multistorage.Configuration;
import shetiphian.multistorage.MultiStorage;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.block.BlockVault;
import shetiphian.multistorage.common.misc.UUIDHelper;
import shetiphian.multistorage.common.tileentity.IVaultWall;
import shetiphian.multistorage.common.tileentity.TileEntityVaultDoor;
import shetiphian.multistorage.common.tileentity.TileEntityVaultGlass;

public class VaultHelper {
    private static byte[][] doorMap2x = new byte[][]{{1, 1, 1, 1}, {1, -1, 0, 1}, {1, 0, 0, 1}, {1, 1, 1, 1}};
    private static byte[][] doorMap3x = new byte[][]{{1, 1, 1, 1, 1}, {1, -1, 0, 0, 1}, {1, 0, 0, 0, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}};

    static AxisAlignedBB getBlockBounds(IBlockAccess world, BlockPos pos) {
        double[] bounds = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
        BlockPos start = null;
        boolean by3 = false;
        EnumFacing facing = EnumFacing.NORTH;
        try {
            TileEntityVaultDoor baseTile = (TileEntityVaultDoor)world.func_175625_s(pos);
            TileEntityVaultDoor doorTile = (TileEntityVaultDoor)world.func_175625_s(baseTile.location);
            by3 = doorTile.vaultDoorType == TileEntityVaultDoor.EnumDoorPart.CONTROLLER_3X;
            facing = doorTile.direction;
            start = doorTile.func_174877_v();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (start != null && facing != null) {
            bounds[1] = start.func_177956_o() - pos.func_177956_o();
            bounds[4] = bounds[1] + (double)(by3 ? 3 : 2);
            switch (facing) {
                case NORTH: {
                    bounds[2] = start.func_177952_p() - pos.func_177952_p();
                    bounds[0] = start.func_177958_n() - pos.func_177958_n();
                    bounds[5] = bounds[2] + 1.0;
                    bounds[3] = bounds[0] + (double)(by3 ? 3 : 2);
                    break;
                }
                case EAST: {
                    bounds[0] = start.func_177958_n() - pos.func_177958_n();
                    bounds[2] = start.func_177952_p() - pos.func_177952_p();
                    bounds[3] = bounds[0] + 1.0;
                    bounds[5] = bounds[2] + (double)(by3 ? 3 : 2);
                    break;
                }
                case SOUTH: {
                    bounds[2] = start.func_177952_p() - pos.func_177952_p();
                    bounds[3] = start.func_177958_n() - pos.func_177958_n() + 1;
                    bounds[5] = bounds[2] + 1.0;
                    bounds[0] = bounds[3] - (double)(by3 ? 3 : 2);
                    break;
                }
                case WEST: {
                    bounds[0] = start.func_177958_n() - pos.func_177958_n();
                    bounds[5] = start.func_177952_p() - pos.func_177952_p() + 1;
                    bounds[3] = bounds[0] + 1.0;
                    bounds[2] = bounds[5] - (double)(by3 ? 3 : 2);
                }
            }
        }
        return new AxisAlignedBB(bounds[0], bounds[1], bounds[2], bounds[3], bounds[4], bounds[5]);
    }

    static boolean onBlockActivated(TileEntityVaultDoor doorTile, EntityPlayer player) {
        if (doorTile.location != doorTile.func_174877_v()) {
            TileEntity otherTile = doorTile.func_145831_w().func_175625_s(doorTile.location);
            if (!(otherTile instanceof TileEntityVaultDoor)) {
                return true;
            }
            doorTile = (TileEntityVaultDoor)otherTile;
        }
        if (doorTile.vaultFixCounter < 1) {
            VaultHelper.setBlockData(doorTile, doorTile.vaultAccess.getOwnerId(), doorTile.location, false, true);
            doorTile.vaultFixCounter = 1;
        }
        int dX = doorTile.location.func_177958_n();
        int dY = doorTile.location.func_177956_o();
        int dZ = doorTile.location.func_177952_p();
        if (player.func_70093_af() && doorTile.vaultAccess.canEditVault(player)) {
            player.openGui((Object)MultiStorage.INSTANCE, 0, player.func_130014_f_(), dX, dY, dZ);
        } else if (!player.func_130014_f_().field_72995_K) {
            boolean noEntry = !doorTile.vaultAccess.canUseVault(player);
            String inout = "";
            EnumFacing facing = doorTile.direction;
            switch (facing) {
                case EAST: 
                case WEST: {
                    if (player.field_70165_t < (double)dX) {
                        if (facing == EnumFacing.EAST && noEntry) {
                            return true;
                        }
                        player.func_70634_a((double)dX + 1.5, (double)dY, (double)dZ + 0.5);
                        inout = facing == EnumFacing.EAST ? "enter" : "leave";
                        break;
                    }
                    if (facing == EnumFacing.WEST && noEntry) {
                        return true;
                    }
                    player.func_70634_a((double)dX - 0.5, (double)dY, (double)dZ + 0.5);
                    inout = facing == EnumFacing.WEST ? "enter" : "leave";
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    if (player.field_70161_v < (double)dZ) {
                        if (facing == EnumFacing.SOUTH && noEntry) {
                            return true;
                        }
                        player.func_70634_a((double)dX + 0.5, (double)dY, (double)dZ + 1.5);
                        inout = facing == EnumFacing.SOUTH ? "enter" : "leave";
                        break;
                    }
                    if (facing == EnumFacing.NORTH && noEntry) {
                        return true;
                    }
                    player.func_70634_a((double)dX + 0.5, (double)dY, (double)dZ - 0.5);
                    String string = inout = facing == EnumFacing.NORTH ? "enter" : "leave";
                }
            }
            if (inout.equalsIgnoreCase("enter") && Configuration.SETTINGS.VAULT.LOGS.logEntry || inout.equalsIgnoreCase("leave") && Configuration.SETTINGS.VAULT.LOGS.logExit) {
                VaultHelper.vaultLog(doorTile, player, Localization.get((String)("info.multistorage.vault.door." + inout + ".txt")), false);
            }
        }
        return true;
    }

    public static boolean canPlayerPlaceDoor(EntityPlayer player) {
        switch (Configuration.SETTINGS.VAULT.permissionVault) {
            case 3: {
                return true;
            }
            case 2: {
                if (player.field_71075_bZ.field_75098_d) {
                    return true;
                }
            }
            case 1: {
                return Function.isOP((EntityPlayer)player);
            }
        }
        return false;
    }

    public static BlockPos getDoorStart(World world, BlockPos pos, EntityPlayer player) {
        int moves;
        for (moves = 0; world.func_175623_d(pos.func_177977_b()) && moves < 3; ++moves) {
            pos = pos.func_177977_b();
        }
        EnumFacing direction = player.func_174811_aO();
        switch (direction) {
            case SOUTH: {
                for (moves = 0; world.func_175623_d(pos.func_177974_f()) && moves < 3; ++moves) {
                    pos = pos.func_177974_f();
                }
                break;
            }
            case WEST: {
                while (world.func_175623_d(pos.func_177968_d()) && moves < 3) {
                    pos = pos.func_177968_d();
                    ++moves;
                }
                break;
            }
            case NORTH: {
                while (world.func_175623_d(pos.func_177976_e()) && moves < 3) {
                    pos = pos.func_177976_e();
                    ++moves;
                }
                break;
            }
            case EAST: {
                while (world.func_175623_d(pos.func_177978_c()) && moves < 3) {
                    pos = pos.func_177978_c();
                    ++moves;
                }
                break;
            }
        }
        return VaultHelper.canPlaceDoor(world, pos, player) < 2 ? null : pos;
    }

    private static byte canPlaceDoor(World world, BlockPos pos, EntityPlayer player) {
        if (player == null) {
            return 0;
        }
        EnumFacing facing = player.func_174811_aO();
        BlockPos temp = pos;
        for (int pass = 0; pass < 2; pass = (int)((byte)(pass + 1))) {
            byte size = (byte)(pass == 0 ? 2 : 3);
            boolean doorValid = true;
            block7: for (byte sy = -1; sy <= size; sy = (byte)(sy + 1)) {
                for (byte sxz = -1; sxz <= size; sxz = (byte)(sxz + 1)) {
                    byte mapValue;
                    byte by = mapValue = size == 2 ? doorMap2x[sy + 1][sxz + 1] : doorMap3x[sy + 1][sxz + 1];
                    if (mapValue == -1) continue;
                    switch (facing) {
                        case SOUTH: {
                            temp = pos.func_177982_a((int)(-sxz), (int)sy, 0);
                            break;
                        }
                        case WEST: {
                            temp = pos.func_177982_a(0, (int)sy, (int)(-sxz));
                            break;
                        }
                        case NORTH: {
                            temp = pos.func_177982_a((int)sxz, (int)sy, 0);
                            break;
                        }
                        case EAST: {
                            temp = pos.func_177982_a(0, (int)sy, (int)sxz);
                        }
                    }
                    if (mapValue == 0 && world.func_175623_d(temp) || mapValue == 1 && VaultHelper.isUsableAsFrame(world.func_175625_s(temp))) continue;
                    doorValid = false;
                    break block7;
                }
            }
            if (!doorValid) continue;
            return size;
        }
        if (world.field_72995_K) {
            Localization.addChat((EntityPlayer)player, (String)Localization.get((String)"error.multistorage.vault.door.placement.msg"));
        }
        return 0;
    }

    public static boolean placeDoor(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        EnumFacing direction = player.func_174811_aO();
        byte doorSize = VaultHelper.canPlaceDoor(world, pos, player);
        if (doorSize < 2) {
            return false;
        }
        Function.setBlock((World)world, (BlockPos)pos, (IBlockState)Values.blockVault.func_176223_P().func_177226_a(BlockVault.VARIANT, (Comparable)((Object)BlockVault.EnumType.DOOR)), (boolean)false);
        boolean blockPlaced = false;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityVaultDoor) {
            TileEntityVaultDoor doorTile = (TileEntityVaultDoor)tile;
            doorTile.direction = direction;
            doorTile.vaultDoorType = doorSize == 3 ? TileEntityVaultDoor.EnumDoorPart.CONTROLLER_3X : TileEntityVaultDoor.EnumDoorPart.CONTROLLER_2X;
            doorTile.location = pos;
            doorTile.doorSection = 0;
            String vaultName = stack.func_82837_s() ? stack.func_82833_r() : "null";
            blockPlaced = VaultHelper.onDoorPlaced(world, pos, player, doorTile, vaultName);
            if (!blockPlaced) {
                VaultHelper.doorBlocks(world, pos, doorTile, true);
            }
        }
        if (blockPlaced) {
            SoundType soundtype = Values.blockVault.func_185467_w();
            world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        }
        return blockPlaced;
    }

    public static boolean onDoorPlaced(World world, BlockPos pos, EntityPlayer player, TileEntityVaultDoor doorTile, String vaultName) {
        int cY;
        int cX;
        UUID owner = player.func_110124_au();
        BlockPos doorPoint = pos;
        VaultHelper.doorBlocks(world, pos, doorTile, false);
        pos = pos.func_177972_a(doorTile.direction);
        int[] base = new int[]{pos.func_177956_o(), pos.func_177956_o(), pos.func_177952_p(), pos.func_177952_p(), pos.func_177958_n(), pos.func_177958_n()};
        int scanner = 1;
        block0: for (EnumFacing facing : EnumFacing.field_82609_l) {
            while (scanner < 16) {
                BlockPos temp = pos.func_177967_a(facing, scanner);
                if (!world.func_175623_d(temp) && world.func_175625_s(temp) instanceof IVaultWall) {
                    if (facing.func_176745_a() % 2 == 0) {
                        int n = facing.func_176745_a();
                        base[n] = base[n] - scanner;
                    } else {
                        int n = facing.func_176745_a();
                        base[n] = base[n] + scanner;
                    }
                    scanner = 0;
                    continue block0;
                }
                scanner = (byte)(scanner + 1);
            }
        }
        int minY = base[0];
        int maxY = base[1];
        int minZ = base[2];
        int maxZ = base[3];
        int minX = base[4];
        int maxX = base[5];
        boolean valid = true;
        String message = "";
        if (minX == pos.func_177958_n() || maxX == pos.func_177958_n() || minY == pos.func_177956_o() || maxY == pos.func_177956_o() || minZ == pos.func_177952_p() || maxZ == pos.func_177952_p()) {
            valid = false;
        } else {
            byte sX = (byte)(maxX - minX);
            byte sY = (byte)(maxY - minY);
            byte sZ = (byte)(maxZ - minZ);
            if (sX < 3 || sY < 3 || sZ < 3 || sX > 15 || sY > 15 || sZ > 15) {
                valid = false;
            }
        }
        if (!valid) {
            message = Localization.get((String)"error.multistorage.vault.size.msg");
        }
        BuildError error = BuildError.NONE;
        if (valid) {
            for (cX = minX; cX <= maxX; ++cX) {
                for (int cZ = minZ; cZ <= maxZ; ++cZ) {
                    error = VaultHelper.isUsableAsWall(world.func_175625_s(new BlockPos(cX, minY, cZ)), owner);
                    if (error == BuildError.NONE) {
                        error = VaultHelper.isUsableAsWall(world.func_175625_s(new BlockPos(cX, maxY, cZ)), owner);
                        if (error == BuildError.NONE) continue;
                        message = Localization.get((String)"error.multistorage.vault.ceiling.msg");
                        valid = false;
                        continue;
                    }
                    message = Localization.get((String)"error.multistorage.vault.floor.msg");
                    valid = false;
                }
            }
        }
        if (valid) {
            for (cX = minX; cX <= maxX; ++cX) {
                for (cY = minY; cY <= maxY; ++cY) {
                    error = VaultHelper.isUsableAsWall(world.func_175625_s(new BlockPos(cX, cY, minZ)), owner);
                    if (error == BuildError.NONE) {
                        error = VaultHelper.isUsableAsWall(world.func_175625_s(new BlockPos(cX, cY, maxZ)), owner);
                        if (error == BuildError.NONE) continue;
                        message = Localization.get((String)"error.multistorage.vault.south.msg");
                        valid = false;
                        continue;
                    }
                    message = Localization.get((String)"error.multistorage.vault.north.msg");
                    valid = false;
                }
            }
        }
        if (valid) {
            for (int cZ = minZ; cZ <= maxZ; ++cZ) {
                for (cY = minY; cY <= maxY; ++cY) {
                    error = VaultHelper.isUsableAsWall(world.func_175625_s(new BlockPos(minX, cY, cZ)), owner);
                    if (error == BuildError.NONE) {
                        error = VaultHelper.isUsableAsWall(world.func_175625_s(new BlockPos(maxX, cY, cZ)), owner);
                        if (error == BuildError.NONE) continue;
                        message = Localization.get((String)"error.multistorage.vault.east.msg");
                        valid = false;
                        continue;
                    }
                    message = Localization.get((String)"error.multistorage.vault.west.msg");
                    valid = false;
                }
            }
        }
        if (valid) {
            doorTile.vaultSize = minX + ":" + minY + ":" + minZ + ":" + maxX + ":" + maxY + ":" + maxZ;
            doorTile.vaultName = vaultName;
            VaultHelper.setBlockData(doorTile, owner, doorPoint, false, false);
            message = Localization.get((String)"command.multistorage.vault.complete.msg");
            VaultHelper.vaultLog(doorTile, VaultHelper.getUserDisplayId(player.func_70005_c_(), owner), message, true);
            return true;
        }
        if (error == BuildError.DOOR) {
            message = Localization.get((String)"error.multistorage.vault.hidedoor.msg");
        }
        if (world.field_72995_K) {
            Localization.addChat((EntityPlayer)player, (String)message);
        }
        return false;
    }

    private static BuildError isUsableAsWall(TileEntity tile, UUID owner) {
        if (tile instanceof IVaultWall) {
            TileEntityVaultDoor doorTile;
            if (tile instanceof TileEntityVaultDoor && (doorTile = (TileEntityVaultDoor)tile).isActive() && !doorTile.vaultAccess.getOwnerId().equals(owner)) {
                return BuildError.DOOR;
            }
            return BuildError.NONE;
        }
        return BuildError.WALL;
    }

    private static boolean isUsableAsFrame(TileEntity tile) {
        return tile instanceof IVaultWall && !(tile instanceof TileEntityVaultDoor) && !(tile instanceof TileEntityVaultGlass);
    }

    public static void doorBlocks(World world, BlockPos pos, TileEntityVaultDoor doorTile, boolean remove) {
        int size = doorTile.vaultDoorType == TileEntityVaultDoor.EnumDoorPart.CONTROLLER_3X ? 3 : (doorTile.vaultDoorType == TileEntityVaultDoor.EnumDoorPart.CONTROLLER_2X ? 2 : 0);
        byte doorSection = 1;
        for (int sy = 0; sy < size; sy = (int)((byte)(sy + 1))) {
            for (int sxz = 0; sxz < size; sxz = (int)((byte)(sxz + 1))) {
                byte mapValue;
                byte by = mapValue = size == 2 ? doorMap2x[sy + 1][sxz + 1] : doorMap3x[sy + 1][sxz + 1];
                if (mapValue == 1) continue;
                BlockPos sPos = pos;
                if (mapValue == 0) {
                    switch (doorTile.direction) {
                        case SOUTH: {
                            sPos = pos.func_177982_a(-sxz, sy, 0);
                            break;
                        }
                        case WEST: {
                            sPos = pos.func_177982_a(0, sy, -sxz);
                            break;
                        }
                        case NORTH: {
                            sPos = pos.func_177982_a(sxz, sy, 0);
                            break;
                        }
                        case EAST: {
                            sPos = pos.func_177982_a(0, sy, sxz);
                        }
                    }
                }
                if (remove) {
                    VaultHelper.removeDoorBlock(world, sPos);
                    continue;
                }
                if (mapValue != 0) continue;
                VaultHelper.setDoorBlock(world, sPos, doorTile, doorSection);
                doorSection = (byte)(doorSection + 1);
            }
        }
    }

    private static void setDoorBlock(World world, BlockPos pos, TileEntityVaultDoor baseTile, byte doorSection) {
        Function.setBlock((World)world, (BlockPos)pos, (IBlockState)Values.blockVault.func_176223_P().func_177226_a(BlockVault.VARIANT, (Comparable)((Object)BlockVault.EnumType.DOOR)), (boolean)true);
        TileEntityVaultDoor doorTile = (TileEntityVaultDoor)world.func_175625_s(pos);
        doorTile.direction = baseTile.direction;
        doorTile.vaultDoorType = TileEntityVaultDoor.EnumDoorPart.FILLER;
        doorTile.location = baseTile.location;
        doorTile.doorSection = doorSection;
    }

    private static void removeDoorBlock(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            VaultHelper.removeDoorBlock(tile);
        } else {
            Function.removeBlock((World)world, (BlockPos)pos, (boolean)true);
        }
    }

    static void removeDoorBlock(TileEntity tile) {
        if (tile != null) {
            if (tile instanceof TileEntityVaultDoor) {
                ((TileEntityVaultDoor)tile).vaultDoorType = TileEntityVaultDoor.EnumDoorPart.NOTSET;
            }
            Function.removeBlock((World)tile.func_145831_w(), (BlockPos)tile.func_174877_v(), (boolean)true);
        }
    }

    private static TileEntity getTile(World world, BlockPos pos, boolean repair) {
        TileEntity tile = world.func_175625_s(pos);
        if (repair && !(tile instanceof IVaultWall)) {
            Function.setBlock((World)world, (BlockPos)pos, (IBlockState)Values.blockVault.func_176223_P().func_177226_a(BlockVault.VARIANT, (Comparable)((Object)BlockVault.EnumType.WALL_NORMAL)), (boolean)true);
            tile = world.func_175625_s(pos);
        }
        return tile;
    }

    private static void setBlockData(TileEntityVaultDoor doorTile, UUID owner, BlockPos doorPoint, boolean remove, boolean repair) {
        int checkY;
        TileEntity blockTile;
        int checkX;
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX;
        String[] points = doorTile.vaultSize.split(":");
        try {
            minX = Integer.parseInt(points[0]);
            minY = Integer.parseInt(points[1]);
            minZ = Integer.parseInt(points[2]);
            maxX = Integer.parseInt(points[3]);
            maxY = Integer.parseInt(points[4]);
            maxZ = Integer.parseInt(points[5]);
        }
        catch (Exception ignored) {
            VaultHelper.removeDoorBlock((TileEntity)doorTile);
            Values.logMultiStorage.error("Vault Door at " + doorTile.func_174877_v() + " is corrupted, and will be removed");
            return;
        }
        for (checkX = minX; checkX <= maxX; ++checkX) {
            for (int checkZ = minZ; checkZ <= maxZ; ++checkZ) {
                blockTile = VaultHelper.getTile(doorTile.func_145831_w(), new BlockPos(checkX, minY, checkZ), repair);
                if (blockTile instanceof IVaultWall) {
                    VaultHelper.setVaultOwner(blockTile, doorPoint, owner, remove);
                }
                if (!((blockTile = VaultHelper.getTile(doorTile.func_145831_w(), new BlockPos(checkX, maxY, checkZ), repair)) instanceof IVaultWall)) continue;
                VaultHelper.setVaultOwner(blockTile, doorPoint, owner, remove);
            }
        }
        for (checkX = minX; checkX <= maxX; ++checkX) {
            for (checkY = minY; checkY <= maxY; ++checkY) {
                blockTile = VaultHelper.getTile(doorTile.func_145831_w(), new BlockPos(checkX, checkY, minZ), repair);
                if (blockTile instanceof IVaultWall) {
                    VaultHelper.setVaultOwner(blockTile, doorPoint, owner, remove);
                }
                if (!((blockTile = VaultHelper.getTile(doorTile.func_145831_w(), new BlockPos(checkX, checkY, maxZ), repair)) instanceof IVaultWall)) continue;
                VaultHelper.setVaultOwner(blockTile, doorPoint, owner, remove);
            }
        }
        for (int checkZ = minZ; checkZ <= maxZ; ++checkZ) {
            for (checkY = minY; checkY <= maxY; ++checkY) {
                blockTile = VaultHelper.getTile(doorTile.func_145831_w(), new BlockPos(minX, checkY, checkZ), repair);
                if (blockTile instanceof IVaultWall) {
                    VaultHelper.setVaultOwner(blockTile, doorPoint, owner, remove);
                }
                if (!((blockTile = VaultHelper.getTile(doorTile.func_145831_w(), new BlockPos(maxX, checkY, checkZ), repair)) instanceof IVaultWall)) continue;
                VaultHelper.setVaultOwner(blockTile, doorPoint, owner, remove);
            }
        }
    }

    private static void setVaultOwner(TileEntity tile, BlockPos door, UUID uuid, boolean remove) {
        if (uuid != null && tile instanceof TileEntityVaultDoor && ((TileEntityVaultDoor)tile).vaultAccess.getOwnerName().equals("NoOwner")) {
            ((TileEntityVaultDoor)tile).vaultAccess.setOwner(uuid);
        }
        if (!remove) {
            ((IVaultWall)tile).addDoor(door);
        } else {
            ((IVaultWall)tile).removeDoor(door);
        }
        Function.syncTile((TileEntity)tile);
    }

    public static void processAction(EnumAction action, BlockPos pos, EntityPlayer player, String info) {
        if (action == null) {
            return;
        }
        TileEntity tileEntity = player.func_130014_f_().func_175625_s(pos);
        if (!(tileEntity instanceof TileEntityVaultDoor)) {
            return;
        }
        TileEntityVaultDoor door = (TileEntityVaultDoor)tileEntity;
        if (door.func_174877_v() != door.location) {
            tileEntity = player.func_130014_f_().func_175625_s(pos);
            if (!(tileEntity instanceof TileEntityVaultDoor)) {
                return;
            }
            door = (TileEntityVaultDoor)tileEntity;
        }
        if (!door.vaultAccess.canEditVault(player)) {
            Localization.addChat((EntityPlayer)player, (String)Localization.get((String)"notice.multistorage.noedit.txt"));
            return;
        }
        if (!door.vaultAccess.hasFullAccess(player) && action != EnumAction.ADDUSER && action != EnumAction.REMOVEUSER) {
            Localization.addChat((EntityPlayer)player, (String)Localization.get((String)"notice.multistorage.owneronly.txt"));
            return;
        }
        if (!VaultHelper.processVaultAction(action, door, player, info)) {
            UUID uuid = null;
            String username = info;
            if (info.startsWith("!>>")) {
                String[] split = info.split(">>");
                username = split[1];
                uuid = UUIDHelper.stringToUUID(split[2]);
            } else if (!Strings.isNullOrEmpty((String)info)) {
                uuid = UUIDHelper.getCachedUUID(info);
                if (uuid == null && info.length() == 36) {
                    uuid = UUIDHelper.stringToUUID(info);
                    username = "";
                }
                if (uuid == null) {
                    uuid = UUIDHelper.getOfflineUUID(info);
                    username = info;
                }
            }
            if (uuid == null) {
                Localization.addChat((EntityPlayer)player, (String)Localization.get((String)"notice.multistorage.noplayer.txt"));
            } else {
                VaultHelper.processUserAction(action, door, player, uuid, username);
            }
        }
    }

    private static boolean processVaultAction(EnumAction action, TileEntityVaultDoor door, EntityPlayer player, String info) {
        String message;
        switch (action) {
            case REMOVEDOOR: {
                ItemStack vaultDoor;
                if (door.isMultiVaultUse()) {
                    Localization.addChat((EntityPlayer)player, (String)Localization.get((String)"notice.multistorage.inuse.txt"));
                    return true;
                }
                VaultHelper.setBlockData(door, null, door.location, true, false);
                VaultHelper.doorBlocks(door.func_145831_w(), door.func_174877_v(), door, true);
                String vaultName = door.vaultName.trim();
                message = Localization.get((String)"notice.multistorage.vault.removedoor.txt");
                message = message + " -- " + Localization.get((String)"notice.multistorage.vault.reason.txt");
                message = message + ": " + info;
                message = message + "\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n";
                if (!(player instanceof EntityPlayerMP) || player.field_71075_bZ.field_75098_d || (vaultDoor = Values.stacks.get("vaultdoor", new int[0])) == null) break;
                if (!vaultName.isEmpty() && !vaultName.equals("null")) {
                    vaultDoor.func_151001_c(vaultName);
                    vaultDoor.func_82841_c(-4);
                }
                Function.dropItem((World)door.func_145831_w(), (BlockPos)door.func_174877_v(), (ItemStack)vaultDoor);
                break;
            }
            case WHITELIST: {
                boolean whitelist;
                try {
                    whitelist = Boolean.getBoolean(info);
                }
                catch (Exception ignored) {
                    whitelist = !door.vaultAccess.isWhitelist();
                }
                door.vaultAccess.setWhitelist(whitelist);
                message = Localization.get((String)"notice.multistorage.vault.listtype.txt") + " " + Localization.get((String)("info.multistorage.vault." + (whitelist ? "white" : "black") + ".txt"));
                break;
            }
            case DEFENCE: {
                int defence = 0;
                try {
                    defence = Integer.parseInt(info);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                door.vaultAccess.setDefence(defence);
                message = Localization.get((String)("notice.multistorage.vault.defence." + (defence == 0 ? "kill" : (defence > 0 ? "kick" : "off")) + ".txt"));
                break;
            }
            default: {
                return false;
            }
        }
        Function.syncTile((TileEntity)door);
        VaultHelper.vaultLog(door, player, message, false);
        return true;
    }

    private static void processUserAction(EnumAction action, TileEntityVaultDoor door, EntityPlayer player, UUID uuid, String username) {
        String message = "";
        switch (action) {
            case ADDUSER: {
                door.vaultAccess.add(uuid, username);
                if (!Configuration.SETTINGS.VAULT.LOGS.logAdded) break;
                message = VaultHelper.getUserDisplayId(username, uuid) + " " + Localization.get((String)"notice.multistorage.vault.added.txt");
                break;
            }
            case REMOVEUSER: {
                door.vaultAccess.remove(uuid);
                if (!Configuration.SETTINGS.VAULT.LOGS.logRemoved) break;
                message = VaultHelper.getUserDisplayId(username, uuid) + " " + Localization.get((String)"notice.multistorage.vault.removed.txt");
                break;
            }
            case SETOWNER: {
                door.vaultAccess.setOwner(uuid);
                message = VaultHelper.getUserDisplayId(username, uuid) + " " + Localization.get((String)"notice.multistorage.vault.setowner.txt");
                break;
            }
            case ADDSUPERUSER: {
                door.vaultAccess.makeSuperUser(uuid);
                if (!Configuration.SETTINGS.VAULT.LOGS.logPromoted) break;
                message = VaultHelper.getUserDisplayId(username, uuid) + " " + Localization.get((String)"notice.multistorage.vault.promote.txt");
                break;
            }
            case REMOVESUPERUSER: {
                door.vaultAccess.revokeSuperUser(uuid);
                if (!Configuration.SETTINGS.VAULT.LOGS.logDemoted) break;
                message = VaultHelper.getUserDisplayId(username, uuid) + " " + Localization.get((String)"notice.multistorage.vault.demote.txt");
            }
        }
        Function.syncTile((TileEntity)door);
        VaultHelper.vaultLog(door, player, message, false);
    }

    private static String getUserDisplayId(String username, UUID uuid) {
        String sUUID = "";
        if (uuid == null) {
            uuid = UUIDHelper.getCachedUUID(username);
        }
        if (uuid != null) {
            sUUID = uuid.toString();
        }
        if (!Strings.isNullOrEmpty((String)sUUID)) {
            return username + "{" + sUUID.substring(0, 3) + "-" + sUUID.substring(sUUID.length() - 3, sUUID.length()) + "}";
        }
        return username + "{Offline}";
    }

    public static void vaultLog(TileEntityVaultDoor doorTile, EntityPlayer player, String message, boolean newVault) {
        VaultHelper.vaultLog(doorTile, VaultHelper.getUserDisplayId(player.func_70005_c_(), player.func_110124_au()), message, newVault);
    }

    private static void vaultLog(TileEntityVaultDoor doorTile, String username, String message, boolean newVault) {
        if (Configuration.SETTINGS.VAULT.LOGS.logFileSize > -1 && !Strings.isNullOrEmpty((String)message) && !doorTile.func_145831_w().field_72995_K) {
            File saveFile = VaultHelper.getSaveFile(doorTile.func_145831_w(), doorTile.location, doorTile.vaultName);
            try {
                FileWriter writer = new FileWriter(saveFile, true);
                String timeStamp = new SimpleDateFormat("yy/MM/dd HH:mm:ss").format(Calendar.getInstance().getTime());
                String stringOutput = "[" + timeStamp + "] " + username + " : " + message;
                if (!newVault) {
                    writer.write("\n");
                }
                writer.write(stringOutput);
                writer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static File getSaveFile(World world, BlockPos pos, String vaultName) {
        String saveDir;
        File saveFile;
        String filename = pos.func_177958_n() + ":" + pos.func_177956_o() + ":" + pos.func_177952_p() + ":" + world.field_73011_w.getDimension();
        filename = filename.replace(":", ",");
        if (!Strings.isNullOrEmpty((String)vaultName)) {
            filename = filename + " [" + vaultName + "]";
        }
        if (!(saveFile = new File(saveDir = MultiStorage.proxy.getSaveDir(world, Values.minecraftDir) + "/VaultLogs/")).exists()) {
            saveFile.mkdirs();
        }
        if ((saveFile = new File(saveDir, filename + ".txt")).exists() && Configuration.SETTINGS.VAULT.LOGS.logFileSize > 0 && (double)saveFile.length() / 1024.0 > (double)Configuration.SETTINGS.VAULT.LOGS.logFileSize) {
            File backupFile;
            int count = 0;
            do {
                backupFile = new File(saveDir, filename + "_old" + count + ".txt");
                ++count;
            } while (backupFile.exists());
            saveFile.renameTo(backupFile);
            saveFile.delete();
        }
        if (!saveFile.exists()) {
            try {
                saveFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return saveFile;
    }

    private static enum BuildError {
        NONE,
        WALL,
        DOOR;

    }

    public static enum EnumAction {
        REMOVEDOOR(0),
        ADDUSER(1),
        REMOVEUSER(2),
        SETOWNER(3),
        ADDSUPERUSER(4),
        REMOVESUPERUSER(5),
        WHITELIST(6),
        DEFENCE(7);

        private static final EnumAction[] array;
        private final byte value;

        private EnumAction(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }

        public static EnumAction byValue(int value) {
            return value > -1 && value < 8 ? array[value] : null;
        }

        static {
            array = new EnumAction[8];
            EnumAction[] enumActionArray = EnumAction.values();
            int n = enumActionArray.length;
            for (int i = 0; i < n; ++i) {
                EnumAction value;
                EnumAction.array[value.getValue()] = value = enumActionArray[i];
            }
        }
    }
}

