/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage;

import net.minecraft.block.Block;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import shetiphian.core.common.RegistryHelper;
import shetiphian.multistorage.Configuration;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.block.BlockEnderLinkChest;
import shetiphian.multistorage.common.block.BlockStoneStorage;
import shetiphian.multistorage.common.block.BlockVault;
import shetiphian.multistorage.common.item.ItemBlockEnderLinkChest;
import shetiphian.multistorage.common.item.ItemBlockStorageType;
import shetiphian.multistorage.common.item.ItemBlockVault;
import shetiphian.multistorage.common.item.ItemEnderBag;
import shetiphian.multistorage.common.misc.FluidConcrete;
import shetiphian.multistorage.common.tileentity.TileEntityChameleon;
import shetiphian.multistorage.common.tileentity.TileEntityChameleonDense;
import shetiphian.multistorage.common.tileentity.TileEntityEnderLinkChest;
import shetiphian.multistorage.common.tileentity.TileEntityJunkbox;
import shetiphian.multistorage.common.tileentity.TileEntityJunkboxDense;
import shetiphian.multistorage.common.tileentity.TileEntityQueue;
import shetiphian.multistorage.common.tileentity.TileEntityQueueDense;
import shetiphian.multistorage.common.tileentity.TileEntityStackingChest;
import shetiphian.multistorage.common.tileentity.TileEntityStackingChestDense;
import shetiphian.multistorage.common.tileentity.TileEntityVaultBase;
import shetiphian.multistorage.common.tileentity.TileEntityVaultBroken;
import shetiphian.multistorage.common.tileentity.TileEntityVaultCorer;
import shetiphian.multistorage.common.tileentity.TileEntityVaultDoor;
import shetiphian.multistorage.common.tileentity.TileEntityVaultGlass;
import shetiphian.multistorage.common.tileentity.TileEntityVaultItem;
import shetiphian.multistorage.common.tileentity.TileEntityVaultPower;
import shetiphian.multistorage.common.tileentity.TileEntityVaultRedstone;
import shetiphian.multistorage.common.tileentity.TileEntityVaultTank;

public class Registry {
    static Registry INSTANCE = new Registry();

    void registerBlocks(IForgeRegistry<Block> registry) {
        if (Configuration.BLOCKS.addVaultBlocks) {
            RegistryHelper.register(registry, (Block)new BlockVault(), (String)"multistorage:vault", (String)"multistorage.vault");
            RegistryHelper.register(TileEntityVaultBase.class, (String)"multistorage:vault.base");
            RegistryHelper.register(TileEntityVaultDoor.class, (String)"multistorage:vault.door");
            RegistryHelper.register(TileEntityVaultItem.class, (String)"multistorage:vault.item");
            RegistryHelper.register(TileEntityVaultRedstone.class, (String)"multistorage:vault.redstone");
            RegistryHelper.register(TileEntityVaultTank.class, (String)"multistorage:vault.tank");
            RegistryHelper.register(TileEntityVaultPower.class, (String)"multistorage:vault.power");
            RegistryHelper.register(TileEntityVaultGlass.class, (String)"multistorage:vault.glass");
            RegistryHelper.register(TileEntityVaultBroken.class, (String)"multistorage:vault.broken");
            RegistryHelper.register(TileEntityVaultCorer.class, (String)"multistorage:vault.corer");
        }
        if (Configuration.BLOCKS.addStorageBlocks) {
            RegistryHelper.register(registry, (Block)new BlockStoneStorage(), (String)"multistorage:stone_storage", (String)"multistorage.storage.stone");
            RegistryHelper.register(TileEntityStackingChest.class, (String)"multistorage:storage.stacking");
            RegistryHelper.register(TileEntityChameleon.class, (String)"multistorage:storage.hidden");
            RegistryHelper.register(TileEntityJunkbox.class, (String)"multistorage:storage.junkbox");
            RegistryHelper.register(TileEntityQueue.class, (String)"multistorage:storage.queue");
            RegistryHelper.register(TileEntityStackingChestDense.class, (String)"multistorage:storage.stacking_dense");
            RegistryHelper.register(TileEntityChameleonDense.class, (String)"multistorage:storage.hidden_dense");
            RegistryHelper.register(TileEntityJunkboxDense.class, (String)"multistorage:storage.junkbox_dense");
            RegistryHelper.register(TileEntityQueueDense.class, (String)"multistorage:storage.queue_dense");
        }
        if (Configuration.BLOCKS.addEnderLinkChests) {
            RegistryHelper.register(registry, (Block)new BlockEnderLinkChest(), (String)"multistorage:ender_chest", (String)"multistorage.enderchest");
            RegistryHelper.register(TileEntityEnderLinkChest.class, (String)"multistorage:ender_chest.chest");
        }
    }

    void registerItemBlocks(IForgeRegistry<Item> registry) {
        if (Configuration.BLOCKS.addVaultBlocks) {
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockVault(Values.blockVault));
        }
        if (Configuration.BLOCKS.addStorageBlocks) {
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockStorageType(Values.blockStoneStorage));
        }
        if (Configuration.BLOCKS.addEnderLinkChests) {
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockEnderLinkChest(Values.blockEnderLinkChest));
        }
    }

    void registerItems(IForgeRegistry<Item> registry) {
        if (Configuration.ITEMS.enableEnderBag || Configuration.ITEMS.enableEnderLinkBag || Configuration.BLOCKS.addEnderLinkChests) {
            RegistryHelper.register(registry, (Item)new ItemEnderBag(), (String)"multistorage:ender_bag", (String)"multistorage.enderbag");
        }
    }

    void doRegistration() {
        this.registerFluids();
        this.setTabIcon();
        this.registerCustomItemStacks();
    }

    private void registerFluids() {
        if (Configuration.BLOCKS.addVaultBlocks) {
            for (EnumDyeColor dyeColor : EnumDyeColor.values()) {
                FluidConcrete fluid = new FluidConcrete(dyeColor);
                if (!FluidRegistry.registerFluid((Fluid)fluid)) continue;
                FluidRegistry.addBucketForFluid((Fluid)fluid);
            }
            RegistryHelper.registerFluid((Fluid)new FluidConcrete(null));
        }
    }

    private void setTabIcon() {
        if (Values.blockStoneStorage != null) {
            Values.tabMultiStorage.setIcon(new ItemStack(Values.blockStoneStorage, 1, 1));
            return;
        }
        if (Values.blockVault != null) {
            Values.tabMultiStorage.setIcon(new ItemStack(Values.blockVault, 1, 0));
            return;
        }
        if (Values.blockEnderLinkChest != null) {
            Values.tabMultiStorage.setIcon(new ItemStack(Values.blockEnderLinkChest, 1, 0));
        }
    }

    private void registerCustomItemStacks() {
        Item item;
        if (Values.blockStoneStorage != null) {
            item = Item.func_150898_a((Block)Values.blockStoneStorage);
            Values.stacks.put("stone_upgrade", this.iStack(item, 0));
            Values.stacks.put("stone_stacking", this.iStack(item, 1));
            Values.stacks.put("stone_stacking_dense", this.iStack(item, 2));
            Values.stacks.put("stone_chameleon", this.iStack(item, 3));
            Values.stacks.put("stone_chameleon_dense", this.iStack(item, 4));
            Values.stacks.put("stone_junkbox", this.iStack(item, 5));
            Values.stacks.put("stone_junkbox_dense", this.iStack(item, 6));
            Values.stacks.put("stone_queue", this.iStack(item, 7));
            Values.stacks.put("stone_queue_dense", this.iStack(item, 8));
        }
        if (Values.blockEnderLinkChest != null) {
            item = Item.func_150898_a((Block)Values.blockEnderLinkChest);
            Values.stacks.put("enderchest", this.iStack(item, 0));
        }
        if (Values.blockVault != null) {
            item = Item.func_150898_a((Block)Values.blockVault);
            Values.stacks.put("vaultdoor", this.iStack(item, 0));
            Values.stacks.put("vaultcorer", this.iStack(item, 15));
            Values.stacks.put("vaultbucket", this.iStack(item, 100));
        }
        if (Values.itemEnderBag != null) {
            Values.stacks.put("enderlinkbag", this.iStack(Values.itemEnderBag, 0));
            Values.stacks.put("enderlinkbag_private", this.iStack(Values.itemEnderBag, 1));
            Values.stacks.put("enderbag", this.iStack(Values.itemEnderBag, 2));
        }
    }

    private ItemStack iStack(Item item, int metadata) {
        return new ItemStack(item, 1, metadata);
    }
}

