/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.worldgen;

import cd4017be.dimstack.api.util.BlockPredicate;
import cd4017be.dimstack.worldgen.OreGenBase;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.chunk.Chunk;

public class OreGenEven
extends OreGenBase {
    final int baseY;
    final int height;

    public OreGenEven(NBTTagCompound tag) {
        super(tag);
        this.baseY = tag.func_74765_d("minY");
        this.height = tag.func_74765_d("maxY") - this.baseY;
    }

    public OreGenEven(IBlockState state, int numB, float veins, BlockPredicate target, int minH, int maxH) {
        super(state, numB, veins, target);
        this.baseY = minH < maxH ? minH : maxH;
        this.height = minH < maxH ? maxH - minH : minH - maxH;
    }

    @Override
    public void generate(Chunk chunk, Random rand) {
        int x = chunk.field_76635_g << 4;
        int z = chunk.field_76647_h << 4;
        for (int n = this.veins(rand); n > 0; --n) {
            this.genOreVein(chunk.func_177412_p(), x + rand.nextInt(16), this.baseY + rand.nextInt(this.height), z + rand.nextInt(16), rand);
        }
    }

    @Override
    public NBTTagCompound writeNBT() {
        NBTTagCompound nbt = super.writeNBT();
        nbt.func_74777_a("minY", (short)this.baseY);
        nbt.func_74777_a("maxY", (short)(this.baseY + this.height));
        return nbt;
    }

    @Override
    public String getRegistryName() {
        return "even";
    }
}

