/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.worldgen;

import cd4017be.dimstack.api.TerrainGeneration;
import cd4017be.dimstack.api.gen.ITerrainGenerator;
import cd4017be.dimstack.api.util.BlockPredicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;

public class CaveGen
extends MapGenBase
implements ITerrainGenerator {
    public static final String ID = "caves";
    public int minY = 0;
    public int maxY = 256;
    public int fillY = 10;
    public int genChance = 37;
    public int count = 15;
    public int bigChance = 26;
    public float vertShape = 1.0f;
    public float thickness = 1.0f;
    public float bigScale = 0.0f;
    public float roomSize = 6.0f;
    public IBlockState setBlock;
    public IBlockState setFluid = this.setBlock = Blocks.field_150350_a.func_176223_P();
    public BlockPredicate replace = new BlockPredicate(new String[0]);

    @Override
    public String getRegistryName() {
        return ID;
    }

    public CaveGen readNBT(NBTTagCompound nbt) {
        this.field_75040_a = nbt.func_74771_c("size");
        this.minY = nbt.func_74771_c("minY") & 0xFF;
        this.maxY = (nbt.func_74771_c("maxY") & 0xFF) + 1;
        this.fillY = nbt.func_74771_c("fillY") & 0xFF;
        this.genChance = (nbt.func_74771_c("pGen") & 0xFF) + 1;
        this.bigChance = (nbt.func_74771_c("pSca") & 0xFF) + 1;
        this.count = nbt.func_74771_c("n") & 0xFF;
        this.vertShape = nbt.func_74760_g("shp");
        this.thickness = nbt.func_74760_g("rad");
        this.roomSize = nbt.func_74760_g("room");
        this.bigScale = nbt.func_74760_g("sca");
        this.setBlock = BlockPredicate.parse(nbt.func_74779_i("block"));
        this.setFluid = BlockPredicate.parse(nbt.func_74779_i("fluid"));
        this.replace = BlockPredicate.loadNBT(nbt.func_150295_c("repl", 8));
        return this;
    }

    @Override
    public NBTTagCompound writeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("size", (byte)this.field_75040_a);
        nbt.func_74774_a("minY", (byte)this.minY);
        nbt.func_74774_a("maxY", (byte)(this.maxY - 1));
        nbt.func_74774_a("fillY", (byte)this.fillY);
        nbt.func_74774_a("pGen", (byte)(this.genChance - 1));
        nbt.func_74774_a("pSca", (byte)(this.bigChance - 1));
        nbt.func_74774_a("n", (byte)this.count);
        nbt.func_74776_a("shp", this.vertShape);
        nbt.func_74776_a("rad", this.thickness);
        nbt.func_74776_a("room", this.roomSize);
        nbt.func_74776_a("sca", this.bigScale);
        nbt.func_74778_a("block", BlockPredicate.serialize(this.setBlock));
        nbt.func_74778_a("fluid", BlockPredicate.serialize(this.setFluid));
        nbt.func_74782_a("repl", (NBTBase)this.replace.writeNBT());
        return nbt;
    }

    @Override
    public void generate(World world, ChunkPrimer cp, int cx, int cz, TerrainGeneration cfg) {
        this.func_186125_a(world, cx, cz, cp);
    }

    protected void func_180701_a(World world, int cX, int cZ, int oX, int oZ, ChunkPrimer cp) {
        int n = this.field_75038_b.nextInt(this.field_75038_b.nextInt(this.field_75038_b.nextInt(this.count) + 1) + 1);
        if (this.field_75038_b.nextInt(256) >= this.genChance) {
            n = 0;
        }
        for (int j = 0; j < n; ++j) {
            double x = cX * 16 + this.field_75038_b.nextInt(16);
            double y = this.field_75038_b.nextInt(this.maxY - this.minY) + this.minY;
            double z = cZ * 16 + this.field_75038_b.nextInt(16);
            int k = 1;
            if (this.field_75038_b.nextInt(4) == 0) {
                this.addTunnel(this.field_75038_b.nextLong(), oX, oZ, cp, x, y, z, 1.0f + this.field_75038_b.nextFloat() * this.roomSize, 0.0f, 0.0f, -1, -1, 0.5);
                k += this.field_75038_b.nextInt(4);
            }
            for (int l = 0; l < k; ++l) {
                float a = this.field_75038_b.nextFloat() * ((float)Math.PI * 2);
                float f1 = (this.field_75038_b.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float f2 = (this.field_75038_b.nextFloat() * 2.0f + this.field_75038_b.nextFloat()) * this.thickness;
                if (this.field_75038_b.nextInt(256) >= this.bigChance) {
                    f2 *= this.field_75038_b.nextFloat() * this.field_75038_b.nextFloat() * this.bigScale + 1.0f;
                }
                this.addTunnel(this.field_75038_b.nextLong(), oX, oZ, cp, x, y, z, f2, a, f1, 0, 0, 1.0);
            }
        }
    }

    protected void addTunnel(long seed, int oX, int oZ, ChunkPrimer cp, double x, double y, double z, float radius, float yaw, float pitch, int segment, int segments, double vertShape) {
        boolean flag;
        double ox = oX * 16 + 8;
        double oz = oZ * 16 + 8;
        float f = 0.0f;
        float f1 = 0.0f;
        Random random = new Random(seed);
        if (segments <= 0) {
            int i = this.field_75040_a * 16 - 16;
            if (i <= 0) {
                i = 8;
            }
            segments = i - random.nextInt(i / 4);
        }
        boolean room = false;
        if (segment == -1) {
            segment = segments / 2;
            room = true;
        }
        int splitAt = random.nextInt(segments / 2) + segments / 4;
        boolean bl = flag = random.nextInt(6) == 0;
        while (segment < segments) {
            block21: {
                double sxz = 1.5 + (double)(MathHelper.func_76126_a((float)((float)segment * (float)Math.PI / (float)segments)) * radius);
                double sy = sxz * vertShape;
                float f2 = MathHelper.func_76134_b((float)pitch);
                float f3 = MathHelper.func_76126_a((float)pitch);
                x += (double)(MathHelper.func_76134_b((float)yaw) * f2);
                y += (double)f3;
                z += (double)(MathHelper.func_76126_a((float)yaw) * f2);
                pitch = flag ? (pitch *= 0.92f) : (pitch *= 0.7f);
                pitch += f1 * 0.1f;
                yaw += f * 0.1f;
                f1 *= 0.9f;
                f *= 0.75f;
                f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
                f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
                if (!room && segment == splitAt && radius > 1.0f) {
                    this.addTunnel(random.nextLong(), oX, oZ, cp, x, y, z, random.nextFloat() * 0.5f + 0.5f, yaw - 1.5707964f, pitch / 3.0f, segment, segments, 1.0);
                    this.addTunnel(random.nextLong(), oX, oZ, cp, x, y, z, random.nextFloat() * 0.5f + 0.5f, yaw + 1.5707964f, pitch / 3.0f, segment, segments, 1.0);
                    return;
                }
                if (room || random.nextInt(4) != 0) {
                    double dx = x - ox;
                    double dz = z - oz;
                    double remL = segments - segment;
                    double d = radius + 2.0f + 16.0f;
                    if (dx * dx + dz * dz > remL * remL + d * d) {
                        return;
                    }
                    d = 9.0 + sxz;
                    if (dx >= -d && dz >= -d && dx <= d && dz <= d) {
                        int bx;
                        int x0 = MathHelper.func_76128_c((double)(x - sxz)) - oX * 16 - 1;
                        int x1 = MathHelper.func_76128_c((double)(x + sxz)) - oX * 16 + 1;
                        int y0 = MathHelper.func_76128_c((double)(y - sy)) - 1;
                        int y1 = MathHelper.func_76128_c((double)(y + sy)) + 1;
                        int z0 = MathHelper.func_76128_c((double)(z - sxz)) - oZ * 16 - 1;
                        int z1 = MathHelper.func_76128_c((double)(z + sxz)) - oZ * 16 + 1;
                        if (x0 < 0) {
                            x0 = 0;
                        }
                        if (x1 > 16) {
                            x1 = 16;
                        }
                        if (y0 < this.minY + 1) {
                            y0 = this.minY + 1;
                        }
                        if (y1 > this.maxY - 8) {
                            y1 = this.maxY - 8;
                        }
                        if (z0 < 0) {
                            z0 = 0;
                        }
                        if (z1 > 16) {
                            z1 = 16;
                        }
                        for (bx = x0; bx < x1; ++bx) {
                            for (int bz = z0; bz < z1; ++bz) {
                                for (int by = y1 + 1; by >= y0 - 1; --by) {
                                    if (by < this.minY || by >= this.maxY) continue;
                                    if (!this.isLiquid(cp, bx, by, bz, oX, oZ)) {
                                        if (by == y0 - 1 || bx == x0 || bx == x1 - 1 || bz == z0 || bz == z1 - 1) continue;
                                        by = y0;
                                        continue;
                                    }
                                    break block21;
                                }
                            }
                        }
                        dx += 8.0;
                        dz += 8.0;
                        for (bx = x0; bx < x1; ++bx) {
                            double rx = ((double)bx + 0.5 - dx) / sxz;
                            for (int bz = z0; bz < z1; ++bz) {
                                double rz = ((double)bz + 0.5 - dz) / sxz;
                                boolean top = false;
                                if (!(rx * rx + rz * rz < 1.0)) continue;
                                for (int by = y1; by > y0; --by) {
                                    double ry = ((double)by - 0.5 - y) / sy;
                                    if (!(ry > -0.7) || !(rx * rx + ry * ry + rz * rz < 1.0)) continue;
                                    top = this.digBlock(cp, bx, by, bz, oX, oZ, top);
                                }
                            }
                        }
                        if (room) break;
                    }
                }
            }
            ++segment;
        }
    }

    protected boolean isLiquid(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ) {
        Block block = data.func_177856_a(x, y, z).func_177230_c();
        if (y <= this.fillY && block == this.setFluid.func_177230_c()) {
            return false;
        }
        return block == Blocks.field_150358_i || block == Blocks.field_150355_j || block == Blocks.field_150356_k || block == Blocks.field_150353_l;
    }

    private boolean isExceptionBiome(Biome biome) {
        if (biome == Biomes.field_76787_r) {
            return true;
        }
        if (biome == Biomes.field_76769_d) {
            return true;
        }
        return biome == Biomes.field_76778_j;
    }

    protected boolean digBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ, boolean foundTop) {
        IBlockState state = data.func_177856_a(x, y, z);
        Block block = state.func_177230_c();
        Biome biome = this.field_75039_c.func_180494_b(new BlockPos(x + chunkX * 16, 0, z + chunkZ * 16));
        Block top = biome.field_76752_A.func_177230_c();
        Block filler = biome.field_76753_B.func_177230_c();
        if (!foundTop) {
            boolean bl = this.isExceptionBiome(biome) ? block == Blocks.field_150349_c : (foundTop = block == top);
        }
        if (this.replace.test(state) || block == top || block == filler) {
            if (y <= this.fillY) {
                data.func_177855_a(x, y, z, this.setFluid);
            } else {
                data.func_177855_a(x, y, z, this.setBlock);
                if (foundTop && data.func_177856_a(x, y - 1, z).func_177230_c() == filler) {
                    data.func_177855_a(x, y - 1, z, top.func_176223_P());
                }
            }
        }
        return foundTop;
    }
}

