/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.util;

import cd4017be.dimstack.Main;
import cd4017be.dimstack.api.IDimension;
import cd4017be.dimstack.api.IDimensionSettings;
import cd4017be.dimstack.api.TerrainGeneration;
import cd4017be.dimstack.core.Dimensionstack;
import cd4017be.dimstack.util.PostGenChunkBuffer;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.world.World;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;

public class DebugInfo
implements IDimensionSettings {
    private boolean chunksGenerated = false;
    private boolean initialized = false;
    private boolean logged = false;

    public NBTBase serializeNBT() {
        return new NBTTagByte((byte)(this.chunksGenerated ? 1 : 0));
    }

    public void deserializeNBT(NBTBase nbt) {
        byte state = ((NBTPrimitive)nbt).func_150290_f();
        this.chunksGenerated = (state & 1) != 0;
    }

    public void setGenerated() {
        if (!this.chunksGenerated) {
            this.chunksGenerated = true;
            Dimensionstack.markDirty();
        }
    }

    public void setInitialized() {
        this.initialized = true;
    }

    public void genTerrainLate(IDimension dim, IChunkGenerator gen, World world, int cx, int cz) {
        this.fixInitialization(dim, world, gen);
        TerrainGeneration tg = dim.getSettings(TerrainGeneration.class, false);
        if (tg == null || this.chunksGenerated) {
            return;
        }
        if (!this.logged) {
            Main.LOG.fatal("The chunk generator {} doesn't trigger {} when generating chunks!\nPlease report this issue to the mod author of the above mentionied ChunkGenerator.", (Object)gen.getClass().getName(), (Object)ChunkGeneratorEvent.ReplaceBiomeBlocks.class.getName());
            Main.LOG.warn("Switching to inefficient terrain generation during chunk population.");
            this.logged = true;
        }
        tg.generate(world, gen, PostGenChunkBuffer.wrap(world.func_72964_e(cx, cz)), cx, cz);
    }

    public void fixInitialization(IDimension dim, World world, IChunkGenerator gen) {
        if (!this.initialized) {
            Main.LOG.fatal("The chunk generator {} did not trigger {} during initialization!\nPlease report this issue to the mod author of the above mentionied ChunkGenerator.", (Object)gen.getClass().getName(), (Object)InitNoiseGensEvent.class.getName());
            Main.proxy.worldgenTerrain.init((InitNoiseGensEvent<InitNoiseGensEvent.Context>)new InitNoiseGensEvent(world, new Random(), new InitNoiseGensEvent.Context(null, null, null, null, null)));
            Main.LOG.warn("Could not provide native noise fields and RNG for dimension {}!\nTerrain features that depend on these won't work correctly.", (Object)dim);
            this.initialized = true;
        }
    }
}

