/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.core;

import cd4017be.api.recipes.RecipeAPI;
import cd4017be.api.recipes.RecipeScriptContext;
import cd4017be.dimstack.ClientProxy;
import cd4017be.dimstack.Main;
import cd4017be.dimstack.Objects;
import cd4017be.dimstack.api.API;
import cd4017be.dimstack.api.CustomWorldProps;
import cd4017be.dimstack.api.IDimension;
import cd4017be.dimstack.api.IDimensionSettings;
import cd4017be.dimstack.api.util.ICfgButtonHandler;
import cd4017be.dimstack.api.util.SettingProvider;
import cd4017be.dimstack.core.PortalConfiguration;
import cd4017be.dimstack.worldgen.OreGenHandler;
import cd4017be.lib.Lib;
import cd4017be.lib.script.Parameters;
import cd4017be.lib.script.obj.Error;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Nil;
import cd4017be.lib.script.obj.Number;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkHandshakeEstablished;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Dimensionstack
extends API
implements RecipeAPI.IRecipeHandler {
    private static String DIMENSION_STACK = "dimstack";
    private static String DIMENSION = "dimension";
    private static String CHANNEL = "dimstack";
    public static final int FILE_VERSION = 4;
    private NBTTagCompound defaultCfg;
    private File cfgFile;
    private static boolean cfgModified;
    private final FMLEventChannel networkChannel;

    public Dimensionstack() {
        API.INSTANCE = this;
        RecipeAPI.Handlers.put(DIMENSION_STACK, this);
        RecipeAPI.Handlers.put(DIMENSION, this);
        this.networkChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNEL);
        this.networkChannel.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public IDimension getDim(int id) {
        return PortalConfiguration.get(id);
    }

    public static void markDirty() {
        cfgModified = true;
    }

    public void cleanup() {
        IntArrayList open = new IntArrayList();
        for (PortalConfiguration pc : PortalConfiguration.dimensions.values()) {
            pc.loadedChunks.clear();
            if (pc.loadingTicket != null) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)pc.loadingTicket);
                pc.loadingTicket = null;
            }
            if (!pc.topOpen) continue;
            open.add(pc.dimId);
        }
        if (cfgModified && this.cfgFile != null) {
            try {
                NBTTagCompound data = CompressedStreamTools.func_74797_a((File)this.cfgFile);
                Dimensionstack.save(data, false);
                data.func_74783_a("topOpen", open.toIntArray());
                CompressedStreamTools.func_74795_b((NBTTagCompound)data, (File)this.cfgFile);
                Main.LOG.info("updated dimension stack configuration file");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean canCreateDim(int id) {
        return !DimensionManager.isDimensionRegistered((int)id) || DimensionManager.getProviderType((int)id) == Objects.CUSTOM_DIM_TYPE;
    }

    public static boolean isDimCreated(int id) {
        return DimensionManager.isDimensionRegistered((int)id) && DimensionManager.getProviderType((int)id) == Objects.CUSTOM_DIM_TYPE;
    }

    public static void setDimCreation(int id, boolean create) {
        if (!DimensionManager.isDimensionRegistered((int)id)) {
            if (create) {
                DimensionManager.registerDimension((int)id, (DimensionType)Objects.CUSTOM_DIM_TYPE);
            }
            return;
        }
        DimensionType registered = DimensionManager.getProviderType((int)id);
        if (registered == Objects.CUSTOM_DIM_TYPE) {
            if (!create) {
                DimensionManager.unregisterDimension((int)id);
            }
        } else if (create) {
            Main.LOG.fatal("Can't register custom WorldProvider for dimension {} because this id is already occupied by {}", (Object)id, (Object)registered.func_186065_b());
        }
    }

    private static void loadSettings(SettingProvider sp, NBTTagCompound cfg) {
        if (sp instanceof PortalConfiguration) {
            PortalConfiguration pc = (PortalConfiguration)sp;
            int y = cfg.func_74771_c("ceil") & 0xFF;
            pc.ceilY = y > 0 ? y : 255;
            pc.flipped = cfg.func_74767_n("flip");
            Dimensionstack.setDimCreation(pc.dimId, cfg.func_74767_n("create"));
        }
        for (String key : cfg.func_150296_c()) {
            if (key.indexOf(46) < 0) continue;
            try {
                Class<?> c = Class.forName(key);
                if (IDimensionSettings.class.isAssignableFrom(c)) {
                    Object setting = sp.getSettings(c, true);
                    if (setting == null) continue;
                    setting.deserializeNBT(cfg.func_74781_a(key));
                    continue;
                }
                Main.LOG.warn("Can't load entry for dimension {}: Invalid class {} doesn't implement IDimensionSettings", (Object)sp, (Object)key);
            }
            catch (ClassNotFoundException e) {
                Main.LOG.warn("Can't load entry for dimension {}: Class {} not found!", (Object)sp, (Object)key);
            }
        }
    }

    private static NBTTagCompound saveSettings(SettingProvider sp, boolean client) {
        NBTTagCompound cfg = new NBTTagCompound();
        if (sp instanceof PortalConfiguration) {
            PortalConfiguration pc = (PortalConfiguration)sp;
            cfg.func_74774_a("ceil", (byte)pc.ceilY);
            cfg.func_74757_a("flip", pc.flipped);
            cfg.func_74757_a("create", Dimensionstack.isDimCreated(pc.dimId));
        }
        for (IDimensionSettings s : sp.getAllSettings()) {
            NBTBase tag;
            if (client && !s.isClientRelevant() || (tag = s.serializeNBT()) == null || tag.func_82582_d()) continue;
            cfg.func_74782_a(s.getClass().getName(), tag);
        }
        return cfg;
    }

    public static void load(NBTTagCompound nbt) {
        PortalConfiguration.dimensions.clear();
        NBTTagList stacks = nbt.func_150295_c("stacks", 11);
        for (NBTBase tag : stacks) {
            PortalConfiguration.link(((NBTTagIntArray)tag).func_150302_c());
        }
        for (Object dim : (Iterator)nbt.func_74759_k("topOpen")) {
            PortalConfiguration pc = PortalConfiguration.get((int)dim);
            if (pc.up() == null) continue;
            pc.topOpen = true;
        }
        INSTANCE.getAllSettings().clear();
        for (String key : nbt.func_150296_c()) {
            try {
                API sp;
                SettingProvider settingProvider = sp = key.equals("global") ? INSTANCE : PortalConfiguration.get(Integer.parseInt(key));
                NBTTagCompound cfg = nbt.func_74775_l(key);
                if (cfg.func_82582_d()) continue;
                Dimensionstack.loadSettings(sp, cfg);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        cfgModified = false;
    }

    public static void save(NBTTagCompound nbt, boolean client) {
        NBTTagCompound cfg = Dimensionstack.saveSettings(INSTANCE, client);
        if (!cfg.func_82582_d()) {
            nbt.func_74782_a("global", (NBTBase)cfg);
        }
        IntArrayList open = new IntArrayList();
        for (PortalConfiguration pc : PortalConfiguration.dimensions.values()) {
            cfg = Dimensionstack.saveSettings(pc, client);
            if (!cfg.func_82582_d()) {
                nbt.func_74782_a(Integer.toString(pc.dimId), (NBTBase)cfg);
            }
            if (!pc.topOpen) continue;
            open.add(pc.dimId);
        }
        nbt.func_74783_a("topOpen", open.toIntArray());
        NBTTagList stacks = new NBTTagList();
        for (int[] stack : Dimensionstack.getStacks()) {
            stacks.func_74742_a((NBTBase)new NBTTagIntArray(stack));
        }
        nbt.func_74782_a("stacks", (NBTBase)stacks);
        nbt.func_74774_a("version", (byte)4);
    }

    public static ArrayList<int[]> getStacks() {
        PortalConfiguration bot;
        IntOpenHashSet bottoms = new IntOpenHashSet();
        IntOpenHashSet loops = new IntOpenHashSet();
        for (PortalConfiguration pc : PortalConfiguration.dimensions.values()) {
            bot = pc.bottom();
            if (bot == null) {
                loops.add(pc.dimId);
                continue;
            }
            if (bot == pc) continue;
            bottoms.add(bot.dimId);
        }
        ArrayList<int[]> stacks = new ArrayList<int[]>();
        IntArrayList stack = new IntArrayList();
        bot = bottoms.iterator();
        while (bot.hasNext()) {
            PortalConfiguration pc1;
            int d = (Integer)bot.next();
            stack.add(d);
            PortalConfiguration pc = PortalConfiguration.get(d);
            while ((pc1 = pc.up()) != null) {
                stack.add(pc1.dimId);
                pc = pc1;
            }
            stacks.add(stack.toIntArray());
            stack.clear();
        }
        while (!loops.isEmpty()) {
            int d = loops.iterator().nextInt();
            loops.rem(d);
            stack.add(d);
            PortalConfiguration pc = PortalConfiguration.get(d);
            for (PortalConfiguration pc1 = pc.up(); pc1 != pc; pc1 = pc1.up()) {
                int d1 = pc1.dimId;
                loops.rem(d1);
                stack.add(d1);
            }
            stack.add(d);
            stacks.add(stack.toIntArray());
            stack.clear();
        }
        return stacks;
    }

    /*
     * Unable to fully structure code
     */
    public void loadWorldSettings(File dir) {
        reload = true;
        if (this.defaultCfg == null) {
            this.defaultCfg = new NBTTagCompound();
            Dimensionstack.save(this.defaultCfg, false);
            reload = false;
        }
        dir.mkdirs();
        file = new File(dir, "dimensionstack.dat");
        try {
            if (!file.exists()) ** GOTO lbl21
            nbt = CompressedStreamTools.func_74797_a((File)file);
            v = nbt.func_74771_c("version") & 255;
            if (v >= 4) {
                Dimensionstack.load(nbt);
                Main.LOG.info("Dimension stack configuration file for world {} sucessfully loaded.", (Object)dir.getName());
                reload = false;
            } else {
                Main.LOG.warn("Dimension stack configuration file has outdated format!");
                file.renameTo(new File(dir, "dimensionstack.dat.old"));
lbl21:
                // 2 sources

                CompressedStreamTools.func_74795_b((NBTTagCompound)this.defaultCfg, (File)file);
                Main.LOG.info("new dimension stack configuration file for world {} sucessfully created.", (Object)dir.getName());
            }
            this.cfgFile = file;
        }
        catch (IOException e) {
            this.cfgFile = null;
            e.printStackTrace();
        }
        if (reload) {
            Dimensionstack.load(this.defaultCfg);
        }
    }

    public boolean loadPreset(File file) {
        if (!file.exists()) {
            Main.LOG.error("Given preset dimension stack configuration file {} doesn't exist: loading config normally", (Object)file);
            return false;
        }
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_74797_a((File)file);
            int v = nbt.func_74771_c("version") & 0xFF;
            if (v < 4) {
                Main.LOG.warn("Preset dimension stack configuration file has outdated format!");
                return false;
            }
            Dimensionstack.load(nbt);
            Main.LOG.info("Preset dimension stack configuration file sucessfully loaded.");
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void reset() {
        if (this.defaultCfg == null) {
            return;
        }
        Dimensionstack.load(this.defaultCfg);
        this.defaultCfg = null;
    }

    @Override
    public void registerOreDisable() {
        OreGenHandler.register();
    }

    public void addRecipe(Parameters param) {
        String rcp = param.getString(0);
        if (rcp.equals(DIMENSION_STACK)) {
            double[] vec = param.getVectorOrAll(1);
            int[] stack = new int[vec.length];
            for (int i = 0; i < vec.length; ++i) {
                stack[i] = (int)vec[i];
            }
            PortalConfiguration.link(stack);
        } else if (rcp.equals(DIMENSION)) {
            int id = param.getIndex(1);
            Dimensionstack.setDimCreation(id, true);
            if (param.has(3)) {
                CustomWorldProps props = PortalConfiguration.get(id).getSettings(CustomWorldProps.class, true);
                switch (param.getString(2)) {
                    case "worldtype": {
                        props.chunkGen = 1;
                        break;
                    }
                    case "overworld": {
                        props.chunkGen = 2;
                        break;
                    }
                    case "nether": {
                        props.chunkGen = 3;
                    }
                }
                String string = props.biomeGen = param.param[3] == Nil.NIL ? "" : param.getString(3);
                if (param.has(10)) {
                    props.horizonHeight = (float)param.getNumber(4);
                    props.cloudHeight = (float)param.getNumber(5);
                    for (int i = 0; i < 5; ++i) {
                        if (!param.getBool(i + 6)) continue;
                        props.flags |= 1 << i;
                    }
                    double[] vec = param.getVectorOrAll(11);
                    if (vec.length == 4) {
                        props.fogColor = MathHelper.func_76125_a((int)((int)vec[0]), (int)0, (int)255) << 24 | MathHelper.func_76125_a((int)((int)(vec[1] * 255.0)), (int)0, (int)255) << 16 | MathHelper.func_76125_a((int)((int)(vec[2] * 255.0)), (int)0, (int)255) << 8 | MathHelper.func_76125_a((int)((int)(vec[3] * 255.0)), (int)0, (int)255);
                    }
                }
            }
        }
    }

    public static void initConfig(RecipeScriptContext.ConfigConstants cfg) {
        PortalConfiguration.retrogen = (byte)cfg.getNumber("retrogen_portals", 0.0);
        PortalConfiguration.defaultCeilY = (int)cfg.getNumber("dim_ceiling", (double)PortalConfiguration.defaultCeilY);
        cfg.get("dim_ceiling", CeilingInfo.class, (Object)new CeilingInfo());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerConfigGui(ICfgButtonHandler handler) {
        ((ClientProxy)Main.proxy).cfgButtons.add(handler);
    }

    @SubscribeEvent
    public void handShakeComplete(FMLNetworkEvent.CustomNetworkEvent event) {
        if (!(event.getWrappedEvent() instanceof NetworkHandshakeEstablished)) {
            return;
        }
        NetworkHandshakeEstablished nhse = (NetworkHandshakeEstablished)event.getWrappedEvent();
        if (nhse.side != Side.SERVER) {
            return;
        }
        String player = ((NetHandlerPlayServer)nhse.netHandler).field_147369_b.func_70005_c_();
        if (nhse.dispatcher.manager.func_150731_c()) {
            Main.LOG.info("Skipping dimension stack synchronization for integrated server owner {}", (Object)player);
            return;
        }
        Main.LOG.info("Sending dimension stack configuration packet to {}", (Object)player);
        NBTTagCompound nbt = new NBTTagCompound();
        Dimensionstack.save(nbt, true);
        nhse.dispatcher.sendProxy(new FMLProxyPacket(new PacketBuffer(Unpooled.buffer()).func_150786_a(nbt), CHANNEL));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPacketFromServer(FMLNetworkEvent.ClientCustomPacketEvent event) {
        if (event.getManager().func_150731_c()) {
            Main.LOG.warn("Ignoring dimension stack configuration packet for singleplayer ... which shouldn't have been send actually!");
            return;
        }
        try {
            NBTTagCompound nbt = ((PacketBuffer)event.getPacket().payload()).func_150793_b();
            Dimensionstack.load(nbt);
            Main.LOG.info("Dimension stack configuration from server sucessfully synchronized!");
        }
        catch (IOException e) {
            Main.LOG.error("Failed to decode dimension stack configuration packet from server:", (Throwable)e);
        }
    }

    private static class CeilingInfo
    implements IOperand {
        private CeilingInfo() {
        }

        public boolean asBool() throws Error {
            return true;
        }

        public Object value() {
            return this;
        }

        public IOperand get(IOperand idx) {
            return new Number((double)PortalConfiguration.get((int)idx.asIndex()).ceilY);
        }

        public void put(IOperand idx, IOperand val) {
            int y = val.asIndex();
            boolean flip = y < 0;
            if ((y = Math.abs(y)) <= 0 || y >= 256) {
                Lib.LOG.error(RecipeScriptContext.ERROR, "script attempted to set portal ceiling height to an invalid value {}", (Object)y);
                return;
            }
            PortalConfiguration pc = PortalConfiguration.get(idx.asIndex());
            pc.ceilY = y;
            pc.flipped = flip;
        }
    }
}

