/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.client.gui;

import cd4017be.dimstack.api.BlockReplacements;
import cd4017be.dimstack.api.IDimension;
import cd4017be.dimstack.api.util.BlockPredicate;
import cd4017be.dimstack.client.RenderUtil;
import cd4017be.dimstack.client.gui.AutoCompletions;
import cd4017be.dimstack.client.gui.BlockStateCompletion;
import cd4017be.dimstack.client.gui.GuiBlockSel;
import cd4017be.dimstack.client.gui.GuiList;
import cd4017be.dimstack.client.gui.GuiMenuBase;
import cd4017be.dimstack.client.gui.IDrawableEntry;
import cd4017be.lib.util.TooltipUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.init.Blocks;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class GuiBlockReplacement
extends GuiMenuBase
implements GuiPageButtonList.GuiResponder {
    private static final int WIDTH = 308;
    private static final int HEIGHT = 184;
    private final BlockReplacements cfg;
    private BlockStateCompletion complete;
    private GuiBlockSel block;
    private GuiBlockSel old;
    private GuiTextField maxY;
    private GuiTextField minY;
    private GuiButton rem;
    private GuiList<Repl> list;

    public GuiBlockReplacement(GuiScreen parent, IDimension dim) {
        super(parent);
        this.cfg = dim.getSettings(BlockReplacements.class, true);
    }

    @Override
    public void func_73866_w_() {
        List layers;
        super.func_73866_w_();
        this.complete = AutoCompletions.blockstates();
        this.title = TooltipUtil.translate((String)"gui.dimstack.replace");
        int x = (this.field_146294_l - 308) / 2;
        int y = (this.field_146295_m - 184) / 2;
        if (this.list != null) {
            layers = this.list.list;
        } else {
            layers = new ArrayList();
            for (BlockReplacements.Replacement gen : this.cfg.replacements) {
                layers.add(new Repl(gen));
            }
        }
        this.list = (GuiList)this.func_189646_b(new GuiList(1, x, y, 150, 162, 16, TooltipUtil.translate((String)"gui.dimstack.repl.list"), layers));
        this.func_189646_b((GuiButton)new GuiButtonExt(2, x, y + 184 - 20, 74, 20, TooltipUtil.translate((String)"gui.dimstack.new")));
        this.rem = this.func_189646_b((GuiButton)new GuiButtonExt(3, x + 76, y + 184 - 20, 74, 20, TooltipUtil.translate((String)"gui.dimstack.rem")));
        GuiLabel l = new GuiLabel(this.field_146289_q, 0, x += 158, y, 150, 10, 0x7F7F7F);
        this.field_146293_o.add(l);
        l.func_175202_a(TooltipUtil.translate((String)"gui.dimstack.repl.new"));
        this.block = new GuiBlockSel(4, this.field_146289_q, this.complete, x, y += 10, 150, 20);
        this.block.func_175207_a(this);
        this.textFields.add(this.block);
        l = new GuiLabel(this.field_146289_q, 1, x, y += 24, 150, 10, 0x7F7F7F);
        this.field_146293_o.add(l);
        l.func_175202_a(TooltipUtil.translate((String)"gui.dimstack.ore.repl"));
        this.old = new GuiBlockSel(5, this.field_146289_q, this.complete, x, y += 10, 150, 20).enableList();
        this.old.func_175207_a(this);
        this.textFields.add(this.old);
        this.minY = new GuiTextField(6, this.field_146289_q, x + 75 - 30, y += 32, 30, 20);
        this.textFields.add(this.minY);
        this.minY.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.maxY = new GuiTextField(7, this.field_146289_q, x + 150 - 30, y, 30, 20);
        this.textFields.add(this.maxY);
        this.maxY.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.select(-1);
    }

    private void select(int i) {
        this.list.sel = i;
        BlockReplacements.Replacement e = this.getSel();
        boolean enable = e != null;
        for (int j = this.field_146293_o.size() - 1; j >= 2; --j) {
            this.field_146293_o.remove(j);
        }
        this.minY.func_146189_e(false);
        this.maxY.func_146189_e(false);
        if (enable) {
            this.block.func_146180_a(BlockPredicate.serialize(e.repl));
            String s = e.target.toString();
            if (s.startsWith("[") && s.endsWith("]")) {
                s = s.substring(1, s.length() - 1);
            }
            this.old.func_146180_a(s);
            GuiLabel l = new GuiLabel(this.field_146289_q, 2, this.minY.field_146209_f - 45, this.minY.field_146210_g, 45, 20, 0xFFFFFF).func_175203_a();
            this.field_146293_o.add(l);
            for (String s2 : TooltipUtil.translate((String)"gui.dimstack.layer.bot").split("\n", 2)) {
                l.func_175202_a(s2);
            }
            this.minY.func_146180_a(Integer.toString(e.minY));
            this.minY.func_146189_e(true);
            l = new GuiLabel(this.field_146289_q, 3, this.maxY.field_146209_f - 45, this.maxY.field_146210_g, 45, 20, 0xFFFFFF).func_175203_a();
            this.field_146293_o.add(l);
            for (String s2 : TooltipUtil.translate((String)"gui.dimstack.layer.top").split("\n", 2)) {
                l.func_175202_a(s2);
            }
            this.maxY.func_146180_a(Integer.toString(e.maxY));
            this.maxY.func_146189_e(true);
        } else {
            this.block.func_146180_a("");
            this.old.func_146180_a("");
        }
        this.block.func_146184_c(enable);
        this.old.func_146184_c(enable);
        this.minY.func_146184_c(this.minY.func_146176_q());
        this.maxY.func_146184_c(this.maxY.func_146176_q());
        this.rem.field_146124_l = enable;
    }

    private BlockReplacements.Replacement getSel() {
        return this.list.sel >= 0 && this.list.sel < this.list.list.size() ? ((Repl)this.list.list.get((int)this.list.sel)).entry : null;
    }

    @Override
    public void func_73863_a(int mx, int my, float t) {
        super.func_73863_a(mx, my, t);
        this.block.drawOverlay();
        this.old.drawOverlay();
    }

    @Override
    protected void func_146284_a(GuiButton b) throws IOException {
        int s = this.list.sel;
        switch (b.field_146127_k) {
            case 1: {
                this.select(this.list.sel);
                break;
            }
            case 2: {
                if (++s < 0 || s > this.list.list.size()) {
                    s = this.list.list.size();
                }
                BlockReplacements.Replacement r = new BlockReplacements.Replacement(new BlockPredicate(new String[0]), Blocks.field_150350_a.func_176223_P(), 0, 0);
                this.cfg.replacements.add(r);
                this.list.list.add(s, new Repl(r));
                this.select(s);
                break;
            }
            case 3: {
                if (s < 0 || s >= this.list.list.size()) break;
                this.cfg.replacements.remove(((Repl)this.list.list.remove((int)s)).entry);
                this.select(-1);
                break;
            }
            default: {
                super.func_146284_a(b);
            }
        }
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
    }

    public void func_175319_a(int id, String value) {
        BlockReplacements.Replacement e = this.getSel();
        if (e == null) {
            return;
        }
        switch (id) {
            case 4: {
                e.repl = BlockPredicate.parse(value);
                break;
            }
            case 5: {
                e.target = new BlockPredicate(value.split(","));
                break;
            }
            case 6: {
                try {
                    e.minY = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 7: {
                try {
                    e.maxY = Integer.parseInt(value);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    static class Repl
    implements IDrawableEntry {
        final BlockReplacements.Replacement entry;

        Repl(BlockReplacements.Replacement entry) {
            this.entry = entry;
        }

        @Override
        public void draw(Minecraft mc, int x, int y, int w, int h, float t) {
            RenderUtil.drawPortrait(this.entry.repl, x + w - h, y, 0.0f, h);
            String s = TooltipUtil.format((String)"gui.dimstack.repl.e", (Object[])new Object[]{this.entry.minY, this.entry.maxY});
            mc.field_71466_p.func_78276_b(s, x + (w -= h + 1 + mc.field_71466_p.func_78256_a(s)), y + (h - mc.field_71466_p.field_78288_b) / 2, -256);
            s = this.entry.target.toString();
            s = s.substring(1, s.length() - 1);
            for (String s1 : s.split(",")) {
                if ((w -= h) < 4) {
                    return;
                }
                RenderUtil.drawPortrait(BlockPredicate.parse(s1.trim()), x + 2, y, 0.0f, h);
                x += h;
            }
        }
    }
}

