/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.block;

import cd4017be.dimstack.Objects;
import cd4017be.dimstack.core.PortalConfiguration;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.block.BaseBlock;
import cd4017be.lib.util.DimPos;
import cd4017be.lib.util.MovedBlock;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Portal
extends BaseBlock {
    public static final PropertyBool solidThis1 = PropertyBool.func_177716_a((String)"this1");
    public static final PropertyBool solidThis2 = PropertyBool.func_177716_a((String)"this2");
    public static final PropertyBool solidOther1 = PropertyBool.func_177716_a((String)"other1");
    public static final PropertyBool solidOther2 = PropertyBool.func_177716_a((String)"other2");
    public static final PropertyBool onCeiling = PropertyBool.func_177716_a((String)"ceil");
    private static final AxisAlignedBB fullCeil = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);
    private static final AxisAlignedBB halfCeil = new AxisAlignedBB(0.0, 1.0, 0.0, 1.0, 2.0, 1.0);
    private static final AxisAlignedBB emptyCeil = new AxisAlignedBB(0.0, 1.9375, 0.0, 1.0, 2.0, 1.0);
    private static final AxisAlignedBB fullFloor = new AxisAlignedBB(0.0, -1.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB halfFloor = new AxisAlignedBB(0.0, -1.0, 0.0, 1.0, 0.0, 1.0);
    private static final AxisAlignedBB emptyFloor = new AxisAlignedBB(0.0, -1.0, 0.0, 1.0, -0.9375, 1.0);
    public static int CREATE_PLATTFORM = 25;

    public Portal(String id, Material m) {
        super(id, m);
        this.func_149722_s();
        this.func_149752_b(Float.POSITIVE_INFINITY);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (world != null) {
            PortalConfiguration pc = PortalConfiguration.get(world);
            PortalConfiguration pc1 = pc.nextCeil();
            if (pc1 != null) {
                tooltip.add("\u00a7ey = " + pc.ceilY + "\u00a77 -> \u00a7f" + pc1);
            } else {
                tooltip.add("\u00a7e----");
            }
            tooltip.add("|  \u00a7f" + pc);
            pc1 = pc.nextFloor();
            if (pc1 != null) {
                tooltip.add("\u00a7ey = 0\u00a77 -> \u00a7f" + pc1);
            } else {
                tooltip.add("\u00a7e----");
            }
        }
        super.func_190948_a(stack, world, tooltip, advanced);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)solidOther1, (Comparable)Boolean.valueOf((meta & 1) != 0)).func_177226_a((IProperty)solidOther2, (Comparable)Boolean.valueOf((meta & 2) != 0)).func_177226_a((IProperty)solidThis1, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a((IProperty)solidThis2, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)solidOther1) != false ? 1 : 0) | ((Boolean)state.func_177229_b((IProperty)solidOther2) != false ? 2 : 0) | ((Boolean)state.func_177229_b((IProperty)solidThis1) != false ? 4 : 0) | ((Boolean)state.func_177229_b((IProperty)solidThis2) != false ? 8 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{solidThis1, solidThis2, solidOther1, solidOther2, onCeiling});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)onCeiling, (Comparable)Boolean.valueOf(pos.func_177956_o() != 0));
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack item;
        boolean side;
        boolean solid = (Boolean)state.func_177229_b((IProperty)solidOther1);
        boolean bl = side = facing != EnumFacing.UP && facing != EnumFacing.DOWN;
        if (solid && !side) {
            return false;
        }
        if (!(world instanceof WorldServer)) {
            return true;
        }
        if (player instanceof EntityPlayerMP && !(player instanceof FakePlayer) && !(item = player.func_184586_b(hand)).func_190926_b()) {
            DimPos posT;
            DimPos posO;
            if (solid) {
                pos = pos.func_177972_a(facing);
            }
            if ((posO = PortalConfiguration.getAdjacentPos(posT = new DimPos((Vec3i)pos, world))) == null) {
                return false;
            }
            this.syncStates(posO, posT);
            int ceil = posO.func_177956_o() == 0 ? 1 : -1;
            posO = posO.add(0, solid || (Boolean)posT.getBlock().func_177229_b((IProperty)solidOther2) != false ? ceil : ceil << 1, 0);
            this.tryPlaceBlock(posO, player, item, hand, facing, hitX, hitY, hitZ);
            player.func_71020_j(4.0f);
            return true;
        }
        return false;
    }

    public void tryPlaceBlock(DimPos pos, EntityPlayer player, ItemStack stack, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block block1;
        WorldServer world;
        IBlockState state = pos.getBlock();
        Block block = state.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)(world = pos.getWorldServer()), (BlockPos)pos)) {
            return;
        }
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((EntityPlayer)player, (EnumHand)hand, (BlockPos)pos, (EnumFacing)facing, (Vec3d)new Vec3d((double)hitX, (double)hitY, (double)hitZ));
        if (event.isCanceled()) {
            return;
        }
        if (stack.func_77973_b() instanceof ItemBlock && !player.func_189808_dh() && ((block1 = ((ItemBlock)stack.func_77973_b()).func_179223_d()) instanceof BlockCommandBlock || block1 instanceof BlockStructure)) {
            return;
        }
        if (event.getUseItem() == Event.Result.DENY) {
            return;
        }
        if (player.func_184812_l_()) {
            int j = stack.func_77960_j();
            int i = stack.func_190916_E();
            stack.func_179546_a(player, (World)world, (BlockPos)pos, hand, facing, hitX, hitY, hitZ);
            stack.func_77964_b(j);
            stack.func_190920_e(i);
        } else {
            ItemStack copyBeforeUse = stack.func_77946_l();
            stack.func_179546_a(player, (World)world, (BlockPos)pos, hand, facing, hitX, hitY, hitZ);
            if (stack.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyBeforeUse, (EnumHand)hand);
            }
        }
        Portal.fixSync(pos, state);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world instanceof WorldServer && player instanceof EntityPlayerMP && !(player instanceof FakePlayer)) {
            if (!player.func_184812_l_() && player.func_71024_bL().func_75116_a() <= 1) {
                return;
            }
            DimPos posT = new DimPos((Vec3i)pos, world);
            DimPos posO = PortalConfiguration.getAdjacentPos(posT);
            if (posO == null) {
                return;
            }
            this.syncStates(posO, posT);
            boolean ceil = posO.func_177956_o() != 0;
            IBlockState state = posT.getBlock();
            if (((Boolean)state.func_177229_b((IProperty)solidOther1)).booleanValue()) {
                posO = posO.add(0, ceil ? -1 : 1, 0);
            } else if (((Boolean)state.func_177229_b((IProperty)solidOther2)).booleanValue()) {
                posO = posO.add(0, ceil ? -2 : 2, 0);
            } else {
                return;
            }
            this.tryHarvestBlock(posO, (EntityPlayerMP)player, posT);
            player.func_71020_j(4.0f);
        }
    }

    private void tryHarvestBlock(DimPos pos, EntityPlayerMP player, DimPos orPos) {
        IBlockState state = pos.getBlock();
        WorldServer world = pos.getWorldServer();
        if (!player.func_184812_l_() && state.func_185903_a((EntityPlayer)player, (World)world, (BlockPos)pos) <= 0.0f) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        Block block = state.func_177230_c();
        boolean preCancelEvent = player.func_175149_v() || !player.func_175142_cm() && (stack.func_190926_b() || !stack.func_179544_c(block));
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent((World)world, (BlockPos)pos, state, (EntityPlayer)player);
        event.setCanceled(preCancelEvent);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        TileEntity tileentity = pos.getTileEntity();
        if ((block instanceof BlockCommandBlock || block instanceof BlockStructure) && !player.func_189808_dh()) {
            return;
        }
        if (!stack.func_190926_b() && stack.func_77973_b().onBlockStartBreak(stack, (BlockPos)pos, (EntityPlayer)player)) {
            return;
        }
        orPos.getWorld().func_180498_a((EntityPlayer)player, 2001, (BlockPos)orPos, Block.func_176210_f((IBlockState)state));
        if (player.func_184812_l_()) {
            if (!block.removedByPlayer(state, (World)world, (BlockPos)pos, (EntityPlayer)player, false)) {
                return;
            }
            block.func_176206_d((World)world, (BlockPos)pos, state);
        } else {
            int exp;
            ItemStack itemstack2 = stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l();
            boolean flag = state.func_177230_c().canHarvestBlock((IBlockAccess)world, (BlockPos)pos, (EntityPlayer)player);
            if (!stack.func_190926_b()) {
                stack.func_179548_a((World)world, state, (BlockPos)pos, (EntityPlayer)player);
                if (stack.func_190926_b()) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)itemstack2, (EnumHand)EnumHand.MAIN_HAND);
                }
            }
            if (!block.removedByPlayer(state, (World)world, (BlockPos)pos, (EntityPlayer)player, flag)) {
                return;
            }
            block.func_176206_d((World)world, (BlockPos)pos, state);
            if (flag) {
                block.func_180657_a((World)world, (EntityPlayer)player, (BlockPos)pos, state, tileentity, itemstack2);
            }
            if ((exp = event.getExpToDrop()) > 0) {
                block.func_180637_b((World)world, (BlockPos)pos, exp);
            }
        }
        Portal.fixSync(pos, state);
    }

    private static void fixSync(DimPos pos, IBlockState old) {
        WorldServer world = pos.getWorldServer();
        if (!world.func_175726_f((BlockPos)pos).func_150802_k()) {
            PortalConfiguration.get(pos.dimId).func_184376_a((World)world, (BlockPos)pos, old, pos.getBlock(), 3);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (world instanceof WorldServer && !((Boolean)state.func_177229_b((IProperty)solidOther1)).booleanValue()) {
            boolean flip;
            AxisAlignedBB box = entity.func_174813_aQ();
            if (box.field_72337_e - box.field_72338_b > 1.0 && ((Boolean)state.func_177229_b((IProperty)solidOther2)).booleanValue()) {
                return;
            }
            int y = pos.func_177956_o();
            double py = entity.field_70181_x;
            if (y == 0 ? box.field_72337_e + py > 1.0 : box.field_72338_b + py < (double)y) {
                return;
            }
            DimPos posT = new DimPos((Vec3i)pos, world);
            DimPos posO = PortalConfiguration.getAdjacentPos(posT);
            if (posO == null) {
                if (entity instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)entity).func_145747_a((ITextComponent)new TextComponentString("\u00a74ERROR: target dimension doesn't exist!"));
                    entity.field_70181_x = 0.0;
                    entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + (y == 0 ? 1.0 - box.field_72338_b : (double)y - box.field_72337_e), entity.field_70161_v);
                }
                return;
            }
            int yO = posO.func_177956_o();
            if (y == 0) {
                if (yO != 0) {
                    py = entity.field_70163_u + (double)yO - 1.0;
                    if (box.field_72337_e > 1.0) {
                        py -= box.field_72337_e - 1.0;
                    }
                    flip = false;
                } else {
                    py = entity.field_70163_u - box.field_72338_b + 1.0 + Math.max(1.0 - box.field_72337_e, 0.0);
                    flip = true;
                }
            } else if (yO == 0) {
                py = entity.field_70163_u - (double)y + 1.0;
                if (box.field_72338_b < (double)y) {
                    py -= box.field_72338_b - (double)y;
                }
                flip = false;
            } else {
                py = entity.field_70163_u - box.field_72337_e + (double)yO + Math.min((double)y - box.field_72338_b, 0.0);
                flip = true;
            }
            this.syncStates(posO, posT);
            if (MathHelper.func_76128_c((double)entity.field_70165_t) != pos.func_177958_n() || MathHelper.func_76128_c((double)entity.field_70161_v) != pos.func_177952_p() || ((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)solidOther1)).booleanValue()) {
                return;
            }
            int dim = posO.dimId;
            double nx = entity.field_70165_t;
            double ny = py;
            double nz = entity.field_70161_v;
            TickRegistry.instance.updates.add(() -> {
                if (entity.field_71093_bK != dim || Math.abs(entity.field_70163_u - ny) > (double)entity.field_70131_O + 4.0) {
                    if (flip) {
                        entity.field_70181_x = -entity.field_70181_x;
                        entity.field_70143_R = 0.0f;
                    }
                    MovedBlock.moveEntity((Entity)entity, (int)dim, (double)nx, (double)ny, (double)nz);
                    if (CREATE_PLATTFORM > 0 && entity instanceof EntityPlayer && posO.func_177956_o() == 0) {
                        Portal.createPlattform(posO.getWorldServer(), (int)Math.floor(nx), (int)Math.floor(nz));
                    }
                }
            });
        }
    }

    private static void createPlattform(WorldServer world, int x, int z) {
        DimPos pos = new DimPos(x, 0, z, world);
        IBlockState state = pos.getBlock();
        if (state.func_185904_a() != Objects.M_PORTAL) {
            return;
        }
        if (((Boolean)state.func_177229_b((IProperty)solidOther1)).booleanValue()) {
            return;
        }
        pos.setBlock(state.func_177226_a((IProperty)solidOther1, (Comparable)Boolean.valueOf(true)));
        pos.getWorld().func_180497_b((BlockPos)pos, state.func_177230_c(), CREATE_PLATTFORM, 0);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.func_72872_a(EntityPlayer.class, new AxisAlignedBB(pos.func_177984_a())).isEmpty()) {
            this.syncStates(new DimPos((Vec3i)pos, world), state);
        } else if (CREATE_PLATTFORM > 0) {
            world.func_180497_b(pos, (Block)this, CREATE_PLATTFORM, 0);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_180649_a(world, pos, player);
        return false;
    }

    private void syncStates(DimPos oPos, DimPos tPos) {
        IBlockState oState = oPos.getBlock();
        IBlockState tState = tPos.getBlock();
        if (oState.func_185904_a() != Objects.M_PORTAL) {
            int ceil = oPos.func_177956_o() != 0 ? -1 : 1;
            oState = this.func_176223_P().func_177226_a((IProperty)onCeiling, (Comparable)Boolean.valueOf(ceil < 0)).func_177226_a((IProperty)solidThis1, (Comparable)Boolean.valueOf(Portal.isSolid(((DimPos)oPos.func_177981_b(ceil)).getBlock()))).func_177226_a((IProperty)solidThis2, (Comparable)Boolean.valueOf(Portal.isSolid(((DimPos)oPos.func_177981_b(ceil << 1)).getBlock())));
        }
        IBlockState ntState = tState.func_177226_a((IProperty)solidOther2, oState.func_177229_b((IProperty)solidThis2)).func_177226_a((IProperty)solidOther1, oState.func_177229_b((IProperty)solidThis1));
        IBlockState noState = oState.func_177226_a((IProperty)solidOther2, tState.func_177229_b((IProperty)solidThis2)).func_177226_a((IProperty)solidOther1, tState.func_177229_b((IProperty)solidThis1));
        if (ntState != tState) {
            tPos.setBlock(ntState);
        }
        if (noState != oState) {
            oPos.setBlock(noState);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        PortalConfiguration pc = PortalConfiguration.get(world);
        int y = pos.func_177956_o();
        if (!(placer instanceof EntityPlayer) || !((EntityPlayer)placer).func_184812_l_() || y != 0 || pc.nextFloor() == null || y != pc.ceilHeight() || pc.nextCeil() == null) {
            placer.func_145747_a((ITextComponent)new TextComponentString("This block is meant to be auto generated as part of the bottom and/or top portal layer of this world!"));
            world.func_175698_g(pos);
            return;
        }
        this.func_189540_a(state, world, pos, (Block)this, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!(world instanceof WorldServer)) {
            return;
        }
        if (fromPos.func_177958_n() != pos.func_177958_n() || fromPos.func_177952_p() != pos.func_177952_p()) {
            return;
        }
        int dy = fromPos.func_177956_o() - pos.func_177956_o();
        IBlockState stateSrc = world.func_180495_p(fromPos);
        if (Portal.isSolid(stateSrc) ^ (Boolean)state.func_177229_b((IProperty)(dy >= -1 && dy <= 1 ? solidThis1 : solidThis2))) {
            this.syncStates(new DimPos((Vec3i)pos, world), state);
        }
        if (dy == -1 && stateSrc.func_177230_c() instanceof BlockRailBase) {
            this.makeRailsConnect(state, world, pos, stateSrc, fromPos);
        }
    }

    public void syncStates(DimPos posT, IBlockState stateT) {
        DimPos posO = PortalConfiguration.getAdjacentPos(posT);
        if (posO == null) {
            return;
        }
        IBlockState stateO = posO.getBlock();
        if (stateO.func_185904_a() != Objects.M_PORTAL) {
            stateO = this.func_176223_P().func_177226_a((IProperty)onCeiling, (Comparable)Boolean.valueOf(posO.func_177956_o() != 0));
        }
        int ceilO = posO.func_177956_o() != 0 ? -1 : 1;
        int ceilT = posT.func_177956_o() != 0 ? -1 : 1;
        boolean this1 = Portal.isSolid(((DimPos)posT.func_177981_b(ceilT)).getBlock());
        boolean this2 = Portal.isSolid(((DimPos)posT.func_177981_b(ceilT << 1)).getBlock());
        boolean other1 = Portal.isSolid(((DimPos)posO.func_177981_b(ceilO)).getBlock());
        boolean other2 = Portal.isSolid(((DimPos)posO.func_177981_b(ceilO << 1)).getBlock());
        posT.setBlock(stateT.func_177226_a((IProperty)solidThis1, (Comparable)Boolean.valueOf(this1)).func_177226_a((IProperty)solidThis2, (Comparable)Boolean.valueOf(this2)).func_177226_a((IProperty)solidOther1, (Comparable)Boolean.valueOf(other1)).func_177226_a((IProperty)solidOther2, (Comparable)Boolean.valueOf(other2)));
        posO.setBlock(stateO.func_177226_a((IProperty)solidThis1, (Comparable)Boolean.valueOf(other1)).func_177226_a((IProperty)solidThis2, (Comparable)Boolean.valueOf(other2)).func_177226_a((IProperty)solidOther1, (Comparable)Boolean.valueOf(this1)).func_177226_a((IProperty)solidOther2, (Comparable)Boolean.valueOf(this2)));
    }

    public static boolean isSolid(IBlockState state) {
        return state.func_185904_a().func_76230_c();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        boolean ceil;
        boolean bl = ceil = pos.func_177956_o() != 0;
        return ((Boolean)state.func_177229_b((IProperty)solidOther1)).booleanValue() ? (ceil ? fullCeil : fullFloor) : (((Boolean)state.func_177229_b((IProperty)solidOther2)).booleanValue() ? (ceil ? halfCeil : halfFloor) : (ceil ? emptyCeil : emptyFloor));
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean ceil;
        boolean bl = ceil = pos.func_177956_o() != 0;
        return ((Boolean)state.func_177229_b((IProperty)solidOther1)).booleanValue() ? (ceil ? fullCeil : fullFloor) : (((Boolean)state.func_177229_b((IProperty)solidOther2)).booleanValue() ? (ceil ? halfCeil : halfFloor) : field_185506_k);
    }

    public int func_149717_k(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)solidOther1)).booleanValue() ? (((Boolean)state.func_177229_b((IProperty)solidOther2)).booleanValue() ? 255 : 3) : ((Boolean)state.func_177229_b((IProperty)solidOther2) != false ? 1 : 0);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)solidOther1) != false || (Boolean)state.func_177229_b((IProperty)solidOther2) != false ? 0 : 8;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        BlockPos pos1 = pos.func_177972_a(side);
        boolean ceil = pos.func_177956_o() != 0;
        switch (side) {
            case UP: {
                return ceil || (Boolean)state.func_177229_b((IProperty)solidOther1) == false || !world.func_180495_p(pos1).doesSideBlockRendering(world, pos1, EnumFacing.DOWN);
            }
            case DOWN: {
                return !ceil || (Boolean)state.func_177229_b((IProperty)solidOther1) == false || !world.func_180495_p(pos1).doesSideBlockRendering(world, pos1, EnumFacing.UP);
            }
        }
        IBlockState other = world.func_180495_p(pos1);
        if (other.func_177230_c() != this) {
            return !other.doesSideBlockRendering(world, pos1, side.func_176734_d());
        }
        return (Boolean)state.func_177229_b((IProperty)solidOther1) != false && (Boolean)other.func_177229_b((IProperty)solidOther1) == false || (Boolean)state.func_177229_b((IProperty)solidOther2) != false && (Boolean)other.func_177229_b((IProperty)solidOther2) == false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return (Boolean)state.func_177229_b((IProperty)solidOther1);
    }

    public boolean isFullyOpaque(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)solidOther1);
    }

    public boolean func_149662_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)solidOther1);
    }

    public boolean func_149686_d(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)solidOther1);
    }

    public boolean func_149721_r(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)solidOther1);
    }

    public boolean func_176214_u(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)solidOther1);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)solidOther1)).booleanValue() || rand.nextInt(4) != 0) {
            return;
        }
        int by = pos.func_177956_o();
        double x = (double)pos.func_177958_n() + (double)rand.nextFloat();
        double y = by == 0 ? 1.0 : (double)by;
        double z = (double)pos.func_177952_p() + (double)rand.nextFloat();
        world.func_175688_a(EnumParticleTypes.TOWN_AURA, x, y, z, 0.0, 0.0, 0.0, new int[0]);
    }

    private void makeRailsConnect(IBlockState state, World world, BlockPos pos, IBlockState railState, BlockPos railPos) {
        BlockRailBase rail = (BlockRailBase)railState.func_177230_c();
        if (!rail.canMakeSlopes((IBlockAccess)world, railPos)) {
            return;
        }
        BlockRailBase.EnumRailDirection dir = (BlockRailBase.EnumRailDirection)railState.func_177229_b(rail.func_176560_l());
        switch (dir) {
            case EAST_WEST: {
                boolean east = this.canRailAscent(world, railPos.func_177974_f());
                boolean west = this.canRailAscent(world, railPos.func_177976_e());
                if (!east ^ west) {
                    return;
                }
                dir = east ? BlockRailBase.EnumRailDirection.ASCENDING_EAST : BlockRailBase.EnumRailDirection.ASCENDING_WEST;
                break;
            }
            case NORTH_SOUTH: {
                boolean north = this.canRailAscent(world, railPos.func_177978_c());
                boolean south = this.canRailAscent(world, railPos.func_177968_d());
                if (!north ^ south) {
                    return;
                }
                dir = north ? BlockRailBase.EnumRailDirection.ASCENDING_NORTH : BlockRailBase.EnumRailDirection.ASCENDING_SOUTH;
                break;
            }
            default: {
                return;
            }
        }
        world.func_175656_a(railPos, railState.func_177226_a(rail.func_176560_l(), (Comparable)dir));
    }

    private boolean canRailAscent(World world, BlockPos pos) {
        if (!world.func_180495_p(pos).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos = pos.func_177984_a());
        if (state.func_185904_a() != Objects.M_PORTAL || ((Boolean)state.func_177229_b((IProperty)solidOther1)).booleanValue()) {
            return false;
        }
        DimPos posO = PortalConfiguration.getAdjacentPos(new DimPos((Vec3i)pos, world));
        if (posO == null) {
            return false;
        }
        return BlockRailBase.func_176562_d((World)posO.getWorld(), (BlockPos)(posO.func_177956_o() == 0 ? posO.func_177984_a() : posO.func_177977_b()));
    }
}

