/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.aenetvistool.client;

import codechicken.lib.colour.Colour;
import codechicken.lib.lighting.LightModel;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.UV;
import codechicken.lib.vec.uv.UVRotation;
import codechicken.lib.vec.uv.UVScale;
import codechicken.lib.vec.uv.UVTransformation;
import codechicken.lib.vec.uv.UVTranslation;
import com.brandon3055.aenetvistool.client.NetRenderManager;
import com.brandon3055.aenetvistool.data.NetworkData;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.client.particle.IGLFXHandler;
import com.brandon3055.brandonscore.lib.Vec3D;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class NetPartRenderer
extends BCParticle {
    public static ResourceLocation texture = new ResourceLocation("aenetvistool", "textures/texture_sheet.png");
    private static Minecraft mc = Minecraft.func_71410_x();
    private static CCModel nodeModel14;
    private static CCModel nodeModel12;
    private static CCModel nodeModel10;
    private static CCModel nodeModel8;
    private static CCModel nodeModel6;
    private static CCModel cableModel;
    private static CCModel denseCableModel;
    private static CCModel[] busModels;
    private static double tpx;
    private static double mpx;
    @Deprecated
    private static Rotation[] connectionRotations;
    private NetworkData.NetNode node;
    private int colourRGBA = 0;
    private int keepAlive = 10;
    private boolean cableConnections = true;
    private boolean cableNodes = true;
    private boolean machineNodes = true;
    private boolean highlightInactive = true;
    private static final FXHandler FX_HANDLER;

    public NetPartRenderer(World worldIn, Vec3D pos, NetworkData.NetNode node) {
        super(worldIn, pos);
        this.node = node;
        this.func_189213_a();
    }

    public int func_70537_b() {
        return 0;
    }

    public boolean isRawGLParticle() {
        return true;
    }

    public IGLFXHandler getFXHandler() {
        return FX_HANDLER;
    }

    public void update() {
        this.keepAlive = 10;
    }

    public void func_189213_a() {
        if (this.keepAlive-- <= 0 || NetRenderManager.toolData == null) {
            this.func_187112_i();
            return;
        }
        float rx = (float)(this.field_187126_f - field_70556_an);
        float ry = (float)(this.field_187127_g - field_70554_ao);
        float rz = (float)(this.field_187128_h - field_70555_ap);
        float dSq = rx * rx + ry * ry + rz * rz;
        float fadeFac = 8.0f;
        float d = MathHelper.clip((float)((float)Math.log(dSq / 10.0f) / fadeFac), (float)0.0f, (float)0.5f);
        float c = 1.0f - d;
        int rgbColour = 0;
        switch (this.node.type) {
            case CABLE: {
                rgbColour = NetRenderManager.toolData.cableNodeColour8;
                break;
            }
            case DENSE_CABLE: {
                rgbColour = NetRenderManager.toolData.cableNodeColour32;
                break;
            }
            case MACHINE8: {
                rgbColour = NetRenderManager.toolData.machineNodeColour8;
                break;
            }
            case MACHINE32: {
                rgbColour = NetRenderManager.toolData.machineNodeColour32;
            }
        }
        int[] colour = Colour.unpack((int)rgbColour);
        this.colourRGBA = Colour.packRGBA((int)((int)(c * (float)colour[1])), (int)((int)(c * (float)colour[2])), (int)((int)(c * (float)colour[3])), (int)255);
        this.cableConnections = NetRenderManager.toolData.enableCableConnections;
        this.cableNodes = NetRenderManager.toolData.enableCableNodes;
        this.machineNodes = NetRenderManager.toolData.enableMachineNodes;
        this.highlightInactive = NetRenderManager.toolData.highlightInactiveBuses;
    }

    public void func_180434_a(BufferBuilder buffer, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (!FXHandler.refreshRender) {
            return;
        }
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.bind(buffer);
        float rx = (float)this.field_187126_f;
        float ry = (float)this.field_187127_g;
        float rz = (float)this.field_187128_h;
        switch (this.node.type) {
            case CABLE: {
                if (!this.cableNodes) break;
                nodeModel6.render(ccrs, new IVertexOperation[]{new Translation((double)rx + 0.5, (double)ry + 0.5, (double)rz + 0.5), ColourMultiplier.instance((int)this.colourRGBA)});
                break;
            }
            case DENSE_CABLE: {
                if (!this.cableNodes) break;
                nodeModel8.render(ccrs, new IVertexOperation[]{new Translation((double)rx + 0.5, (double)ry + 0.5, (double)rz + 0.5), ColourMultiplier.instance((int)this.colourRGBA)});
                break;
            }
            case MACHINE8: {
                if (!this.machineNodes) break;
                nodeModel12.render(ccrs, new IVertexOperation[]{new Translation((double)rx + 0.5, (double)ry + 0.5, (double)rz + 0.5), ColourMultiplier.instance((int)this.colourRGBA)});
                break;
            }
            case MACHINE32: {
                if (!this.machineNodes) break;
                nodeModel14.render(ccrs, new IVertexOperation[]{new Translation((double)rx + 0.5, (double)ry + 0.5, (double)rz + 0.5), ColourMultiplier.instance((int)this.colourRGBA)});
            }
        }
        if (this.cableConnections) {
            Vector3 center = new Vector3(-0.5, -1.0, -0.5);
            for (NetworkData.NetConnection con : this.node.connections) {
                if (con.facing == null) continue;
                Rotation rotation = connectionRotations[con.facing.func_176745_a()];
                double so = this.node.type.so + con.targetType.so;
                switch (con.type) {
                    case CABLE: {
                        cableModel.render(ccrs, new IVertexOperation[]{new UVTranslation(tpx * 6.0 * (double)con.channelsUsed, 0.0), new Scale(1.0, so, 1.0).at(center).with((Transformation)new Translation(0.0, mpx * (double)this.node.type.to, 0.0)).with((Transformation)rotation.at(center).with((Transformation)new Translation((double)rx + 0.5, (double)(ry + 1.0f), (double)rz + 0.5)))});
                        break;
                    }
                    case DENSE_CABLE: {
                        denseCableModel.render(ccrs, new IVertexOperation[]{new UVTranslation(tpx * 6.0 * ((double)con.channelsUsed / 2.0), 0.0), new Scale(1.0, so, 1.0).at(center).with((Transformation)new Translation(0.0, mpx * (double)this.node.type.to, 0.0)).with((Transformation)rotation.at(center).with((Transformation)new Translation((double)rx + 0.5, (double)(ry + 1.0f), (double)rz + 0.5)))});
                        break;
                    }
                    case INTERNAL: {
                        break;
                    }
                }
            }
        }
        for (NetworkData.NetBus bus : this.node.busList) {
            if ((!this.cableNodes || bus.busType <= 0) && (bus.isActive || !this.highlightInactive)) continue;
            Rotation rotation = connectionRotations[bus.partLocation.getFacing().func_176745_a()];
            busModels[bus.busType].render(ccrs, new IVertexOperation[]{rotation.at(new Vector3(-0.5, -1.0, -0.5)).with((Transformation)new Translation((double)rx + 0.5, (double)(ry + 1.0f), (double)rz + 0.5)), ColourMultiplier.instance((int)(bus.isActive || !this.highlightInactive ? -1 : -16776961))});
        }
    }

    static {
        busModels = new CCModel[9];
        tpx = 0.0078125;
        mpx = 0.0625;
        connectionRotations = new Rotation[6];
        nodeModel14 = CCModel.quadModel((int)24).generateBlock(0, Cuboid6.full).apply((UVTransformation)new UVScale(14.0 * tpx, 14.0 * tpx).with((UVTransformation)new UVTranslation(0.0, 0.0))).apply((Transformation)new Scale(mpx * 14.1, mpx * 14.1, mpx * 14.1).with((Transformation)new Translation(mpx * -15.05, mpx * -15.05, mpx * -15.05))).computeNormals().computeLighting(LightModel.standardLightModel);
        nodeModel12 = CCModel.quadModel((int)24).generateBlock(0, Cuboid6.full).apply((UVTransformation)new UVScale(12.0 * tpx, 12.0 * tpx).with((UVTransformation)new UVTranslation(tpx * 14.0, 0.0))).apply((Transformation)new Scale(mpx * 12.1, mpx * 12.1, mpx * 12.1).with((Transformation)new Translation(mpx * -14.05, mpx * -14.05, mpx * -14.05))).computeNormals().computeLighting(LightModel.standardLightModel);
        nodeModel10 = CCModel.quadModel((int)24).generateBlock(0, Cuboid6.full).apply((UVTransformation)new UVScale(10.0 * tpx, 10.0 * tpx).with((UVTransformation)new UVTranslation(tpx * 28.0, 0.0))).apply((Transformation)new Scale(mpx * 10.1, mpx * 10.1, mpx * 10.1).with((Transformation)new Translation(mpx * -13.05, mpx * -13.05, mpx * -13.05))).computeNormals().computeLighting(LightModel.standardLightModel);
        nodeModel8 = CCModel.quadModel((int)24).generateBlock(0, Cuboid6.full).apply((UVTransformation)new UVScale(8.0 * tpx, 8.0 * tpx).with((UVTransformation)new UVTranslation(tpx * 38.0, 0.0))).apply((Transformation)new Scale(mpx * 8.1, mpx * 8.1, mpx * 8.1).with((Transformation)new Translation(mpx * -12.05, mpx * -12.05, mpx * -12.05))).computeNormals().computeLighting(LightModel.standardLightModel);
        nodeModel6 = CCModel.quadModel((int)24).generateBlock(0, Cuboid6.full).apply((UVTransformation)new UVScale(6.0 * tpx, 6.0 * tpx).with((UVTransformation)new UVTranslation(tpx * 28.0, tpx * 10.0))).apply((Transformation)new Scale(mpx * 6.1, mpx * 6.1, mpx * 6.1).with((Transformation)new Translation(mpx * -11.05, mpx * -11.05, mpx * -11.05))).computeNormals().computeLighting(LightModel.standardLightModel);
        cableModel = CCModel.quadModel((int)16).generateBlock(0, Cuboid6.full, 3).apply((UVTransformation)new UVScale(16.0 * tpx, 3.0 * tpx).with((UVTransformation)new UVTranslation(tpx * 44.0, tpx * -25.0)).with(new UVRotation(1.5707963267948701).at(new UV(52.0 * tpx, 24.0 * tpx)))).apply((Transformation)new Scale(mpx * 4.1, mpx * 1.0, mpx * 4.1).with((Transformation)new Translation(mpx * -10.05, mpx * -16.0, mpx * -10.05))).computeNormals().computeLighting(LightModel.standardLightModel);
        denseCableModel = CCModel.quadModel((int)16).generateBlock(0, Cuboid6.full, 3).apply((UVTransformation)new UVScale(24.0 * tpx, 3.0 * tpx).with((UVTransformation)new UVTranslation(0.0, tpx * 36.0)).with(new UVRotation(1.5707963267948701).at(new UV(10.0 * tpx, 46.0 * tpx)))).apply((Transformation)new Scale(mpx * 6.1, mpx * 1.0, mpx * 6.1).with((Transformation)new Translation(mpx * -11.05, mpx * -16.0, mpx * -11.05))).computeNormals().computeLighting(LightModel.standardLightModel);
        for (int i = 0; i < busModels.length; ++i) {
            CCModel model = CCModel.quadModel((int)24);
            Vertex5[] verts = model.verts;
            double x1 = 0.0 - 12.05 * mpx;
            double y1 = 0.0 - 10.05 * mpx;
            double z1 = 0.0 - 12.05 * mpx;
            double x2 = mpx * 8.1 - 12.05 * mpx;
            double y2 = mpx * 2.1 - 10.05 * mpx;
            double z2 = mpx * 8.1 - 12.05 * mpx;
            double ts = 8.0 * tpx;
            double v = 0.0;
            int vi = 0;
            double u = 46.0 * tpx;
            verts[vi++] = new Vertex5(x1, y1, z2, u, v + ts, 0);
            verts[vi++] = new Vertex5(x1, y1, z1, u, v, 0);
            verts[vi++] = new Vertex5(x2, y1, z1, u + ts, v, 0);
            verts[vi++] = new Vertex5(x2, y1, z2, u + ts, v + ts, 0);
            u = (double)(54 + i * 8) * tpx;
            verts[vi++] = new Vertex5(x2, y2, z2, u + ts, v + ts, 1);
            verts[vi++] = new Vertex5(x2, y2, z1, u + ts, v, 1);
            verts[vi++] = new Vertex5(x1, y2, z1, u, v, 1);
            verts[vi++] = new Vertex5(x1, y2, z2, u, v + ts, 1);
            u = 54.0 * tpx;
            v = 8.0 * tpx;
            double ty = 2.0 * tpx;
            verts[vi++] = new Vertex5(x1, y1, z1, u, v + ty, 2);
            verts[vi++] = new Vertex5(x1, y2, z1, u, v, 2);
            verts[vi++] = new Vertex5(x2, y2, z1, u + ts, v, 2);
            verts[vi++] = new Vertex5(x2, y1, z1, u + ts, v + ty, 2);
            verts[vi++] = new Vertex5(x2, y1, z2, u + ts, v + ty, 3);
            verts[vi++] = new Vertex5(x2, y2, z2, u + ts, v, 3);
            verts[vi++] = new Vertex5(x1, y2, z2, u, v, 3);
            verts[vi++] = new Vertex5(x1, y1, z2, u, v + ty, 3);
            verts[vi++] = new Vertex5(x1, y1, z2, u + ts, v + ty, 4);
            verts[vi++] = new Vertex5(x1, y2, z2, u + ts, v, 4);
            verts[vi++] = new Vertex5(x1, y2, z1, u, v, 4);
            verts[vi++] = new Vertex5(x1, y1, z1, u, v + ty, 4);
            verts[vi++] = new Vertex5(x2, y1, z1, u, v + ty, 5);
            verts[vi++] = new Vertex5(x2, y2, z1, u, v, 5);
            verts[vi++] = new Vertex5(x2, y2, z2, u + ts, v, 5);
            verts[vi++] = new Vertex5(x2, y1, z2, u + ts, v + ty, 5);
            model.computeNormals().computeLighting(LightModel.standardLightModel);
            NetPartRenderer.busModels[i] = model;
        }
        for (EnumFacing facing : EnumFacing.values()) {
            Rotation rotation = null;
            switch (facing) {
                case DOWN: {
                    rotation = new Rotation(3.1415926535897403, 1.0, 0.0, 0.0);
                    break;
                }
                case UP: {
                    rotation = new Rotation(0.0, 1.0, 0.0, 0.0);
                    break;
                }
                case NORTH: {
                    rotation = new Rotation(1.5707963267948701, -1.0, 0.0, 0.0);
                    break;
                }
                case SOUTH: {
                    rotation = new Rotation(1.5707963267948701, 1.0, 0.0, 0.0);
                    break;
                }
                case WEST: {
                    rotation = new Rotation(1.5707963267948701, 0.0, 0.0, 1.0);
                    break;
                }
                case EAST: {
                    rotation = new Rotation(1.5707963267948701, 0.0, 0.0, -1.0);
                }
            }
            NetPartRenderer.connectionRotations[facing.func_176745_a()] = rotation;
        }
        FX_HANDLER = new FXHandler();
    }

    public static class FXHandler
    implements IGLFXHandler {
        public static int listIndex = 0;
        public static boolean refreshRender = true;

        public void preDraw(int layer, BufferBuilder vertexbuffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            if (layer != 0) {
                return;
            }
            if (listIndex == 0) {
                listIndex = GL11.glGenLists((int)1);
            }
            CCRenderState.instance().reset();
            float rx = (float)Particle.field_70556_an;
            float ry = (float)Particle.field_70554_ao;
            float rz = (float)Particle.field_70555_ap;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-rx), (float)(-ry), (float)(-rz));
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (refreshRender) {
                GL11.glNewList((int)listIndex, (int)4864);
                vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            }
        }

        public void postDraw(int layer, BufferBuilder buffer, Tessellator tessellator) {
            boolean noDepth;
            if (layer != 0) {
                return;
            }
            if (refreshRender) {
                Vec3d cameraPos = ActiveRenderInfo.getCameraPosition();
                buffer.func_181674_a((float)cameraPos.field_72450_a + (float)Particle.field_70556_an, (float)cameraPos.field_72448_b + (float)Particle.field_70554_ao, (float)cameraPos.field_72449_c + (float)Particle.field_70555_ap);
                tessellator.func_78381_a();
                GL11.glEndList();
                refreshRender = false;
            }
            if (noDepth = true) {
                GlStateManager.func_179097_i();
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179129_p();
            GlStateManager.func_179141_d();
            GlStateManager.func_179140_f();
            GlStateManager.func_179092_a((int)516, (float)0.01f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
            GL11.glCallList((int)listIndex);
            if (noDepth) {
                GlStateManager.func_179126_j();
            }
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
        }
    }
}

